/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.reflect.Method;
import java.util.List;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.SearchDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.windows.OutputWriter;

public final class PrintDetailsTask
implements Runnable {
    private static final int BUFFER_SIZE = 8;
    private final List<MatchingObject> objects;
    private final BasicSearchCriteria basicSearchCriteria;
    private final Node[] buffer = new Node[8];
    private int bufPos = 0;
    private SearchDisplayer displayer;
    private volatile boolean interrupted = false;

    public PrintDetailsTask(List<MatchingObject> list, BasicSearchCriteria basicSearchCriteria) {
        this.objects = list;
        this.basicSearchCriteria = basicSearchCriteria;
    }

    @Override
    public void run() {
        this.displayer = new SearchDisplayer();
        this.callDisplayerFromAWT("prepareOutput");
        int n = 0;
        for (MatchingObject nodeArray : this.objects) {
            Node[] n2;
            Node[] nodeArray2 = null;
            if (this.basicSearchCriteria != null && (n2 = nodeArray.getDetails()) != null && n2.length != 0) {
                nodeArray2 = n2;
            }
            if (nodeArray2 == null) continue;
            n = this.addToBuffer(nodeArray2, 0);
            while (n < 0) {
                this.printBuffer();
                int n3 = nodeArray2.length + n;
                n = this.addToBuffer(nodeArray2, n3);
            }
            if (n == 0) {
                this.printBuffer();
            }
            if (!this.interrupted) continue;
            break;
        }
        if (n != 0 && !this.interrupted) {
            int n3 = 8 - n;
            Node[] nodeArray = new Node[n3];
            System.arraycopy(this.buffer, 0, nodeArray, 0, n3);
            this.displayer.displayNodes(nodeArray);
        }
        this.callDisplayerFromAWT("finishDisplaying");
    }

    void stop() {
        this.interrupted = true;
    }

    Reference<OutputWriter> getOutputWriterRef() {
        return this.displayer.getOutputWriterRef();
    }

    private int addToBuffer(Node[] nodeArray, int n) {
        assert (n >= 0 && n <= nodeArray.length);
        int n2 = nodeArray.length - n;
        int n3 = this.bufPos + n2;
        int n4 = 8 - n3;
        if (n4 <= 0) {
            n2 += n4;
            n3 = 0;
        }
        System.arraycopy(nodeArray, n, this.buffer, this.bufPos, n2);
        this.bufPos = n3;
        return n4;
    }

    private void printBuffer() {
        this.displayer.displayNodes(this.buffer);
    }

    private Node[] concatNodeArrays(Node[] nodeArray, Node[] nodeArray2) {
        Node[] nodeArray3 = new Node[nodeArray.length + nodeArray2.length];
        System.arraycopy(nodeArray, 0, nodeArray3, 0, nodeArray.length);
        System.arraycopy(nodeArray2, 0, nodeArray3, nodeArray.length, nodeArray2.length);
        return nodeArray3;
    }

    private void callDisplayerFromAWT(String string) {
        try {
            Method method = SearchDisplayer.class.getDeclaredMethod(string, new Class[0]);
            Runnable runnable = () -> {
                try {
                    method.invoke((Object)this.displayer, (Object[])null);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }
}

