/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.actions;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.actions.LoadRecentSnapshot;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.ExternalDropHandler;
import org.openide.windows.TopComponent;

public class VisualVMDropHandler
extends ExternalDropHandler {
    private static final Logger LOG = Logger.getLogger(VisualVMDropHandler.class.getName());
    private static DataFlavor uriListDataFlavor;

    public boolean canDrop(DropTargetDragEvent e) {
        return this.canDrop(e.getCurrentDataFlavors());
    }

    public boolean canDrop(DropTargetDropEvent e) {
        return this.canDrop(e.getCurrentDataFlavors());
    }

    private boolean canDrop(DataFlavor[] flavors) {
        for (DataFlavor df : flavors) {
            if (!DataFlavor.javaFileListFlavor.equals(df) && !this.getUriListDataFlavor().equals(df)) continue;
            return true;
        }
        return false;
    }

    public boolean handleDrop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t == null) {
            return false;
        }
        List<File> fileList = this.getFileList(t);
        if (fileList == null || fileList.isEmpty()) {
            return false;
        }
        for (Component c = e.getDropTargetContext().getComponent(); c != null; c = c.getParent()) {
            if (!(c instanceof TopComponent)) continue;
            ((TopComponent)c).requestActive();
            break;
        }
        Object errMsg = null;
        if (fileList.size() == 1) {
            errMsg = this.openFile(fileList.get(0));
        } else {
            boolean hasSomeSuccess = false;
            ArrayList<String> fileErrs = null;
            for (File file : fileList) {
                String fileErr = this.openFile(file);
                if (fileErr == null) {
                    hasSomeSuccess = true;
                    continue;
                }
                if (fileErrs == null) {
                    fileErrs = new ArrayList<String>();
                }
                fileErrs.add(fileErr);
            }
            if (fileErrs != null) {
                String mainMsgKey = hasSomeSuccess ? "MSG_could_not_open_some_files" : "MSG_could_not_open_any_file";
                String mainMsg = NbBundle.getMessage(VisualVMDropHandler.class, (String)mainMsgKey);
                JPanel msgPanel = new JPanel();
                msgPanel.setLayout(new BoxLayout(msgPanel, 3));
                msgPanel.add(new JLabel(mainMsg));
                msgPanel.add(Box.createVerticalStrut(12));
                for (String fileErr : fileErrs) {
                    msgPanel.add(new JLabel(fileErr));
                }
                errMsg = msgPanel;
            }
        }
        if (errMsg != null) {
            VisualVMDropHandler.showWarningMessageFileNotOpened(errMsg);
            return false;
        }
        return true;
    }

    private static void showWarningMessageFileNotOpened(Object errMsg) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(errMsg, 2));
    }

    private List<File> getFileList(Transferable t) {
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (InvalidDnDOperationException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
            if (t.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String uriList = (String)t.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(uriList);
            }
        }
        catch (UnsupportedFlavorException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return null;
    }

    private String openFile(File file) {
        if (file.exists() && file.canRead() && file.isFile()) {
            List<SnapshotCategory> categories = RegisteredSnapshotCategories.sharedInstance().getOpenSnapshotCategories();
            for (SnapshotCategory category : categories) {
                if (!category.getFileFilter().accept(file)) continue;
                category.openSnapshot(file);
                LoadRecentSnapshot.instance().addFile(file);
                return null;
            }
            return MessageFormat.format(NbBundle.getMessage(VisualVMDropHandler.class, (String)"LoadRecentSnapshot_CannotLoadMsg"), file.getName());
        }
        return MessageFormat.format(NbBundle.getMessage(VisualVMDropHandler.class, (String)"LoadRecentSnapshot_NotAvailableMsg"), file.getName());
    }

    private DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException cnfE) {
                throw new AssertionError((Object)cnfE);
            }
        }
        return uriListDataFlavor;
    }

    private List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(data, "\r\n\u0000");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                File file = new File(new URI(s));
                list.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return list;
    }
}

