/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.common;

import java.util.Map;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.integration.IntegrationUtils;
import org.graalvm.visualvm.lib.jfluid.ProfilerEngineSettings;

public final class AttachSettings {
    public static final String PROP_ATTACH_DIRECT = "profiler.attach.direct";
    public static final String PROP_ATTACH_REMOTE = "profiler.attach.remote";
    public static final String PROP_ATTACH_DYNAMIC_JDK16 = "profiler.attach.dynamic.jdk16";
    public static final String PROP_ATTACH_HOST = "profiler.attach.host";
    public static final String PROP_ATTACH_PORT = "profiler.attach.port";
    public static final String PROP_ATTACH_DYNAMIC_PID = "profiler.attach.dynamic.pid";
    public static final String PROP_ATTACH_DYNAMIC_PROCESS_NAME = "profiler.attach.dynamic.processName";
    public static final String PROP_ATTACH_DYNAMIC_AUTO = "profiler.attach.dynamic.auto";
    public static final String PROP_ATTACH_TARGET_TYPE = "profiler.attach.target.type";
    public static final String PROP_ATTACH_SERVER_TYPE = "profiler.attach.server.type";
    public static final String PROP_ATTACH_HOST_OS = "profiler.attach.host.os";
    private String host = "";
    private String hostOS;
    private String serverType = "";
    private String targetType = "";
    private boolean direct = true;
    private boolean dynamic16 = false;
    private boolean remote = false;
    private int pid = -1;
    private String processName;
    private boolean autoSelect;
    private int transientPort = -1;

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDynamic16(boolean dynamic) {
        this.dynamic16 = dynamic;
    }

    public boolean isDynamic16() {
        return this.dynamic16;
    }

    public void setHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException();
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setHostOS(String hostOS) {
        this.hostOS = hostOS;
    }

    public String getHostOS() {
        return this.hostOS == null ? IntegrationUtils.getLocalPlatform(-1) : this.hostOS;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getPid() {
        return this.pid;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setAutoSelectProcess(boolean autoSelect) {
        this.autoSelect = autoSelect;
    }

    public boolean isAutoSelectProcess() {
        return this.autoSelect;
    }

    public void setPort(int port) {
        this.transientPort = port;
    }

    public int getPort() {
        if (this.transientPort != -1) {
            return this.transientPort;
        }
        return Profiler.getDefault().getGlobalProfilingSettings().getPortNo();
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void applySettings(ProfilerEngineSettings sharedSettings) {
        sharedSettings.setPortNo(this.getPort());
        if (this.remote) {
            sharedSettings.setRemoteHost(this.host);
        } else {
            sharedSettings.setRemoteHost("");
        }
        if (this.isDynamic16()) {
            sharedSettings.setInstrumentObjectInit(true);
        } else {
            sharedSettings.setInstrumentObjectInit(false);
        }
    }

    public void copyInto(AttachSettings as) {
        as.direct = this.direct;
        as.remote = this.remote;
        as.dynamic16 = this.dynamic16;
        as.pid = this.pid;
        as.processName = this.processName;
        as.autoSelect = this.autoSelect;
        as.host = this.host;
        as.targetType = this.targetType;
        as.serverType = this.serverType;
        as.hostOS = this.hostOS;
    }

    public String debug() {
        return this.toString();
    }

    public void load(Map props) {
        this.direct = Boolean.valueOf(ProfilingSettings.getProperty(props, PROP_ATTACH_DIRECT, "true"));
        this.remote = Boolean.valueOf(ProfilingSettings.getProperty(props, PROP_ATTACH_REMOTE, "false"));
        this.dynamic16 = Boolean.valueOf(ProfilingSettings.getProperty(props, PROP_ATTACH_DYNAMIC_JDK16, "false"));
        this.host = ProfilingSettings.getProperty(props, PROP_ATTACH_HOST, "");
        this.targetType = ProfilingSettings.getProperty(props, PROP_ATTACH_TARGET_TYPE, "");
        this.serverType = ProfilingSettings.getProperty(props, PROP_ATTACH_SERVER_TYPE, "");
        this.hostOS = ProfilingSettings.getProperty(props, PROP_ATTACH_HOST_OS, null);
        this.pid = Integer.parseInt(ProfilingSettings.getProperty(props, PROP_ATTACH_DYNAMIC_PID, "-1"));
        this.processName = ProfilingSettings.getProperty(props, PROP_ATTACH_DYNAMIC_PROCESS_NAME, null);
        this.autoSelect = Boolean.valueOf(ProfilingSettings.getProperty(props, PROP_ATTACH_DYNAMIC_AUTO, "false"));
    }

    public void store(Map props) {
        props.put(PROP_ATTACH_DIRECT, Boolean.toString(this.direct));
        props.put(PROP_ATTACH_REMOTE, Boolean.toString(this.remote));
        props.put(PROP_ATTACH_DYNAMIC_JDK16, Boolean.toString(this.dynamic16));
        props.put(PROP_ATTACH_HOST, this.host);
        props.put(PROP_ATTACH_TARGET_TYPE, this.targetType);
        props.put(PROP_ATTACH_SERVER_TYPE, this.serverType);
        if (this.hostOS == null) {
            props.remove(PROP_ATTACH_HOST_OS);
        } else {
            props.put(PROP_ATTACH_HOST_OS, this.hostOS);
        }
        if (this.pid == -1) {
            props.remove(PROP_ATTACH_DYNAMIC_PID);
        } else {
            props.put(PROP_ATTACH_DYNAMIC_PID, Integer.toString(this.pid));
        }
        if (this.processName == null) {
            props.remove(PROP_ATTACH_DYNAMIC_PROCESS_NAME);
        } else {
            props.put(PROP_ATTACH_DYNAMIC_PROCESS_NAME, this.processName);
        }
        if (!this.autoSelect) {
            props.remove(PROP_ATTACH_DYNAMIC_AUTO);
        } else {
            props.put(PROP_ATTACH_DYNAMIC_AUTO, Boolean.TRUE.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("target type =").append(this.targetType);
        sb.append("\n");
        sb.append("server type =").append(this.serverType);
        sb.append("\n");
        sb.append("remote =").append(this.remote);
        sb.append("\n");
        sb.append("direct =").append(this.direct);
        sb.append("\n");
        sb.append("dynamic JDK16 =").append(this.dynamic16);
        sb.append("\n");
        sb.append("pid =").append(this.pid);
        sb.append("\n");
        sb.append("process name =").append(this.processName);
        sb.append("\n");
        sb.append("auto select =").append(this.autoSelect);
        sb.append("\n");
        sb.append("host =").append(this.host);
        sb.append("\n");
        sb.append("host os =").append(this.hostOS == null ? IntegrationUtils.getLocalPlatform(-1) : this.hostOS);
        sb.append("\n");
        sb.append("transient port =").append(this.transientPort);
        sb.append("\n");
        return sb.toString();
    }
}

