/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.api.project;

import org.graalvm.visualvm.lib.common.SessionSettings;
import org.graalvm.visualvm.lib.profiler.api.JavaPlatform;
import org.graalvm.visualvm.lib.profiler.spi.project.ProjectProfilingSupportProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ProjectProfilingSupport {
    private static ProjectProfilingSupport DEFAULT;
    private final ProjectProfilingSupportProvider provider;

    public boolean isProfilingSupported() {
        return this.provider.isProfilingSupported();
    }

    public boolean isAttachSupported() {
        return this.provider.isAttachSupported();
    }

    public boolean isFileObjectSupported(FileObject fo) {
        return this.provider.isFileObjectSupported(fo);
    }

    public boolean areProfilingPointsSupported() {
        return this.provider.areProfilingPointsSupported();
    }

    public JavaPlatform getProjectJavaPlatform() {
        return this.provider.getProjectJavaPlatform();
    }

    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        return this.provider.checkProjectCanBeProfiled(profiledClassFile);
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        this.provider.setupProjectSessionSettings(ss);
    }

    public boolean startProfilingSession(FileObject profiledClassFile, boolean isTest) {
        return this.provider.startProfilingSession(profiledClassFile, isTest);
    }

    private ProjectProfilingSupport(ProjectProfilingSupportProvider provider) {
        this.provider = provider;
    }

    private static synchronized ProjectProfilingSupport defaultImpl() {
        if (DEFAULT == null) {
            DEFAULT = new ProjectProfilingSupport(new ProjectProfilingSupportProvider.Basic());
        }
        return DEFAULT;
    }

    public static ProjectProfilingSupport get(Lookup.Provider project) {
        ProjectProfilingSupportProvider provider;
        ProjectProfilingSupportProvider projectProfilingSupportProvider = provider = project != null ? (ProjectProfilingSupportProvider)project.getLookup().lookup(ProjectProfilingSupportProvider.class) : null;
        if (provider == null) {
            return ProjectProfilingSupport.defaultImpl();
        }
        return new ProjectProfilingSupport(provider);
    }
}

