/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.LifecycleManager;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

public class ModuleLifecycleManager
extends LifecycleManager {
    private final AtomicBoolean exiting = new AtomicBoolean(false);

    public ModuleLifecycleManager() {
        Runtime.getRuntime().addShutdownHook(new Thread("close modules"){

            @Override
            public void run() {
                if (System.getSecurityManager() instanceof TopSecurityManager) {
                    LifecycleManager.getDefault().exit();
                }
            }
        });
    }

    public void saveAll() {
    }

    public void exit() {
        this.exit(0);
    }

    public void exit(int n) {
        if (this.exiting.getAndSet(true)) {
            return;
        }
        if (Main.getModuleSystem().shutDown(new Runnable(){

            @Override
            public void run() {
                try {
                    CLIHandler.stopServer();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
            }
        })) {
            try {
                SessionManager.getDefault().close();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Exceptions.printStackTrace((Throwable)throwable);
            }
            if (System.getProperty("netbeans.close.no.exit") == null) {
                TopSecurityManager.exit((int)n);
            }
        }
    }

    public void markForRestart() throws UnsupportedOperationException {
        ModuleLifecycleManager.markReadyForRestart();
    }

    static void markReadyForRestart() throws UnsupportedOperationException {
        String string = TopSecurityManager.class.getClassLoader().getClass().getName();
        if (!string.endsWith(".Launcher$AppClassLoader") && !string.endsWith(".ClassLoaders$AppClassLoader")) {
            throw new UnsupportedOperationException("not running in regular module system, cannot restart");
        }
        File file = Places.getUserDirectory();
        if (file == null) {
            throw new UnsupportedOperationException("no userdir");
        }
        File file2 = new File(file, "var/restart");
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                throw new UnsupportedOperationException(iOException);
            }
        }
    }
}

