/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.graalvm.visualvm.lib.common.event.ProfilingStateListener;
import org.graalvm.visualvm.lib.common.event.SimpleProfilingStateAdapter;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerSession;
import org.graalvm.visualvm.lib.profiler.v2.impl.Bundle;
import org.openide.awt.StatusDisplayer;

public final class ProfilerStatus {
    private static final int STATUS_TIMEOUT = Integer.getInteger("org.openide.awt.StatusDisplayer.DISPLAY_TIME", 5000);
    private static final int STATUS_REFRESH = Math.min(STATUS_TIMEOUT - 250, 1500);
    private final ProfilerSession session;
    private volatile boolean logging;
    private final Timer refreshTimer;
    private int progressDots;
    private boolean wasRunning;
    private Reference<StatusDisplayer.Message> lastMessage;

    public static ProfilerStatus forSession(ProfilerSession session) {
        return new ProfilerStatus(session);
    }

    public void startSessionLogging() {
        this.logging = true;
        this.updateStatus();
    }

    public void stopSessionLogging() {
        this.logging = false;
        this.clearStatus();
    }

    public void log(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusDisplayer.Message message = StatusDisplayer.getDefault().setStatusText(text, 1000);
                message.clear(STATUS_TIMEOUT);
                ProfilerStatus.this.lastMessage = new WeakReference<StatusDisplayer.Message>(message);
            }
        });
    }

    private ProfilerStatus(ProfilerSession session) {
        this.session = session;
        this.refreshTimer = new Timer(STATUS_REFRESH, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerStatus.this.updateStatus();
            }
        });
        this.refreshTimer.setRepeats(false);
        session.addListener((ProfilingStateListener)new SimpleProfilingStateAdapter(){

            public void update() {
                ProfilerStatus.this.updateStatus();
            }
        });
    }

    private void updateStatus() {
        if (!this.logging) {
            return;
        }
        if (!ProfilerIDESettings.getInstance().getLogProfilerStatus()) {
            this.clearStatus();
            return;
        }
        switch (this.session.getState()) {
            case 1: {
                if (!this.wasRunning) break;
                this.log(Bundle.ProfilerStatus_profilerStopped());
                this.wasRunning = false;
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                this.log(Bundle.ProfilerStatus_profilerStarting());
                this.progressDots = 0;
                this.wasRunning = true;
                break;
            }
            case 16: {
                break;
            }
            case 128: {
                this.progressDots = 0;
                break;
            }
            case 4: {
                TargetAppRunner taRunner = this.session.getProfiler().getTargetAppRunner();
                ProfilingSessionStatus pss = taRunner.getProfilingSessionStatus();
                StringBuilder sb = new StringBuilder();
                switch (pss.currentInstrType) {
                    case 3: 
                    case 4: {
                        sb.append(Bundle.ProfilerStatus_profilerRunningMethods(pss.getNInstrMethods()));
                        break;
                    }
                    case 5: 
                    case 6: {
                        sb.append(Bundle.ProfilerStatus_profilerRunningClasses(pss.getNInstrClasses()));
                        break;
                    }
                    default: {
                        sb.append(Bundle.ProfilerStatus_profilerRunning());
                    }
                }
                for (int i = 0; i < this.progressDots; ++i) {
                    sb.append('.');
                }
                this.log(sb.toString());
                if (++this.progressDots > 3) {
                    this.progressDots = 0;
                }
                this.refreshTimer.start();
            }
        }
    }

    private void clearStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusDisplayer.Message message;
                StatusDisplayer.Message message2 = message = ProfilerStatus.this.lastMessage == null ? null : (StatusDisplayer.Message)ProfilerStatus.this.lastMessage.get();
                if (message != null) {
                    message.clear(0);
                }
            }
        });
    }
}

