/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.properties.PropertiesPanel;
import org.graalvm.visualvm.core.properties.PropertiesProvider;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.jvmstat.application.JvmstatApplication;
import org.graalvm.visualvm.jvmstat.application.PropertiesImpl;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModelFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class JstatdPropertiesProvider
extends PropertiesProvider<JvmstatApplication> {
    public static final int CATEGORY_JSTATD_CONNECTION = 200;

    JstatdPropertiesProvider() {
        super(NbBundle.getMessage(JstatdPropertiesProvider.class, (String)"LBL_JstatdAppProperties"), NbBundle.getMessage(JstatdPropertiesProvider.class, (String)"DESCR_JstatdAppProperties"), 200, 0);
    }

    public PropertiesPanel createPanel(JvmstatApplication dataSource) {
        PropertiesPanel panel = new PropertiesPanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        JLabel connectionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)connectionLabel, (String)NbBundle.getMessage(JstatdPropertiesProvider.class, (String)"LBL_Connection"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 0, 3, 5);
        panel.add((Component)connectionLabel, (Object)constraints);
        JTextField connectionField = new JTextField(JvmstatModelFactory.getJvmstatFor((Application)dataSource).getConnectionId());
        connectionLabel.setLabelFor(connectionField);
        connectionField.setCaretPosition(0);
        connectionField.setEditable(false);
        Dimension size = connectionField.getPreferredSize();
        size.width = 1;
        connectionField.setPreferredSize(size);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 0, 3, 0);
        panel.add((Component)connectionField, (Object)constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)Spacer.create(), (Object)constraints);
        return panel;
    }

    public boolean supportsDataSource(JvmstatApplication dataSource) {
        return dataSource != null && !PropertiesImpl.isLocalConnection(dataSource);
    }

    public void propertiesDefined(PropertiesPanel panel, JvmstatApplication dataSource) {
    }

    public void propertiesChanged(PropertiesPanel panel, JvmstatApplication dataSource) {
    }

    public void propertiesCancelled(PropertiesPanel panel, JvmstatApplication dataSource) {
    }
}

