/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.utils;

import java.time.Duration;
import java.time.Instant;

public final class ValuesChecker {
    private ValuesChecker() {
    }

    public static boolean isNAValue(Object o) {
        if (o instanceof Number) {
            if (o instanceof Long) {
                return ValuesChecker.isNALong((Long)o);
            }
            if (o instanceof Integer) {
                return ValuesChecker.isNAInteger((Integer)o);
            }
            if (o instanceof Double) {
                return ValuesChecker.isNADouble((Double)o);
            }
            if (o instanceof Float) {
                return ValuesChecker.isNAFloat((Float)o);
            }
            if (o instanceof Short) {
                return ValuesChecker.isNAShort((Short)o);
            }
            if (o instanceof Byte) {
                ValuesChecker.isNAByte((Byte)o);
            }
        } else {
            if (o instanceof Instant) {
                return ValuesChecker.isNAInstant((Instant)o);
            }
            if (o instanceof Duration) {
                return ValuesChecker.isNADuration((Duration)o);
            }
        }
        return false;
    }

    public static boolean isNALong(Long val) {
        return Long.MIN_VALUE == val;
    }

    public static boolean isNAInteger(Integer val) {
        return Integer.MIN_VALUE == val;
    }

    public static boolean isNADouble(Double val) {
        return Double.NEGATIVE_INFINITY == val || Double.isNaN(val);
    }

    public static boolean isNAFloat(Float val) {
        return Float.NEGATIVE_INFINITY == val.floatValue() || Float.isNaN(val.floatValue());
    }

    public static boolean isNAShort(Short val) {
        return Short.MIN_VALUE == val;
    }

    public static boolean isNAByte(Byte val) {
        return -128 == val;
    }

    public static boolean isNAInstant(Instant val) {
        return Instant.MIN.equals(val);
    }

    public static boolean isNADuration(Duration val) {
        return Long.MIN_VALUE == val.getSeconds();
    }

    public static boolean isMaxDuration(Duration val) {
        return 9223372036854775L == val.getSeconds() && 807000000 == val.getNano();
    }
}

