/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class SnapperProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_HELLO = 1;
    public static final int MSG_SENDING_START = 2;
    public static final int MSG_SENDING_FINISH = 3;
    public static final int MSG_SEND_EVENTS = 33;
    public static final int MSG_SEND_TECH_INFO = 35;
    public static final int MSG_UPDATE_CMS_NUM = 36;
    public static final int MSG_SEND_SYSTEM_INFO = 38;
    public static final int MSG_SEND_USER_PHONE_NUMBERS = 49;
    public static final int MSG_SEND_GPS_DATA = 50;
    public static final int MSG_SEND_LBS_DATA = 51;
    public static final int MSG_SEND_SYSTEM_STATUS = 52;
    public static final int MSG_SEND_TRANSIT_SETTINGS = 53;
    public static final int MSG_GET_SETTINGS = 54;
    public static final int MSG_SEND_CONCATENATED_PACKET = 55;
    public static final int MSG_SEND_DEBUG_INFO = 56;

    public SnapperProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int index, int type, String answer) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(75);
            response.writeByte(3);
            response.writeLongLE(0L);
            response.writeShortLE(0);
            response.writeIntLE(answer.length());
            response.writeIntLE(0);
            response.writeShortLE(index);
            response.writeByte(Checksum.sum(ByteBuffer.wrap(answer.getBytes(StandardCharsets.US_ASCII))));
            response.writeShortLE(type);
            response.writeCharSequence((CharSequence)answer, StandardCharsets.US_ASCII);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void decodeEvents(Position position, ByteBuf buf) {
        position.set("event", buf.readUnsignedByte());
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedIntLE();
        buf.readUnsignedByte();
    }

    private void decodeTechInfo(Position position, ByteBuf buf) {
        block4: for (int i = 0; i < 5; ++i) {
            buf.readUnsignedByte();
            short type = buf.readUnsignedByte();
            switch (type) {
                case 0: {
                    position.set("power", (double)buf.readUnsignedByte() * 0.1);
                    position.set("deviceTemp", buf.readByte());
                    position.set("rssi", buf.readUnsignedByte());
                    continue block4;
                }
                case 1: {
                    position.set("interiorTemp", buf.readByte());
                    position.set("engineTemp", buf.readByte());
                    buf.readUnsignedByte();
                    continue block4;
                }
                default: {
                    buf.skipBytes(3);
                }
            }
        }
    }

    private void decodeGpsData(Position position, ByteBuf buf) throws ParseException {
        String content = buf.readCharSequence(buf.readableBytes(), StandardCharsets.US_ASCII).toString();
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        int flags = Integer.parseInt(json.getString("f"), 16);
        if (!BitUtil.check(flags, 3)) {
            return;
        }
        position.setValid(BitUtil.check(flags, 1));
        if (!BitUtil.check(flags, 6)) {
            position.setLatitude(-position.getLatitude());
        }
        if (!BitUtil.check(flags, 7)) {
            position.setLongitude(-position.getLongitude());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        position.setTime(dateFormat.parse(json.getString("d") + json.getString("t").split("\\.")[0]));
        String lat = json.getString("la");
        position.setLatitude((double)Integer.parseInt(lat.substring(0, 2)) + Double.parseDouble(lat.substring(2)) / 60.0);
        String lon = json.getString("lo");
        position.setLongitude((double)Integer.parseInt(lon.substring(0, 3)) + Double.parseDouble(lon.substring(3)) / 60.0);
        position.setAltitude(Double.parseDouble(json.getString("a")));
        position.setSpeed(Double.parseDouble(json.getString("s")));
        position.setCourse(Double.parseDouble(json.getString("c")));
        position.set("sat", Integer.parseInt(json.getString("sv")));
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        byte header = buf.readByte();
        if (header == 80) {
            if (channel != null) {
                ByteBuf response = Unpooled.wrappedBuffer((byte[])new byte[]{80, 79});
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return null;
        }
        buf.readUnsignedByte();
        buf.readUnsignedIntLE();
        String serialNumber = String.valueOf(buf.readUnsignedIntLE());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, serialNumber);
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedShortLE();
        int length = buf.readIntLE();
        buf.readUnsignedByte();
        buf.readUnsignedMediumLE();
        int index = buf.readUnsignedShortLE();
        buf.readUnsignedByte();
        int type = buf.readUnsignedShortLE();
        if (type == 1) {
            this.sendResponse(channel, remoteAddress, index, type, "hello");
        } else {
            this.sendResponse(channel, remoteAddress, index, type, "OK");
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        return switch (type) {
            case 33 -> {
                this.decodeEvents(position, buf);
                this.getLastLocation(position, null);
                yield position;
            }
            case 35 -> {
                this.decodeTechInfo(position, buf);
                this.getLastLocation(position, null);
                yield position;
            }
            case 50 -> {
                this.decodeGpsData(position, buf.readSlice(length));
                yield position;
            }
            case 55 -> {
                int count = buf.readUnsignedShortLE();
                block11: for (int i = 0; i < count; ++i) {
                    int partType = buf.readUnsignedShortLE();
                    int partLength = buf.readUnsignedShortLE();
                    switch (partType) {
                        case 33: {
                            this.decodeEvents(position, buf);
                            continue block11;
                        }
                        case 35: {
                            this.decodeTechInfo(position, buf);
                            continue block11;
                        }
                        case 50: {
                            this.decodeGpsData(position, buf.readSlice(partLength));
                            continue block11;
                        }
                        default: {
                            buf.skipBytes(partLength);
                        }
                    }
                }
                if (position.getFixTime() == null) {
                    this.getLastLocation(position, null);
                }
                yield position;
            }
            default -> null;
        };
    }
}

