/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.geocoder.Geocoder;
import org.traccar.handler.BasePositionHandler;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class GeocoderHandler
extends BasePositionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeocoderHandler.class);
    private final Geocoder geocoder;
    private final CacheManager cacheManager;
    private final boolean ignorePositions;
    private final boolean processInvalidPositions;
    private final int reuseDistance;

    public GeocoderHandler(Config config, Geocoder geocoder, CacheManager cacheManager) {
        this.geocoder = geocoder;
        this.cacheManager = cacheManager;
        this.ignorePositions = config.getBoolean(Keys.GEOCODER_IGNORE_POSITIONS);
        this.processInvalidPositions = config.getBoolean(Keys.GEOCODER_PROCESS_INVALID_POSITIONS);
        this.reuseDistance = config.getInteger(Keys.GEOCODER_REUSE_DISTANCE, 0);
    }

    @Override
    public void onPosition(final Position position, final BasePositionHandler.Callback callback) {
        if (!this.ignorePositions && (this.processInvalidPositions || position.getValid())) {
            Position lastPosition;
            if (this.reuseDistance != 0 && (lastPosition = this.cacheManager.getPosition(position.getDeviceId())) != null && lastPosition.getAddress() != null && position.getDouble("distance") <= (double)this.reuseDistance) {
                position.setAddress(lastPosition.getAddress());
                callback.processed(false);
                return;
            }
            this.geocoder.getAddress(position.getLatitude(), position.getLongitude(), new Geocoder.ReverseGeocoderCallback(){

                @Override
                public void onSuccess(String address) {
                    position.setAddress(address);
                    callback.processed(false);
                }

                @Override
                public void onFailure(Throwable e) {
                    LOGGER.warn("Geocoding failed", e);
                    callback.processed(false);
                }
            });
        } else {
            callback.processed(false);
        }
    }
}

