/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geolocation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.InvocationCallback;
import java.util.Collection;
import org.traccar.geolocation.GeolocationException;
import org.traccar.geolocation.GeolocationProvider;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.WifiAccessPoint;

public class UnwiredGeolocationProvider
implements GeolocationProvider {
    private final Client client;
    private final String url;
    private final String key;
    private final ObjectMapper objectMapper;

    public UnwiredGeolocationProvider(Client client, String url, String key) {
        this.client = client;
        this.url = url;
        this.key = key;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.addMixIn(Network.class, NetworkMixIn.class);
        this.objectMapper.addMixIn(CellTower.class, CellTowerMixIn.class);
        this.objectMapper.addMixIn(WifiAccessPoint.class, WifiAccessPointMixIn.class);
    }

    @Override
    public void getLocation(Network network, final GeolocationProvider.LocationProviderCallback callback) {
        ObjectNode json = (ObjectNode)this.objectMapper.valueToTree((Object)network);
        json.put("token", this.key);
        this.client.target(this.url).request().async().post(Entity.json((Object)json), (InvocationCallback)new InvocationCallback<JsonObject>(){

            public void completed(JsonObject json) {
                if (json.getString("status").equals("error")) {
                    callback.onFailure(new GeolocationException(json.getString("message")));
                } else {
                    callback.onSuccess(json.getJsonNumber("lat").doubleValue(), json.getJsonNumber("lon").doubleValue(), json.getJsonNumber("accuracy").doubleValue());
                }
            }

            public void failed(Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    private static abstract class NetworkMixIn {
        private NetworkMixIn() {
        }

        @JsonProperty(value="mcc")
        abstract Integer getHomeMobileCountryCode();

        @JsonProperty(value="mnc")
        abstract Integer getHomeMobileNetworkCode();

        @JsonProperty(value="radio")
        abstract String getRadioType();

        @JsonIgnore
        abstract String getCarrier();

        @JsonIgnore
        abstract Boolean getConsiderIp();

        @JsonProperty(value="cells")
        abstract Collection<CellTower> getCellTowers();

        @JsonProperty(value="wifi")
        abstract Collection<WifiAccessPoint> getWifiAccessPoints();
    }

    private static abstract class CellTowerMixIn {
        private CellTowerMixIn() {
        }

        @JsonProperty(value="radio")
        abstract String getRadioType();

        @JsonProperty(value="mcc")
        abstract Integer getMobileCountryCode();

        @JsonProperty(value="mnc")
        abstract Integer getMobileNetworkCode();

        @JsonProperty(value="lac")
        abstract Integer getLocationAreaCode();

        @JsonProperty(value="cid")
        abstract Long getCellId();
    }

    private static abstract class WifiAccessPointMixIn {
        private WifiAccessPointMixIn() {
        }

        @JsonProperty(value="bssid")
        abstract String getMacAddress();

        @JsonProperty(value="signal")
        abstract Integer getSignalStrength();
    }
}

