/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Order;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryPartition;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.telemetry.MetricsUtil;
import com.google.cloud.firestore.telemetry.TelemetryConstants;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.PartitionQueryRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class CollectionGroup
extends Query {
    final Query partitionQuery = this.orderBy(FieldPath.DOCUMENT_ID);

    CollectionGroup(FirestoreRpcContext<?> rpcContext, String collectionId) {
        super(rpcContext, Query.QueryOptions.builder().setParentPath(rpcContext.getResourcePath()).setCollectionId(collectionId).setAllDescendants(true).build());
    }

    public void getPartitions(long desiredPartitionCount, ApiStreamObserver<QueryPartition> observer) {
        if (desiredPartitionCount == 1L) {
            observer.onNext((Object)new QueryPartition(this.partitionQuery, null, null));
        } else {
            PartitionQueryRequest request = this.buildRequest(desiredPartitionCount);
            try {
                FirestoreClient.PartitionQueryPagedResponse response = (FirestoreClient.PartitionQueryPagedResponse)((Object)ApiExceptions.callAndTranslateApiException(this.rpcContext.sendRequest(request, this.rpcContext.getClient().partitionQueryPagedCallable())));
                this.consumePartitions(response, queryPartition -> {
                    observer.onNext(queryPartition);
                    return null;
                });
                observer.onCompleted();
            }
            catch (ApiException exception) {
                throw FirestoreException.forApiException(exception);
            }
        }
    }

    public ApiFuture<List<QueryPartition>> getPartitions(long desiredPartitionCount) {
        if (desiredPartitionCount == 1L) {
            return ApiFutures.immediateFuture(Collections.singletonList(new QueryPartition(this.partitionQuery, null, null)));
        }
        PartitionQueryRequest request = this.buildRequest(desiredPartitionCount);
        TraceUtil.Span span = ((FirestoreOptions)this.rpcContext.getFirestore().getOptions()).getTraceUtil().startSpan("PartitionQuery");
        MetricsUtil.MetricsContext metricsContext = ((FirestoreOptions)this.rpcContext.getFirestore().getOptions()).getMetricsUtil().createMetricsContext("PartitionQuery");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ApiFuture result = ApiFutures.transform(this.rpcContext.sendRequest(request, this.rpcContext.getClient().partitionQueryPagedCallable()), response -> {
                ImmutableList.Builder partitions = ImmutableList.builder();
                this.consumePartitions((FirestoreClient.PartitionQueryPagedResponse)((Object)response), queryPartition -> {
                    partitions.add(queryPartition);
                    return null;
                });
                return partitions.build();
            }, (Executor)MoreExecutors.directExecutor());
            span.endAtFuture(result);
            metricsContext.recordLatencyAtFuture(TelemetryConstants.MetricType.END_TO_END_LATENCY, result);
            ApiFuture apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ApiException exception) {
                span.end(exception);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, exception);
                throw FirestoreException.forApiException(exception);
            }
            catch (Throwable throwable3) {
                span.end(throwable3);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, throwable3);
                throw throwable3;
            }
        }
    }

    private PartitionQueryRequest buildRequest(long desiredPartitionCount) {
        Preconditions.checkArgument((desiredPartitionCount > 0L ? 1 : 0) != 0, (Object)"Desired partition count must be one or greater");
        PartitionQueryRequest.Builder request = PartitionQueryRequest.newBuilder();
        request.setStructuredQuery(this.partitionQuery.buildQuery());
        request.setParent(this.options.getParentPath().toString());
        request.setPartitionCount(desiredPartitionCount - 1L);
        return request.build();
    }

    private void consumePartitions(FirestoreClient.PartitionQueryPagedResponse response, Function<QueryPartition, Void> consumer) {
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        for (Cursor cursor : response.iterateAll()) {
            cursors.add(cursor);
        }
        cursors.sort((left, right) -> Order.INSTANCE.compareArrays(left.getValuesList(), right.getValuesList()));
        Object[] lastCursor = null;
        for (Cursor cursor : cursors) {
            Object[] decodedCursorValue = new Object[cursor.getValuesCount()];
            for (int i = 0; i < cursor.getValuesCount(); ++i) {
                decodedCursorValue[i] = UserDataConverter.decodeValue(this.rpcContext, cursor.getValues(i));
            }
            consumer.apply(new QueryPartition(this.partitionQuery, lastCursor, decodedCursorValue));
            lastCursor = decodedCursorValue;
        }
        consumer.apply(new QueryPartition(this.partitionQuery, lastCursor, null));
    }

    @Override
    public String toString() {
        return String.format("CollectionGroup{partitionQuery=%s, options=%s}", this.partitionQuery, this.options);
    }
}

