/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.json.GenericJson;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import java.util.List;
import java.util.Map;

public class TopicManagementResponse {
    private static final String UNKNOWN_ERROR = "unknown-error";
    private static final Map<String, String> ERROR_CODES = ImmutableMap.builder().put((Object)"INVALID_ARGUMENT", (Object)"invalid-argument").put((Object)"NOT_FOUND", (Object)"registration-token-not-registered").put((Object)"INTERNAL", (Object)"internal-error").put((Object)"TOO_MANY_TOPICS", (Object)"too-many-topics").build();
    private final int successCount;
    private final List<Error> errors;

    TopicManagementResponse(List<GenericJson> results) {
        Preconditions.checkArgument((results != null && !results.isEmpty() ? 1 : 0) != 0, (Object)"unexpected response from topic management service");
        int successCount = 0;
        ImmutableList.Builder errors = ImmutableList.builder();
        for (int i = 0; i < results.size(); ++i) {
            Map result = (Map)results.get(i);
            if (result.isEmpty()) {
                ++successCount;
                continue;
            }
            errors.add((Object)new Error(i, (String)result.get("error")));
        }
        this.successCount = successCount;
        this.errors = errors.build();
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getFailureCount() {
        return this.errors.size();
    }

    @NonNull
    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Error {
        private final int index;
        private final String reason;

        private Error(int index, String reason) {
            this.index = index;
            this.reason = ERROR_CODES.containsKey(reason) ? (String)ERROR_CODES.get(reason) : TopicManagementResponse.UNKNOWN_ERROR;
        }

        public int getIndex() {
            return this.index;
        }

        @NonNull
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("reason", (Object)this.reason).toString();
        }
    }
}

