/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.snapshot.LeafNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.utilities.Utilities;

public class StringNode
extends LeafNode<StringNode> {
    private final String value;

    public StringNode(String value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashRepresentation(Node.HashVersion version) {
        switch (version) {
            case V1: {
                return this.getPriorityHash(version) + "string:" + this.value;
            }
            case V2: {
                return this.getPriorityHash(version) + "string:" + Utilities.stringHashV2Representation(this.value);
            }
        }
        throw new IllegalArgumentException("Invalid hash version for string node: " + (Object)((Object)version));
    }

    @Override
    public StringNode updatePriority(Node priority) {
        return new StringNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.String;
    }

    @Override
    protected int compareLeafValues(StringNode other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StringNode)) {
            return false;
        }
        StringNode otherStringNode = (StringNode)other;
        return this.value.equals(otherStringNode.value) && this.priority.equals(otherStringNode.priority);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() + this.priority.hashCode();
    }
}

