/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import org.apache.commons.digester3.AbstractMethodRule;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParamTypeBuilder<R extends AbstractMethodRule>
extends AbstractBackToLinkedRuleBuilder<R> {
    private final String methodName;
    private final ClassLoader classLoader;
    private boolean useExactMatch = false;
    private Class<?> paramType;
    private boolean fireOnBegin = false;

    AbstractParamTypeBuilder(String keyPattern, String namespaceURI, RulesBinder mainBinder, LinkedRuleBuilder mainBuilder, String methodName, ClassLoader classLoader) {
        super(keyPattern, namespaceURI, mainBinder, mainBuilder);
        this.methodName = methodName;
        this.classLoader = classLoader;
    }

    public final AbstractParamTypeBuilder<R> withParameterType(Class<?> paramType) {
        if (paramType == null) {
            this.reportError(String.format(".%s.withParameterType( Class<?> )", this.methodName), "NULL Java type not allowed");
            return this;
        }
        this.paramType = paramType;
        return this.withParameterType(paramType.getName());
    }

    public final AbstractParamTypeBuilder<R> withParameterType(String paramType) {
        if (paramType == null) {
            this.reportError(String.format(".%s.withParameterType( Class<?> )", this.methodName), "NULL Java type not allowed");
            return this;
        }
        if (this.paramType == null) {
            try {
                this.paramType = this.classLoader.loadClass(paramType);
            }
            catch (ClassNotFoundException e) {
                this.reportError(String.format(".%s.withParameterType( Class<?> )", this.methodName), String.format("class '%s' cannot be load", paramType));
            }
        }
        return this;
    }

    public final AbstractParamTypeBuilder<R> useExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
        return this;
    }

    public final AbstractParamTypeBuilder<R> fireOnBegin(boolean fireOnBegin) {
        this.fireOnBegin = fireOnBegin;
        return this;
    }

    final String getMethodName() {
        return this.methodName;
    }

    final Class<?> getParamType() {
        return this.paramType;
    }

    final boolean isUseExactMatch() {
        return this.useExactMatch;
    }

    final boolean isFireOnBegin() {
        return this.fireOnBegin;
    }
}

