/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.cache.bounded.BoundedCache;
import software.amazon.awssdk.utils.uri.internal.UriConstructorArgs;

@SdkProtectedApi
public final class SdkUri {
    private static final Logger log = Logger.loggerFor(SdkUri.class);
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTP_PREFIX = "http://";
    private static final int MAX_INT_DIGITS_BASE_10 = 10;
    private static final int CACHE_SIZE = 150;
    private static final Lazy<SdkUri> INSTANCE = new Lazy<SdkUri>(SdkUri::new);
    private final BoundedCache<UriConstructorArgs, URI> cache = BoundedCache.builder(UriConstructorArgs::newInstance).maxSize(150).build();

    private SdkUri() {
    }

    public static SdkUri getInstance() {
        return INSTANCE.getValue();
    }

    public URI create(String s) {
        if (!this.isAccountIdUri(s)) {
            log.trace(() -> "skipping cache for uri " + s);
            return URI.create(s);
        }
        StringConstructorArgs key = new StringConstructorArgs(s);
        boolean containsK = this.cache.containsKey(key);
        URI uri = this.cache.get(key);
        this.logCacheUsage(containsK, uri);
        return uri;
    }

    public URI newUri(String s) throws URISyntaxException {
        if (!this.isAccountIdUri(s)) {
            log.trace(() -> "skipping cache for uri " + s);
            return new URI(s);
        }
        try {
            StringConstructorArgs key = new StringConstructorArgs(s);
            boolean containsK = this.cache.containsKey(key);
            URI uri = this.cache.get(key);
            this.logCacheUsage(containsK, uri);
            return uri;
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof URISyntaxException) {
                throw (URISyntaxException)e.getCause();
            }
            throw e;
        }
    }

    public URI newUri(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        if (!this.isAccountIdUri(host)) {
            log.trace(() -> "skipping cache for host " + host);
            return new URI(scheme, userInfo, host, port, path, query, fragment);
        }
        try {
            HostConstructorArgs key = new HostConstructorArgs(scheme, userInfo, host, port, path, query, fragment);
            boolean containsK = this.cache.containsKey(key);
            URI uri = this.cache.get(key);
            this.logCacheUsage(containsK, uri);
            return uri;
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof URISyntaxException) {
                throw (URISyntaxException)e.getCause();
            }
            throw e;
        }
    }

    public URI newUri(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        if (!this.isAccountIdUri(authority)) {
            log.trace(() -> "skipping cache for authority " + authority);
            return new URI(scheme, authority, path, query, fragment);
        }
        try {
            AuthorityConstructorArgs key = new AuthorityConstructorArgs(scheme, authority, path, query, fragment);
            boolean containsK = this.cache.containsKey(key);
            URI uri = this.cache.get(key);
            this.logCacheUsage(containsK, uri);
            return uri;
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof URISyntaxException) {
                throw (URISyntaxException)e.getCause();
            }
            throw e;
        }
    }

    private boolean isAccountIdUri(String s) {
        int firstCharAfterScheme = 0;
        if (s.startsWith(HTTPS_PREFIX)) {
            firstCharAfterScheme = HTTPS_PREFIX.length();
        } else if (s.startsWith(HTTP_PREFIX)) {
            firstCharAfterScheme = HTTP_PREFIX.length();
        }
        if (s.length() > firstCharAfterScheme + 10) {
            return Character.isDigit(s.charAt(firstCharAfterScheme)) && Character.isDigit(s.charAt(firstCharAfterScheme + 10));
        }
        return false;
    }

    private void logCacheUsage(boolean containsKey, URI uri) {
        log.trace(() -> "URI cache size: " + this.cache.size());
        if (containsKey) {
            log.trace(() -> "Using cached uri for " + uri.toString());
        } else {
            log.trace(() -> "Cache empty for " + uri.toString());
        }
    }

    private static final class AuthorityConstructorArgs
    implements UriConstructorArgs {
        private final String scheme;
        private final String authority;
        private final String path;
        private final String query;
        private final String fragment;

        private AuthorityConstructorArgs(String scheme, String authority, String path, String query, String fragment) {
            this.scheme = scheme;
            this.authority = authority;
            this.path = path;
            this.query = query;
            this.fragment = fragment;
        }

        @Override
        public URI newInstance() {
            try {
                return new URI(this.scheme, this.authority, this.path, this.query, this.fragment);
            }
            catch (URISyntaxException x) {
                throw new IllegalArgumentException(x.getMessage(), x);
            }
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthorityConstructorArgs that = (AuthorityConstructorArgs)o;
            return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.authority, that.authority) && Objects.equals(this.path, that.path) && Objects.equals(this.query, that.query) && Objects.equals(this.fragment, that.fragment);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.scheme);
            result = 31 * result + Objects.hashCode(this.authority);
            result = 31 * result + Objects.hashCode(this.path);
            result = 31 * result + Objects.hashCode(this.query);
            result = 31 * result + Objects.hashCode(this.fragment);
            return result;
        }
    }

    private static final class HostConstructorArgs
    implements UriConstructorArgs {
        private final String scheme;
        private final String userInfo;
        private final String host;
        private final int port;
        private final String path;
        private final String query;
        private final String fragment;

        private HostConstructorArgs(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
            this.scheme = scheme;
            this.userInfo = userInfo;
            this.host = host;
            this.port = port;
            this.path = path;
            this.query = query;
            this.fragment = fragment;
        }

        @Override
        public URI newInstance() {
            try {
                return new URI(this.scheme, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
            }
            catch (URISyntaxException x) {
                throw new IllegalArgumentException(x.getMessage(), x);
            }
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostConstructorArgs that = (HostConstructorArgs)o;
            return this.port == that.port && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.userInfo, that.userInfo) && Objects.equals(this.host, that.host) && Objects.equals(this.path, that.path) && Objects.equals(this.query, that.query) && Objects.equals(this.fragment, that.fragment);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.scheme);
            result = 31 * result + Objects.hashCode(this.userInfo);
            result = 31 * result + Objects.hashCode(this.host);
            result = 31 * result + this.port;
            result = 31 * result + Objects.hashCode(this.path);
            result = 31 * result + Objects.hashCode(this.query);
            result = 31 * result + Objects.hashCode(this.fragment);
            return result;
        }
    }

    private static final class StringConstructorArgs
    implements UriConstructorArgs {
        private final String str;

        private StringConstructorArgs(String str) {
            this.str = str;
        }

        @Override
        public URI newInstance() {
            return URI.create(this.str);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringConstructorArgs that = (StringConstructorArgs)o;
            return Objects.equals(this.str, that.str);
        }

        public int hashCode() {
            return Objects.hashCode(this.str);
        }
    }
}

