/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.task;

import de.rub.nds.tlsattacker.attacks.cca.CcaCertificateManager;
import de.rub.nds.tlsattacker.attacks.cca.CcaWorkflowGenerator;
import de.rub.nds.tlsattacker.attacks.cca.vector.CcaVector;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.DefaultWorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.task.TlsTask;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcaTask
extends TlsTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CcaVector ccaVector;
    private State state;
    private final Config tlsConfig;
    private final CcaCertificateManager ccaCertificateManager;

    public CcaTask(CcaVector ccaVector, Config tlsConfig, CcaCertificateManager ccaCertificateManager, int reexecutions) {
        super(reexecutions);
        this.ccaVector = ccaVector;
        this.tlsConfig = tlsConfig;
        this.ccaCertificateManager = ccaCertificateManager;
    }

    public CcaTask(CcaVector ccaVector, Config tlsConfig, CcaCertificateManager ccaCertificateManager, long additionalTimeout, boolean increasingTimeout, int reexecutions, long additionalTcpTimeout) {
        super(reexecutions, additionalTimeout, increasingTimeout, additionalTcpTimeout);
        this.ccaVector = ccaVector;
        this.tlsConfig = tlsConfig;
        this.ccaCertificateManager = ccaCertificateManager;
    }

    private State prepareState() {
        WorkflowTrace trace = CcaWorkflowGenerator.generateWorkflow(this.tlsConfig, this.ccaCertificateManager, this.ccaVector.getCcaWorkflowType(), this.ccaVector.getCcaCertificateType());
        State state = new State(this.tlsConfig, trace);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.state = this.prepareState();
        try {
            DefaultWorkflowExecutor executor = new DefaultWorkflowExecutor(this.state);
            ((WorkflowExecutor)executor).executeWorkflow();
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                this.state.getTlsContext().getTransportHandler().closeConnection();
            }
            catch (IOException ex) {
                LOGGER.debug((Object)ex);
            }
        }
    }

    public CcaVector getCcaVector() {
        return this.ccaVector;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void reset() {
        this.state.reset();
    }
}

