/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNamePairParser
extends Parser<ServerNamePair> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ServerNamePair pair;

    public ServerNamePairParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public ServerNamePair parse() {
        this.pair = new ServerNamePair();
        this.parseServerNameType(this.pair);
        this.parseServerNameLength(this.pair);
        this.parseServerName(this.pair);
        this.pair.setServerNameConfig((byte[])this.pair.getServerName().getValue());
        this.pair.setServerNameTypeConfig((Byte)this.pair.getServerNameType().getValue());
        return this.pair;
    }

    private void parseServerNameType(ServerNamePair pair) {
        pair.setServerNameType(this.parseByteField(1));
        LOGGER.debug("ServerNameType: " + pair.getServerNameType().getValue());
    }

    private void parseServerNameLength(ServerNamePair pair) {
        pair.setServerNameLength(this.parseIntField(2));
        LOGGER.debug("ServerNameLength: " + pair.getServerNameLength().getValue());
    }

    private void parseServerName(ServerNamePair pair) {
        pair.setServerName(this.parseByteArrayField((Integer)pair.getServerNameLength().getValue()));
        LOGGER.debug("ServerName: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getServerName().getValue())));
    }
}

