/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElement;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElementFp;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurveOverFp
extends EllipticCurve {
    private static final Logger LOGGER = LogManager.getLogger();
    private final FieldElementFp a;
    private final FieldElementFp b;

    public EllipticCurveOverFp(BigInteger a, BigInteger b, BigInteger p) {
        super(p);
        this.a = new FieldElementFp(a, this.getModulus());
        this.b = new FieldElementFp(b, this.getModulus());
    }

    public EllipticCurveOverFp(BigInteger a, BigInteger b, BigInteger p, BigInteger x, BigInteger y, BigInteger q) {
        super(p, x, y, q);
        this.a = new FieldElementFp(a, this.getModulus());
        this.b = new FieldElementFp(b, this.getModulus());
    }

    @Override
    public Point getPoint(BigInteger x, BigInteger y) {
        FieldElementFp elemX = new FieldElementFp(x, this.getModulus());
        FieldElementFp elemY = new FieldElementFp(y, this.getModulus());
        return new Point(elemX, elemY);
    }

    @Override
    public boolean isOnCurve(Point p) {
        if (p.isAtInfinity()) {
            return true;
        }
        if (p.getX().getClass() != FieldElementFp.class || p.getY().getClass() != FieldElementFp.class) {
            return false;
        }
        FieldElementFp x = (FieldElementFp)p.getX();
        FieldElementFp y = (FieldElementFp)p.getY();
        if (x.getModulus() != this.getModulus() || y.getModulus() != this.getModulus()) {
            return false;
        }
        FieldElementFp leftPart = (FieldElementFp)y.mult(y);
        FieldElementFp rightPart = (FieldElementFp)x.mult(x.mult(x)).add(x.mult(this.getA())).add(this.getB());
        return leftPart.equals(rightPart);
    }

    @Override
    protected Point inverseAffine(Point p) {
        if (!(p.getX() instanceof FieldElementFp) || !(p.getY() instanceof FieldElementFp)) {
            LOGGER.warn("Trying to invert non Fp point with Fp curve. Returning point at (0,0)");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        FieldElementFp x = (FieldElementFp)p.getX();
        FieldElementFp yInv = (FieldElementFp)p.getY().addInv();
        return new Point(x, yInv);
    }

    @Override
    protected Point additionFormular(Point p, Point q) {
        if (!(p.getX() instanceof FieldElementFp && p.getY() instanceof FieldElementFp && q.getX() instanceof FieldElementFp && q.getY() instanceof FieldElementFp)) {
            LOGGER.warn("Trying to add non Fp points with Fp curve. Returning point at (0,0)");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        try {
            FieldElementFp lambda;
            FieldElementFp x1 = (FieldElementFp)p.getX();
            FieldElementFp y1 = (FieldElementFp)p.getY();
            FieldElementFp x2 = (FieldElementFp)q.getX();
            FieldElementFp y2 = (FieldElementFp)q.getY();
            if (p.equals(q)) {
                FieldElementFp two = new FieldElementFp(new BigInteger("2"), this.getModulus());
                FieldElementFp three = new FieldElementFp(new BigInteger("3"), this.getModulus());
                lambda = (FieldElementFp)x1.mult(x1).mult(three).add(this.getA()).divide(y1.mult(two));
            } else {
                lambda = (FieldElementFp)y2.subtract(y1).divide(x2.subtract(x1));
            }
            FieldElementFp lambdaSq = (FieldElementFp)lambda.mult(lambda);
            FieldElementFp x3 = (FieldElementFp)lambdaSq.subtract(x1).subtract(x2);
            FieldElementFp y3 = (FieldElementFp)lambda.mult(x1.subtract(x3)).subtract(y1);
            return new Point(x3, y3);
        }
        catch (ArithmeticException e) {
            LOGGER.warn("Encountered an arithmetic exception during addition. Returning point at 0,0");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
    }

    @Override
    public FieldElement createFieldElement(BigInteger value) {
        return new FieldElementFp(value, this.getModulus());
    }

    @Override
    public Point createAPointOnCurve(BigInteger x) {
        BigInteger y = x.pow(3).add(x.multiply(this.getA().getData())).add(this.getB().getData()).mod(this.getModulus());
        y = y.modPow(this.getModulus().add(BigInteger.ONE).shiftRight(2), this.getModulus());
        return this.getPoint(x, y);
    }

    public FieldElementFp getA() {
        return this.a;
    }

    public FieldElementFp getB() {
        return this.b;
    }
}

