/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public final class ResizeBorder
implements Border {
    private static final BasicStroke STROKE = new BasicStroke(1.0f, 2, 0, 5.0f, new float[]{6.0f, 3.0f}, 0.0f);
    private int thickness;
    private Color color;
    private boolean outer;
    private ResourceTableListener listener = null;

    public ResizeBorder(int n, Color color, boolean bl) {
        this.thickness = n;
        this.color = color;
        this.outer = bl;
    }

    public ResizeBorder(int n, String string, Widget widget, boolean bl) {
        this(n, string, widget.getResourceTable(), bl);
    }

    public ResizeBorder(int n, String string, ResourceTable resourceTable, boolean bl) {
        this.thickness = n;
        this.outer = bl;
        Object object = resourceTable.getProperty(string);
        if (object instanceof Color) {
            this.color = (Color)object;
        }
        this.listener = new ResourceTableListener();
        resourceTable.addPropertyChangeListener(string, this.listener);
    }

    public Insets getInsets() {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public boolean isOuter() {
        return this.outer;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setColor(this.color);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE);
        if (this.outer) {
            graphics2D.draw(new Rectangle2D.Double((double)rectangle.x + 0.5, (double)rectangle.y + 0.5, (double)rectangle.width - 1.0, (double)rectangle.height - 1.0));
        } else {
            graphics2D.draw(new Rectangle2D.Double((double)(rectangle.x + this.thickness) + 0.5, (double)(rectangle.y + this.thickness) + 0.5, (double)(rectangle.width - this.thickness - this.thickness) - 1.0, (double)(rectangle.height - this.thickness - this.thickness) - 1.0));
        }
        graphics2D.setStroke(stroke);
        graphics2D.fillRect(rectangle.x, rectangle.y, this.thickness, this.thickness);
        graphics2D.fillRect(rectangle.x + rectangle.width - this.thickness, rectangle.y, this.thickness, this.thickness);
        graphics2D.fillRect(rectangle.x, rectangle.y + rectangle.height - this.thickness, this.thickness, this.thickness);
        graphics2D.fillRect(rectangle.x + rectangle.width - this.thickness, rectangle.y + rectangle.height - this.thickness, this.thickness, this.thickness);
        Point point = GeomUtil.center(rectangle);
        if (rectangle.width >= this.thickness * 5) {
            graphics2D.fillRect(point.x - this.thickness / 2, rectangle.y, this.thickness, this.thickness);
            graphics2D.fillRect(point.x - this.thickness / 2, rectangle.y + rectangle.height - this.thickness, this.thickness, this.thickness);
        }
        if (rectangle.height >= this.thickness * 5) {
            graphics2D.fillRect(rectangle.x, point.y - this.thickness / 2, this.thickness, this.thickness);
            graphics2D.fillRect(rectangle.x + rectangle.width - this.thickness, point.y - this.thickness / 2, this.thickness, this.thickness);
        }
    }

    public boolean isOpaque() {
        return this.outer;
    }

    public class ResourceTableListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ResizeBorder.this.color = (Color)propertyChangeEvent.getNewValue();
        }
    }
}

