/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.expr.NumericProperty;
import org.apache.fop.fo.expr.RelativeNumericProperty;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.render.txt.Helper;

public class TXTHandler
extends AreaTreeHandler {
    private static final PercentBaseContext CONTEXT = new BlockLayoutManager(new Block(null));
    private static final int MODIFIED_FONT_SIZE = 10000;
    private final int[] quantum = new int[]{7860, 7860, 6000, 6000};
    private int[] overPatching = new int[4];
    private int[] lastOverPatching = new int[4];

    public TXTHandler(FOUserAgent userAgent, OutputStream stream) throws FOPException {
        super(userAgent, "text/plain", stream);
    }

    private static void setLength(CompoundDatatype cd, int value) {
        cd.setComponent(2048, new FixedLength(value), true);
    }

    private static void setMinOptMax(CompoundDatatype cd, Property p) {
        cd.setComponent(3072, p, true);
        cd.setComponent(3584, p, true);
        cd.setComponent(2560, p, true);
    }

    private void modifyBorder(int side, CommonBorderPaddingBackground bpb) {
        CommonBorderPaddingBackground.BorderInfo bi = bpb.getBorderInfo(side);
        if (bi != null) {
            int width = bpb.getBorderWidth(side, false);
            TXTHandler.setLength(bi.getWidth(), this.quantum[side] / 2);
            int n = side;
            this.lastOverPatching[n] = this.lastOverPatching[n] + (bpb.getBorderWidth(side, false) - width);
        }
    }

    private void modifyPadding(int side, CommonBorderPaddingBackground bpb) {
        int oldPadding = bpb.getPadding(side, false, null);
        int newPadding = Helper.round(oldPadding, this.quantum[side]);
        if (bpb.getBorderInfo(side) != null) {
            newPadding = Math.max(newPadding, this.quantum[side]) - bpb.getBorderWidth(side, false);
        }
        TXTHandler.setLength(bpb.getPaddingLengthProperty(side), newPadding);
        int n = side;
        this.lastOverPatching[n] = this.lastOverPatching[n] + (newPadding - oldPadding);
    }

    private void modifyBPB(CommonBorderPaddingBackground bpb) {
        this.modifyBorder(0, bpb);
        this.modifyBorder(1, bpb);
        this.modifyBorder(2, bpb);
        this.modifyBorder(3, bpb);
        this.modifyPadding(0, bpb);
        this.modifyPadding(1, bpb);
        this.modifyPadding(2, bpb);
        this.modifyPadding(3, bpb);
    }

    private void modifySpace(SpaceProperty space, int q) {
        int value = space.getOptimum(null).getLength().getValue();
        TXTHandler.setMinOptMax(space, new FixedLength(Helper.round(value, q)));
    }

    private Length roundLength(Length length, int q) {
        int x = Helper.round(length.getValue(), q);
        return new FixedLength(x);
    }

    private Length ceilLength(Length length, int q) {
        int x = Helper.ceil(length.getValue(), q);
        return new FixedLength(x);
    }

    private Length modifyIndent(Length indent, int side) {
        if (indent instanceof NumericProperty) {
            int n = side;
            this.overPatching[n] = this.overPatching[n] + this.lastOverPatching[side];
        }
        int newValue = indent.getValue() + this.overPatching[side];
        newValue = Helper.round(newValue, this.quantum[side]);
        return new FixedLength(newValue);
    }

    private void modifyCommonMarginBlock(CommonMarginBlock cmb) {
        cmb.marginTop = this.roundLength(cmb.marginTop, 7860);
        cmb.marginBottom = this.roundLength(cmb.marginBottom, 7860);
        cmb.marginLeft = this.roundLength(cmb.marginLeft, 6000);
        cmb.marginRight = this.roundLength(cmb.marginRight, 6000);
        this.modifySpace(cmb.spaceBefore, 7860);
        this.modifySpace(cmb.spaceAfter, 7860);
        if (!(cmb.startIndent instanceof RelativeNumericProperty)) {
            cmb.startIndent = this.modifyIndent(cmb.startIndent, 2);
        }
        if (!(cmb.endIndent instanceof RelativeNumericProperty)) {
            cmb.endIndent = this.modifyIndent(cmb.endIndent, 3);
        }
    }

    private void modifyTable(Table table) {
        CommonMarginBlock cmb = table.getCommonMarginBlock();
        if (table.getBorderCollapse() == 26) {
            int value = cmb.spaceAfter.getOptimum(null).getLength().getValue();
            TXTHandler.setMinOptMax(cmb.spaceAfter, new FixedLength(value += 7860));
        }
        this.modifyCommonMarginBlock(cmb);
        this.modifyBPB(table.getCommonBorderPaddingBackground());
        List columnList = table.getColumns();
        Iterator iter = columnList.iterator();
        while (iter.hasNext()) {
            this.modifyTableColumn((TableColumn)iter.next());
        }
    }

    private void modifyTableColumn(TableColumn column) {
        column.setColumnWidth(this.ceilLength(column.getColumnWidth(), 6000));
    }

    private void modifyCellPadding(int side, CommonBorderPaddingBackground bpb) {
        if (bpb.getBorderInfo(side) == null) {
            int oldPadding = bpb.getPadding(side, false, null);
            int newPadding = oldPadding + this.quantum[side] / 2;
            TXTHandler.setLength(bpb.getPaddingLengthProperty(side), newPadding);
        }
    }

    private void modifyTableCell(TableCell c) {
        CommonBorderPaddingBackground bpb = c.getCommonBorderPaddingBackground();
        this.modifyBPB(bpb);
        this.modifyCellPadding(0, bpb);
        this.modifyCellPadding(1, bpb);
        this.modifyCellPadding(2, bpb);
        this.modifyCellPadding(3, bpb);
    }

    private void modifyCommonAbsolutePosition(CommonAbsolutePosition cap) {
        if (cap.absolutePosition == 1) {
            cap.left = this.roundLength(cap.left, 6000);
            cap.top = this.roundLength(cap.top, 7860);
        }
    }

    private void modifyLineHeight(SpaceProperty lineHeight) {
        Property p = lineHeight.getOptimum(null);
        int value = p.getLength().getValue(CONTEXT);
        int height = 7860;
        int newValue = Math.max(Helper.floor(value, height), height);
        TXTHandler.setMinOptMax(lineHeight, new FixedLength(newValue));
    }

    private void modifyCommonFont(CommonFont cf) {
        if (cf != null) {
            cf.overrideFontFamily("Courier");
            cf.fontSize = new FixedLength(10000);
            cf.fontStretch = 97;
            cf.fontWeight = 97;
        }
    }

    private void modifyBlock(Block block) {
        this.modifyBPB(block.getCommonBorderPaddingBackground());
        this.modifyCommonMarginBlock(block.getCommonMarginBlock());
        this.modifyCommonFont(block.getCommonFont());
        this.modifyLineHeight(block.getLineHeight());
    }

    private void modifyBlockContainer(BlockContainer bc) {
        this.modifyBPB(bc.getCommonBorderPaddingBackground());
        this.modifyCommonMarginBlock(bc.getCommonMarginBlock());
        this.modifyCommonAbsolutePosition(bc.getCommonAbsolutePosition());
    }

    private void modifyInline(Inline inline) {
        this.modifyCommonFont(inline.getCommonFont());
    }

    private void modifyFOText(FOText text) {
        this.modifyCommonFont(text.getCommonFont());
    }

    private void modifyExternalGraphic(ExternalGraphic eg) {
        this.modifyBPB(eg.getCommonBorderPaddingBackground());
        this.modifyLineHeight(eg.getLineHeight());
    }

    private void modifyListBlock(ListBlock lb) {
        this.modifyBPB(lb.getCommonBorderPaddingBackground());
        this.modifyCommonMarginBlock(lb.getCommonMarginBlock());
    }

    private void modifyListItem(ListItem li) {
        this.modifyBPB(li.getCommonBorderPaddingBackground());
        this.modifyCommonMarginBlock(li.getCommonMarginBlock());
        this.refinement(li.getLabel());
        this.refinement(li.getBody());
    }

    private void refinement(FONode node) {
        int[] saveOverPatching = (int[])this.overPatching.clone();
        Arrays.fill(this.lastOverPatching, 0);
        if (node instanceof Block) {
            this.modifyBlock((Block)node);
        } else if (node instanceof BlockContainer) {
            this.modifyBlockContainer((BlockContainer)node);
        } else if (node instanceof Inline) {
            this.modifyInline((Inline)node);
        } else if (node instanceof FOText) {
            this.modifyFOText((FOText)node);
        } else if (node instanceof Table) {
            this.modifyTable((Table)node);
            Arrays.fill(this.overPatching, 0);
        } else if (node instanceof TableCell) {
            this.modifyTableCell((TableCell)node);
        } else if (node instanceof ExternalGraphic) {
            this.modifyExternalGraphic((ExternalGraphic)node);
        } else if (node instanceof ListBlock) {
            this.modifyListBlock((ListBlock)node);
        } else if (node instanceof ListItem) {
            this.modifyListItem((ListItem)node);
        } else if (node instanceof PageNumber) {
            this.modifyCommonFont(((PageNumber)node).getCommonFont());
        }
        ListIterator it = node.getChildNodes();
        if (it != null) {
            while (it.hasNext()) {
                this.refinement((FONode)it.next());
            }
        }
        this.overPatching = saveOverPatching;
    }

    public void endPageSequence(PageSequence pageSequence) {
        Arrays.fill(this.overPatching, 0);
        this.refinement(pageSequence.getMainFlow());
        if (pageSequence.getStaticContent("xsl-region-before") != null) {
            this.refinement(pageSequence.getStaticContent("xsl-region-before"));
        }
        if (pageSequence.getStaticContent("xsl-region-after") != null) {
            this.refinement(pageSequence.getStaticContent("xsl-region-after"));
        }
        if (pageSequence.getStaticContent("xsl-region-start") != null) {
            this.refinement(pageSequence.getStaticContent("xsl-region-start"));
        }
        if (pageSequence.getStaticContent("xsl-region-end") != null) {
            this.refinement(pageSequence.getStaticContent("xsl-region-end"));
        }
        super.endPageSequence(pageSequence);
    }
}

