/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageArea;

public class RtfPage
extends RtfContainer {
    private final RtfAttributes attrib;
    public static final String PAGE_WIDTH = "paperw";
    public static final String PAGE_HEIGHT = "paperh";
    public static final String LANDSCAPE = "landscape";
    public static final String MARGIN_TOP = "margt";
    public static final String MARGIN_BOTTOM = "margb";
    public static final String MARGIN_LEFT = "margl";
    public static final String MARGIN_RIGHT = "margr";
    public static final String HEADERY = "headery";
    public static final String FOOTERY = "footery";
    public static final String[] PAGE_ATTR = new String[]{"paperw", "paperh", "landscape", "margt", "margb", "margl", "margr", "headery", "footery"};

    RtfPage(RtfPageArea parent, Writer w, RtfAttributes attrs) throws IOException {
        super(parent, w);
        this.attrib = attrs;
    }

    protected void writeRtfContent() throws IOException {
        this.writeAttributes(this.attrib, PAGE_ATTR);
        if (this.attrib != null) {
            Object widthRaw = this.attrib.getValue(PAGE_WIDTH);
            Object heightRaw = this.attrib.getValue(PAGE_HEIGHT);
            if (widthRaw instanceof Integer && heightRaw instanceof Integer && (Integer)widthRaw > (Integer)heightRaw) {
                this.writeControlWord(LANDSCAPE);
            }
        }
    }

    public RtfAttributes getAttributes() {
        return this.attrib;
    }

    protected boolean okToWriteRtf() {
        return true;
    }
}

