/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.ColorUtil;

public class ColorProperty
extends Property {
    protected final Color color;

    public ColorProperty(FOUserAgent foUserAgent, String value) throws PropertyException {
        this.color = ColorUtil.parseColorString(foUserAgent, value);
    }

    public ColorProperty(Color value) {
        this.color = value;
    }

    public Color getColor(FOUserAgent foUserAgent) {
        return this.color;
    }

    public String toString() {
        return ColorUtil.colorToString(this.color);
    }

    public ColorProperty getColorProperty() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof ColorProperty) {
                return p;
            }
            FObj fobj = fo == null ? propertyList.getFObj() : fo;
            FOUserAgent ua = fobj == null ? null : fobj.getUserAgent();
            Color val = p.getColor(ua);
            if (val != null) {
                return new ColorProperty(val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

