/* Autogenerated: unsaturated_solinas --static --use-value-barrier secp521r1 32 '(auto)' '2^521 - 1' */
/* curve description: secp521r1 */
/* machine_wordsize = 32 (from "32") */
/* requested operations: (all) */
/* n = 19 (from "(auto)") */
/* s-c = 2^521 - [(1, 1)] (from "2^521 - 1") */
/* tight_bounds_multiplier = 1 (from "") */
/*  */
/* Computed values: */
/*   carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1] */
/*   eval z = z[0] + (z[1] << 28) + (z[2] << 55) + (z[3] << 83) + (z[4] << 110) + (z[5] << 138) + (z[6] << 165) + (z[7] << 192) + (z[8] << 220) + (z[9] << 247) + (z[10] << 0x113) + (z[11] << 0x12e) + (z[12] << 0x14a) + (z[13] << 0x165) + (z[14] << 0x180) + (z[15] << 0x19c) + (z[16] << 0x1b7) + (z[17] << 0x1d3) + (z[18] << 0x1ee) */
/*   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) + (z[64] << 2^9) + (z[65] << 0x208) */
/*   balance = [0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0xffffffe] */

#include <stdint.h>
typedef unsigned char fiat_secp521r1_uint1;
typedef signed char fiat_secp521r1_int1;
#ifdef __GNUC__
#define FIAT_SECP521R1_FIAT_INLINE __inline__
#else
#define FIAT_SECP521R1_FIAT_INLINE
#endif

/* The type fiat_secp521r1_loose_field_element is a field element with loose bounds. */
/* Bounds: [[0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x18000000]] */
typedef uint32_t fiat_secp521r1_loose_field_element[19];

/* The type fiat_secp521r1_tight_field_element is a field element with tight bounds. */
/* Bounds: [[0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x8000000]] */
typedef uint32_t fiat_secp521r1_tight_field_element[19];

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

OPENSSL_UNUSED static void fiat_secp521r1_selectznz(uint32_t out1[19],
                                     fiat_secp521r1_uint1 arg1,
                                     const uint32_t arg2[19],
                                     const uint32_t arg3[19]);
/*
 * The function fiat_secp521r1_addcarryx_u28 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^28
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^28⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xfffffff]
 *   arg3: [0x0 ~> 0xfffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xfffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_addcarryx_u28(uint32_t *out1,
                                         fiat_secp521r1_uint1 *out2,
                                         fiat_secp521r1_uint1 arg1,
                                         uint32_t arg2, uint32_t arg3) {
    uint32_t x1;
    uint32_t x2;
    fiat_secp521r1_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT32_C(0xfffffff));
    x3 = (fiat_secp521r1_uint1)(x1 >> 28);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp521r1_subborrowx_u28 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^28
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^28⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xfffffff]
 *   arg3: [0x0 ~> 0xfffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xfffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_subborrowx_u28(uint32_t *out1,
                                          fiat_secp521r1_uint1 *out2,
                                          fiat_secp521r1_uint1 arg1,
                                          uint32_t arg2, uint32_t arg3) {
    int32_t x1;
    fiat_secp521r1_int1 x2;
    uint32_t x3;
    x1 = ((int32_t)(arg2 - arg1) - (int32_t)arg3);
    x2 = (fiat_secp521r1_int1)(x1 >> 28);
    x3 = (x1 & UINT32_C(0xfffffff));
    *out1 = x3;
    *out2 = (fiat_secp521r1_uint1)(0x0 - x2);
}

/*
 * The function fiat_secp521r1_addcarryx_u27 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^27
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^27⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffff]
 *   arg3: [0x0 ~> 0x7ffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_addcarryx_u27(uint32_t *out1,
                                         fiat_secp521r1_uint1 *out2,
                                         fiat_secp521r1_uint1 arg1,
                                         uint32_t arg2, uint32_t arg3) {
    uint32_t x1;
    uint32_t x2;
    fiat_secp521r1_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT32_C(0x7ffffff));
    x3 = (fiat_secp521r1_uint1)(x1 >> 27);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp521r1_subborrowx_u27 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^27
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^27⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffff]
 *   arg3: [0x0 ~> 0x7ffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp521r1_subborrowx_u27(uint32_t *out1,
                                          fiat_secp521r1_uint1 *out2,
                                          fiat_secp521r1_uint1 arg1,
                                          uint32_t arg2, uint32_t arg3) {
    int32_t x1;
    fiat_secp521r1_int1 x2;
    uint32_t x3;
    x1 = ((int32_t)(arg2 - arg1) - (int32_t)arg3);
    x2 = (fiat_secp521r1_int1)(x1 >> 27);
    x3 = (x1 & UINT32_C(0x7ffffff));
    *out1 = x3;
    *out2 = (fiat_secp521r1_uint1)(0x0 - x2);
}

/*
 * The function fiat_secp521r1_cmovznz_u32 is a single-word conditional move.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_secp521r1_cmovznz_u32(uint32_t *out1,
                                       fiat_secp521r1_uint1 arg1, uint32_t arg2,
                                       uint32_t arg3) {
    fiat_secp521r1_uint1 x1;
    uint32_t x2;
    uint32_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_secp521r1_int1)(0x0 - x1) & UINT32_C(0xffffffff));
    x3 = ((value_barrier_u32(x2) & arg3) |
          (value_barrier_u32((~x2)) & arg2));
    *out1 = x3;
}

/*
 * The function fiat_secp521r1_carry_mul multiplies two field elements and reduces the result.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 */
static void fiat_secp521r1_carry_mul(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_loose_field_element arg1,
    const fiat_secp521r1_loose_field_element arg2) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    uint64_t x87;
    uint64_t x88;
    uint64_t x89;
    uint64_t x90;
    uint64_t x91;
    uint64_t x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    uint64_t x136;
    uint64_t x137;
    uint64_t x138;
    uint64_t x139;
    uint64_t x140;
    uint64_t x141;
    uint64_t x142;
    uint64_t x143;
    uint64_t x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    uint64_t x162;
    uint64_t x163;
    uint64_t x164;
    uint64_t x165;
    uint64_t x166;
    uint64_t x167;
    uint64_t x168;
    uint64_t x169;
    uint64_t x170;
    uint64_t x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    uint64_t x176;
    uint64_t x177;
    uint64_t x178;
    uint64_t x179;
    uint64_t x180;
    uint64_t x181;
    uint64_t x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    uint64_t x189;
    uint64_t x190;
    uint64_t x191;
    uint64_t x192;
    uint64_t x193;
    uint64_t x194;
    uint64_t x195;
    uint64_t x196;
    uint64_t x197;
    uint64_t x198;
    uint64_t x199;
    uint64_t x200;
    uint64_t x201;
    uint64_t x202;
    uint64_t x203;
    uint64_t x204;
    uint64_t x205;
    uint64_t x206;
    uint64_t x207;
    uint64_t x208;
    uint64_t x209;
    uint64_t x210;
    uint64_t x211;
    uint64_t x212;
    uint64_t x213;
    uint64_t x214;
    uint64_t x215;
    uint64_t x216;
    uint64_t x217;
    uint64_t x218;
    uint64_t x219;
    uint64_t x220;
    uint64_t x221;
    uint64_t x222;
    uint64_t x223;
    uint64_t x224;
    uint64_t x225;
    uint64_t x226;
    uint64_t x227;
    uint64_t x228;
    uint64_t x229;
    uint64_t x230;
    uint64_t x231;
    uint64_t x232;
    uint64_t x233;
    uint64_t x234;
    uint64_t x235;
    uint64_t x236;
    uint64_t x237;
    uint64_t x238;
    uint64_t x239;
    uint64_t x240;
    uint64_t x241;
    uint64_t x242;
    uint64_t x243;
    uint64_t x244;
    uint64_t x245;
    uint64_t x246;
    uint64_t x247;
    uint64_t x248;
    uint64_t x249;
    uint64_t x250;
    uint64_t x251;
    uint64_t x252;
    uint64_t x253;
    uint64_t x254;
    uint64_t x255;
    uint64_t x256;
    uint64_t x257;
    uint64_t x258;
    uint64_t x259;
    uint64_t x260;
    uint64_t x261;
    uint64_t x262;
    uint64_t x263;
    uint64_t x264;
    uint64_t x265;
    uint64_t x266;
    uint64_t x267;
    uint64_t x268;
    uint64_t x269;
    uint64_t x270;
    uint64_t x271;
    uint64_t x272;
    uint64_t x273;
    uint64_t x274;
    uint64_t x275;
    uint64_t x276;
    uint64_t x277;
    uint64_t x278;
    uint64_t x279;
    uint64_t x280;
    uint64_t x281;
    uint64_t x282;
    uint64_t x283;
    uint64_t x284;
    uint64_t x285;
    uint64_t x286;
    uint64_t x287;
    uint64_t x288;
    uint64_t x289;
    uint64_t x290;
    uint64_t x291;
    uint64_t x292;
    uint64_t x293;
    uint64_t x294;
    uint64_t x295;
    uint64_t x296;
    uint64_t x297;
    uint64_t x298;
    uint64_t x299;
    uint64_t x300;
    uint64_t x301;
    uint64_t x302;
    uint64_t x303;
    uint64_t x304;
    uint64_t x305;
    uint64_t x306;
    uint64_t x307;
    uint64_t x308;
    uint64_t x309;
    uint64_t x310;
    uint64_t x311;
    uint64_t x312;
    uint64_t x313;
    uint64_t x314;
    uint64_t x315;
    uint64_t x316;
    uint64_t x317;
    uint64_t x318;
    uint64_t x319;
    uint64_t x320;
    uint64_t x321;
    uint64_t x322;
    uint64_t x323;
    uint64_t x324;
    uint64_t x325;
    uint64_t x326;
    uint64_t x327;
    uint64_t x328;
    uint64_t x329;
    uint64_t x330;
    uint64_t x331;
    uint64_t x332;
    uint64_t x333;
    uint64_t x334;
    uint64_t x335;
    uint64_t x336;
    uint64_t x337;
    uint64_t x338;
    uint64_t x339;
    uint64_t x340;
    uint64_t x341;
    uint64_t x342;
    uint64_t x343;
    uint64_t x344;
    uint64_t x345;
    uint64_t x346;
    uint64_t x347;
    uint64_t x348;
    uint64_t x349;
    uint64_t x350;
    uint64_t x351;
    uint64_t x352;
    uint64_t x353;
    uint64_t x354;
    uint64_t x355;
    uint64_t x356;
    uint64_t x357;
    uint64_t x358;
    uint64_t x359;
    uint64_t x360;
    uint64_t x361;
    uint64_t x362;
    uint64_t x363;
    uint32_t x364;
    uint64_t x365;
    uint64_t x366;
    uint64_t x367;
    uint64_t x368;
    uint64_t x369;
    uint64_t x370;
    uint64_t x371;
    uint64_t x372;
    uint64_t x373;
    uint64_t x374;
    uint64_t x375;
    uint64_t x376;
    uint64_t x377;
    uint64_t x378;
    uint64_t x379;
    uint64_t x380;
    uint64_t x381;
    uint64_t x382;
    uint64_t x383;
    uint64_t x384;
    uint32_t x385;
    uint64_t x386;
    uint64_t x387;
    uint32_t x388;
    uint64_t x389;
    uint64_t x390;
    uint32_t x391;
    uint64_t x392;
    uint64_t x393;
    uint32_t x394;
    uint64_t x395;
    uint64_t x396;
    uint32_t x397;
    uint64_t x398;
    uint64_t x399;
    uint32_t x400;
    uint64_t x401;
    uint64_t x402;
    uint32_t x403;
    uint64_t x404;
    uint64_t x405;
    uint32_t x406;
    uint64_t x407;
    uint64_t x408;
    uint32_t x409;
    uint64_t x410;
    uint64_t x411;
    uint32_t x412;
    uint64_t x413;
    uint64_t x414;
    uint32_t x415;
    uint64_t x416;
    uint64_t x417;
    uint32_t x418;
    uint64_t x419;
    uint64_t x420;
    uint32_t x421;
    uint64_t x422;
    uint64_t x423;
    uint32_t x424;
    uint64_t x425;
    uint64_t x426;
    uint32_t x427;
    uint64_t x428;
    uint64_t x429;
    uint32_t x430;
    uint64_t x431;
    uint64_t x432;
    uint32_t x433;
    uint64_t x434;
    uint64_t x435;
    uint32_t x436;
    uint64_t x437;
    uint32_t x438;
    uint32_t x439;
    uint32_t x440;
    fiat_secp521r1_uint1 x441;
    uint32_t x442;
    uint32_t x443;
    x1 = ((uint64_t)(arg1[18]) * (arg2[18]));
    x2 = ((uint64_t)(arg1[18]) * ((arg2[17]) * 0x2));
    x3 = ((uint64_t)(arg1[18]) * (arg2[16]));
    x4 = ((uint64_t)(arg1[18]) * ((arg2[15]) * 0x2));
    x5 = ((uint64_t)(arg1[18]) * (arg2[14]));
    x6 = ((uint64_t)(arg1[18]) * (arg2[13]));
    x7 = ((uint64_t)(arg1[18]) * ((arg2[12]) * 0x2));
    x8 = ((uint64_t)(arg1[18]) * (arg2[11]));
    x9 = ((uint64_t)(arg1[18]) * ((arg2[10]) * 0x2));
    x10 = ((uint64_t)(arg1[18]) * (arg2[9]));
    x11 = ((uint64_t)(arg1[18]) * ((arg2[8]) * 0x2));
    x12 = ((uint64_t)(arg1[18]) * (arg2[7]));
    x13 = ((uint64_t)(arg1[18]) * (arg2[6]));
    x14 = ((uint64_t)(arg1[18]) * ((arg2[5]) * 0x2));
    x15 = ((uint64_t)(arg1[18]) * (arg2[4]));
    x16 = ((uint64_t)(arg1[18]) * ((arg2[3]) * 0x2));
    x17 = ((uint64_t)(arg1[18]) * (arg2[2]));
    x18 = ((uint64_t)(arg1[18]) * ((arg2[1]) * 0x2));
    x19 = ((uint64_t)(arg1[17]) * ((arg2[18]) * 0x2));
    x20 = ((uint64_t)(arg1[17]) * ((arg2[17]) * 0x2));
    x21 = ((uint64_t)(arg1[17]) * ((arg2[16]) * 0x2));
    x22 = ((uint64_t)(arg1[17]) * ((arg2[15]) * 0x2));
    x23 = ((uint64_t)(arg1[17]) * (arg2[14]));
    x24 = ((uint64_t)(arg1[17]) * ((arg2[13]) * 0x2));
    x25 = ((uint64_t)(arg1[17]) * ((arg2[12]) * 0x2));
    x26 = ((uint64_t)(arg1[17]) * ((arg2[11]) * 0x2));
    x27 = ((uint64_t)(arg1[17]) * ((arg2[10]) * 0x2));
    x28 = ((uint64_t)(arg1[17]) * ((arg2[9]) * 0x2));
    x29 = ((uint64_t)(arg1[17]) * ((arg2[8]) * 0x2));
    x30 = ((uint64_t)(arg1[17]) * (arg2[7]));
    x31 = ((uint64_t)(arg1[17]) * ((arg2[6]) * 0x2));
    x32 = ((uint64_t)(arg1[17]) * ((arg2[5]) * 0x2));
    x33 = ((uint64_t)(arg1[17]) * ((arg2[4]) * 0x2));
    x34 = ((uint64_t)(arg1[17]) * ((arg2[3]) * 0x2));
    x35 = ((uint64_t)(arg1[17]) * ((arg2[2]) * 0x2));
    x36 = ((uint64_t)(arg1[16]) * (arg2[18]));
    x37 = ((uint64_t)(arg1[16]) * ((arg2[17]) * 0x2));
    x38 = ((uint64_t)(arg1[16]) * (arg2[16]));
    x39 = ((uint64_t)(arg1[16]) * (arg2[15]));
    x40 = ((uint64_t)(arg1[16]) * (arg2[14]));
    x41 = ((uint64_t)(arg1[16]) * (arg2[13]));
    x42 = ((uint64_t)(arg1[16]) * ((arg2[12]) * 0x2));
    x43 = ((uint64_t)(arg1[16]) * (arg2[11]));
    x44 = ((uint64_t)(arg1[16]) * ((arg2[10]) * 0x2));
    x45 = ((uint64_t)(arg1[16]) * (arg2[9]));
    x46 = ((uint64_t)(arg1[16]) * (arg2[8]));
    x47 = ((uint64_t)(arg1[16]) * (arg2[7]));
    x48 = ((uint64_t)(arg1[16]) * (arg2[6]));
    x49 = ((uint64_t)(arg1[16]) * ((arg2[5]) * 0x2));
    x50 = ((uint64_t)(arg1[16]) * (arg2[4]));
    x51 = ((uint64_t)(arg1[16]) * ((arg2[3]) * 0x2));
    x52 = ((uint64_t)(arg1[15]) * ((arg2[18]) * 0x2));
    x53 = ((uint64_t)(arg1[15]) * ((arg2[17]) * 0x2));
    x54 = ((uint64_t)(arg1[15]) * (arg2[16]));
    x55 = ((uint64_t)(arg1[15]) * ((arg2[15]) * 0x2));
    x56 = ((uint64_t)(arg1[15]) * (arg2[14]));
    x57 = ((uint64_t)(arg1[15]) * ((arg2[13]) * 0x2));
    x58 = ((uint64_t)(arg1[15]) * ((arg2[12]) * 0x2));
    x59 = ((uint64_t)(arg1[15]) * ((arg2[11]) * 0x2));
    x60 = ((uint64_t)(arg1[15]) * ((arg2[10]) * 0x2));
    x61 = ((uint64_t)(arg1[15]) * (arg2[9]));
    x62 = ((uint64_t)(arg1[15]) * ((arg2[8]) * 0x2));
    x63 = ((uint64_t)(arg1[15]) * (arg2[7]));
    x64 = ((uint64_t)(arg1[15]) * ((arg2[6]) * 0x2));
    x65 = ((uint64_t)(arg1[15]) * ((arg2[5]) * 0x2));
    x66 = ((uint64_t)(arg1[15]) * ((arg2[4]) * 0x2));
    x67 = ((uint64_t)(arg1[14]) * (arg2[18]));
    x68 = ((uint64_t)(arg1[14]) * (arg2[17]));
    x69 = ((uint64_t)(arg1[14]) * (arg2[16]));
    x70 = ((uint64_t)(arg1[14]) * (arg2[15]));
    x71 = ((uint64_t)(arg1[14]) * (arg2[14]));
    x72 = ((uint64_t)(arg1[14]) * (arg2[13]));
    x73 = ((uint64_t)(arg1[14]) * ((arg2[12]) * 0x2));
    x74 = ((uint64_t)(arg1[14]) * (arg2[11]));
    x75 = ((uint64_t)(arg1[14]) * (arg2[10]));
    x76 = ((uint64_t)(arg1[14]) * (arg2[9]));
    x77 = ((uint64_t)(arg1[14]) * (arg2[8]));
    x78 = ((uint64_t)(arg1[14]) * (arg2[7]));
    x79 = ((uint64_t)(arg1[14]) * (arg2[6]));
    x80 = ((uint64_t)(arg1[14]) * ((arg2[5]) * 0x2));
    x81 = ((uint64_t)(arg1[13]) * (arg2[18]));
    x82 = ((uint64_t)(arg1[13]) * ((arg2[17]) * 0x2));
    x83 = ((uint64_t)(arg1[13]) * (arg2[16]));
    x84 = ((uint64_t)(arg1[13]) * ((arg2[15]) * 0x2));
    x85 = ((uint64_t)(arg1[13]) * (arg2[14]));
    x86 = ((uint64_t)(arg1[13]) * ((arg2[13]) * 0x2));
    x87 = ((uint64_t)(arg1[13]) * ((arg2[12]) * 0x2));
    x88 = ((uint64_t)(arg1[13]) * (arg2[11]));
    x89 = ((uint64_t)(arg1[13]) * ((arg2[10]) * 0x2));
    x90 = ((uint64_t)(arg1[13]) * (arg2[9]));
    x91 = ((uint64_t)(arg1[13]) * ((arg2[8]) * 0x2));
    x92 = ((uint64_t)(arg1[13]) * (arg2[7]));
    x93 = ((uint64_t)(arg1[13]) * ((arg2[6]) * 0x2));
    x94 = ((uint64_t)(arg1[12]) * ((arg2[18]) * 0x2));
    x95 = ((uint64_t)(arg1[12]) * ((arg2[17]) * 0x2));
    x96 = ((uint64_t)(arg1[12]) * ((arg2[16]) * 0x2));
    x97 = ((uint64_t)(arg1[12]) * ((arg2[15]) * 0x2));
    x98 = ((uint64_t)(arg1[12]) * ((arg2[14]) * 0x2));
    x99 = ((uint64_t)(arg1[12]) * ((arg2[13]) * 0x2));
    x100 = ((uint64_t)(arg1[12]) * ((arg2[12]) * 0x2));
    x101 = ((uint64_t)(arg1[12]) * ((arg2[11]) * 0x2));
    x102 = ((uint64_t)(arg1[12]) * ((arg2[10]) * 0x2));
    x103 = ((uint64_t)(arg1[12]) * ((arg2[9]) * 0x2));
    x104 = ((uint64_t)(arg1[12]) * ((arg2[8]) * 0x2));
    x105 = ((uint64_t)(arg1[12]) * ((arg2[7]) * 0x2));
    x106 = ((uint64_t)(arg1[11]) * (arg2[18]));
    x107 = ((uint64_t)(arg1[11]) * ((arg2[17]) * 0x2));
    x108 = ((uint64_t)(arg1[11]) * (arg2[16]));
    x109 = ((uint64_t)(arg1[11]) * ((arg2[15]) * 0x2));
    x110 = ((uint64_t)(arg1[11]) * (arg2[14]));
    x111 = ((uint64_t)(arg1[11]) * (arg2[13]));
    x112 = ((uint64_t)(arg1[11]) * ((arg2[12]) * 0x2));
    x113 = ((uint64_t)(arg1[11]) * (arg2[11]));
    x114 = ((uint64_t)(arg1[11]) * ((arg2[10]) * 0x2));
    x115 = ((uint64_t)(arg1[11]) * (arg2[9]));
    x116 = ((uint64_t)(arg1[11]) * ((arg2[8]) * 0x2));
    x117 = ((uint64_t)(arg1[10]) * ((arg2[18]) * 0x2));
    x118 = ((uint64_t)(arg1[10]) * ((arg2[17]) * 0x2));
    x119 = ((uint64_t)(arg1[10]) * ((arg2[16]) * 0x2));
    x120 = ((uint64_t)(arg1[10]) * ((arg2[15]) * 0x2));
    x121 = ((uint64_t)(arg1[10]) * (arg2[14]));
    x122 = ((uint64_t)(arg1[10]) * ((arg2[13]) * 0x2));
    x123 = ((uint64_t)(arg1[10]) * ((arg2[12]) * 0x2));
    x124 = ((uint64_t)(arg1[10]) * ((arg2[11]) * 0x2));
    x125 = ((uint64_t)(arg1[10]) * ((arg2[10]) * 0x2));
    x126 = ((uint64_t)(arg1[10]) * ((arg2[9]) * 0x2));
    x127 = ((uint64_t)(arg1[9]) * (arg2[18]));
    x128 = ((uint64_t)(arg1[9]) * ((arg2[17]) * 0x2));
    x129 = ((uint64_t)(arg1[9]) * (arg2[16]));
    x130 = ((uint64_t)(arg1[9]) * (arg2[15]));
    x131 = ((uint64_t)(arg1[9]) * (arg2[14]));
    x132 = ((uint64_t)(arg1[9]) * (arg2[13]));
    x133 = ((uint64_t)(arg1[9]) * ((arg2[12]) * 0x2));
    x134 = ((uint64_t)(arg1[9]) * (arg2[11]));
    x135 = ((uint64_t)(arg1[9]) * ((arg2[10]) * 0x2));
    x136 = ((uint64_t)(arg1[8]) * ((arg2[18]) * 0x2));
    x137 = ((uint64_t)(arg1[8]) * ((arg2[17]) * 0x2));
    x138 = ((uint64_t)(arg1[8]) * (arg2[16]));
    x139 = ((uint64_t)(arg1[8]) * ((arg2[15]) * 0x2));
    x140 = ((uint64_t)(arg1[8]) * (arg2[14]));
    x141 = ((uint64_t)(arg1[8]) * ((arg2[13]) * 0x2));
    x142 = ((uint64_t)(arg1[8]) * ((arg2[12]) * 0x2));
    x143 = ((uint64_t)(arg1[8]) * ((arg2[11]) * 0x2));
    x144 = ((uint64_t)(arg1[7]) * (arg2[18]));
    x145 = ((uint64_t)(arg1[7]) * (arg2[17]));
    x146 = ((uint64_t)(arg1[7]) * (arg2[16]));
    x147 = ((uint64_t)(arg1[7]) * (arg2[15]));
    x148 = ((uint64_t)(arg1[7]) * (arg2[14]));
    x149 = ((uint64_t)(arg1[7]) * (arg2[13]));
    x150 = ((uint64_t)(arg1[7]) * ((arg2[12]) * 0x2));
    x151 = ((uint64_t)(arg1[6]) * (arg2[18]));
    x152 = ((uint64_t)(arg1[6]) * ((arg2[17]) * 0x2));
    x153 = ((uint64_t)(arg1[6]) * (arg2[16]));
    x154 = ((uint64_t)(arg1[6]) * ((arg2[15]) * 0x2));
    x155 = ((uint64_t)(arg1[6]) * (arg2[14]));
    x156 = ((uint64_t)(arg1[6]) * ((arg2[13]) * 0x2));
    x157 = ((uint64_t)(arg1[5]) * ((arg2[18]) * 0x2));
    x158 = ((uint64_t)(arg1[5]) * ((arg2[17]) * 0x2));
    x159 = ((uint64_t)(arg1[5]) * ((arg2[16]) * 0x2));
    x160 = ((uint64_t)(arg1[5]) * ((arg2[15]) * 0x2));
    x161 = ((uint64_t)(arg1[5]) * ((arg2[14]) * 0x2));
    x162 = ((uint64_t)(arg1[4]) * (arg2[18]));
    x163 = ((uint64_t)(arg1[4]) * ((arg2[17]) * 0x2));
    x164 = ((uint64_t)(arg1[4]) * (arg2[16]));
    x165 = ((uint64_t)(arg1[4]) * ((arg2[15]) * 0x2));
    x166 = ((uint64_t)(arg1[3]) * ((arg2[18]) * 0x2));
    x167 = ((uint64_t)(arg1[3]) * ((arg2[17]) * 0x2));
    x168 = ((uint64_t)(arg1[3]) * ((arg2[16]) * 0x2));
    x169 = ((uint64_t)(arg1[2]) * (arg2[18]));
    x170 = ((uint64_t)(arg1[2]) * ((arg2[17]) * 0x2));
    x171 = ((uint64_t)(arg1[1]) * ((arg2[18]) * 0x2));
    x172 = ((uint64_t)(arg1[18]) * (arg2[0]));
    x173 = ((uint64_t)(arg1[17]) * ((arg2[1]) * 0x2));
    x174 = ((uint64_t)(arg1[17]) * (arg2[0]));
    x175 = ((uint64_t)(arg1[16]) * (arg2[2]));
    x176 = ((uint64_t)(arg1[16]) * (arg2[1]));
    x177 = ((uint64_t)(arg1[16]) * (arg2[0]));
    x178 = ((uint64_t)(arg1[15]) * ((arg2[3]) * 0x2));
    x179 = ((uint64_t)(arg1[15]) * (arg2[2]));
    x180 = ((uint64_t)(arg1[15]) * ((arg2[1]) * 0x2));
    x181 = ((uint64_t)(arg1[15]) * (arg2[0]));
    x182 = ((uint64_t)(arg1[14]) * (arg2[4]));
    x183 = ((uint64_t)(arg1[14]) * (arg2[3]));
    x184 = ((uint64_t)(arg1[14]) * (arg2[2]));
    x185 = ((uint64_t)(arg1[14]) * (arg2[1]));
    x186 = ((uint64_t)(arg1[14]) * (arg2[0]));
    x187 = ((uint64_t)(arg1[13]) * ((arg2[5]) * 0x2));
    x188 = ((uint64_t)(arg1[13]) * (arg2[4]));
    x189 = ((uint64_t)(arg1[13]) * ((arg2[3]) * 0x2));
    x190 = ((uint64_t)(arg1[13]) * (arg2[2]));
    x191 = ((uint64_t)(arg1[13]) * ((arg2[1]) * 0x2));
    x192 = ((uint64_t)(arg1[13]) * (arg2[0]));
    x193 = ((uint64_t)(arg1[12]) * ((arg2[6]) * 0x2));
    x194 = ((uint64_t)(arg1[12]) * ((arg2[5]) * 0x2));
    x195 = ((uint64_t)(arg1[12]) * ((arg2[4]) * 0x2));
    x196 = ((uint64_t)(arg1[12]) * ((arg2[3]) * 0x2));
    x197 = ((uint64_t)(arg1[12]) * ((arg2[2]) * 0x2));
    x198 = ((uint64_t)(arg1[12]) * ((arg2[1]) * 0x2));
    x199 = ((uint64_t)(arg1[12]) * (arg2[0]));
    x200 = ((uint64_t)(arg1[11]) * (arg2[7]));
    x201 = ((uint64_t)(arg1[11]) * (arg2[6]));
    x202 = ((uint64_t)(arg1[11]) * ((arg2[5]) * 0x2));
    x203 = ((uint64_t)(arg1[11]) * (arg2[4]));
    x204 = ((uint64_t)(arg1[11]) * ((arg2[3]) * 0x2));
    x205 = ((uint64_t)(arg1[11]) * (arg2[2]));
    x206 = ((uint64_t)(arg1[11]) * (arg2[1]));
    x207 = ((uint64_t)(arg1[11]) * (arg2[0]));
    x208 = ((uint64_t)(arg1[10]) * ((arg2[8]) * 0x2));
    x209 = ((uint64_t)(arg1[10]) * (arg2[7]));
    x210 = ((uint64_t)(arg1[10]) * ((arg2[6]) * 0x2));
    x211 = ((uint64_t)(arg1[10]) * ((arg2[5]) * 0x2));
    x212 = ((uint64_t)(arg1[10]) * ((arg2[4]) * 0x2));
    x213 = ((uint64_t)(arg1[10]) * ((arg2[3]) * 0x2));
    x214 = ((uint64_t)(arg1[10]) * (arg2[2]));
    x215 = ((uint64_t)(arg1[10]) * ((arg2[1]) * 0x2));
    x216 = ((uint64_t)(arg1[10]) * (arg2[0]));
    x217 = ((uint64_t)(arg1[9]) * (arg2[9]));
    x218 = ((uint64_t)(arg1[9]) * (arg2[8]));
    x219 = ((uint64_t)(arg1[9]) * (arg2[7]));
    x220 = ((uint64_t)(arg1[9]) * (arg2[6]));
    x221 = ((uint64_t)(arg1[9]) * ((arg2[5]) * 0x2));
    x222 = ((uint64_t)(arg1[9]) * (arg2[4]));
    x223 = ((uint64_t)(arg1[9]) * (arg2[3]));
    x224 = ((uint64_t)(arg1[9]) * (arg2[2]));
    x225 = ((uint64_t)(arg1[9]) * (arg2[1]));
    x226 = ((uint64_t)(arg1[9]) * (arg2[0]));
    x227 = ((uint64_t)(arg1[8]) * ((arg2[10]) * 0x2));
    x228 = ((uint64_t)(arg1[8]) * (arg2[9]));
    x229 = ((uint64_t)(arg1[8]) * ((arg2[8]) * 0x2));
    x230 = ((uint64_t)(arg1[8]) * (arg2[7]));
    x231 = ((uint64_t)(arg1[8]) * ((arg2[6]) * 0x2));
    x232 = ((uint64_t)(arg1[8]) * ((arg2[5]) * 0x2));
    x233 = ((uint64_t)(arg1[8]) * (arg2[4]));
    x234 = ((uint64_t)(arg1[8]) * ((arg2[3]) * 0x2));
    x235 = ((uint64_t)(arg1[8]) * (arg2[2]));
    x236 = ((uint64_t)(arg1[8]) * ((arg2[1]) * 0x2));
    x237 = ((uint64_t)(arg1[8]) * (arg2[0]));
    x238 = ((uint64_t)(arg1[7]) * (arg2[11]));
    x239 = ((uint64_t)(arg1[7]) * (arg2[10]));
    x240 = ((uint64_t)(arg1[7]) * (arg2[9]));
    x241 = ((uint64_t)(arg1[7]) * (arg2[8]));
    x242 = ((uint64_t)(arg1[7]) * (arg2[7]));
    x243 = ((uint64_t)(arg1[7]) * (arg2[6]));
    x244 = ((uint64_t)(arg1[7]) * (arg2[5]));
    x245 = ((uint64_t)(arg1[7]) * (arg2[4]));
    x246 = ((uint64_t)(arg1[7]) * (arg2[3]));
    x247 = ((uint64_t)(arg1[7]) * (arg2[2]));
    x248 = ((uint64_t)(arg1[7]) * (arg2[1]));
    x249 = ((uint64_t)(arg1[7]) * (arg2[0]));
    x250 = ((uint64_t)(arg1[6]) * ((arg2[12]) * 0x2));
    x251 = ((uint64_t)(arg1[6]) * (arg2[11]));
    x252 = ((uint64_t)(arg1[6]) * ((arg2[10]) * 0x2));
    x253 = ((uint64_t)(arg1[6]) * (arg2[9]));
    x254 = ((uint64_t)(arg1[6]) * ((arg2[8]) * 0x2));
    x255 = ((uint64_t)(arg1[6]) * (arg2[7]));
    x256 = ((uint64_t)(arg1[6]) * (arg2[6]));
    x257 = ((uint64_t)(arg1[6]) * ((arg2[5]) * 0x2));
    x258 = ((uint64_t)(arg1[6]) * (arg2[4]));
    x259 = ((uint64_t)(arg1[6]) * ((arg2[3]) * 0x2));
    x260 = ((uint64_t)(arg1[6]) * (arg2[2]));
    x261 = ((uint64_t)(arg1[6]) * ((arg2[1]) * 0x2));
    x262 = ((uint64_t)(arg1[6]) * (arg2[0]));
    x263 = ((uint64_t)(arg1[5]) * ((arg2[13]) * 0x2));
    x264 = ((uint64_t)(arg1[5]) * ((arg2[12]) * 0x2));
    x265 = ((uint64_t)(arg1[5]) * ((arg2[11]) * 0x2));
    x266 = ((uint64_t)(arg1[5]) * ((arg2[10]) * 0x2));
    x267 = ((uint64_t)(arg1[5]) * ((arg2[9]) * 0x2));
    x268 = ((uint64_t)(arg1[5]) * ((arg2[8]) * 0x2));
    x269 = ((uint64_t)(arg1[5]) * (arg2[7]));
    x270 = ((uint64_t)(arg1[5]) * ((arg2[6]) * 0x2));
    x271 = ((uint64_t)(arg1[5]) * ((arg2[5]) * 0x2));
    x272 = ((uint64_t)(arg1[5]) * ((arg2[4]) * 0x2));
    x273 = ((uint64_t)(arg1[5]) * ((arg2[3]) * 0x2));
    x274 = ((uint64_t)(arg1[5]) * ((arg2[2]) * 0x2));
    x275 = ((uint64_t)(arg1[5]) * ((arg2[1]) * 0x2));
    x276 = ((uint64_t)(arg1[5]) * (arg2[0]));
    x277 = ((uint64_t)(arg1[4]) * (arg2[14]));
    x278 = ((uint64_t)(arg1[4]) * (arg2[13]));
    x279 = ((uint64_t)(arg1[4]) * ((arg2[12]) * 0x2));
    x280 = ((uint64_t)(arg1[4]) * (arg2[11]));
    x281 = ((uint64_t)(arg1[4]) * ((arg2[10]) * 0x2));
    x282 = ((uint64_t)(arg1[4]) * (arg2[9]));
    x283 = ((uint64_t)(arg1[4]) * (arg2[8]));
    x284 = ((uint64_t)(arg1[4]) * (arg2[7]));
    x285 = ((uint64_t)(arg1[4]) * (arg2[6]));
    x286 = ((uint64_t)(arg1[4]) * ((arg2[5]) * 0x2));
    x287 = ((uint64_t)(arg1[4]) * (arg2[4]));
    x288 = ((uint64_t)(arg1[4]) * ((arg2[3]) * 0x2));
    x289 = ((uint64_t)(arg1[4]) * (arg2[2]));
    x290 = ((uint64_t)(arg1[4]) * (arg2[1]));
    x291 = ((uint64_t)(arg1[4]) * (arg2[0]));
    x292 = ((uint64_t)(arg1[3]) * ((arg2[15]) * 0x2));
    x293 = ((uint64_t)(arg1[3]) * (arg2[14]));
    x294 = ((uint64_t)(arg1[3]) * ((arg2[13]) * 0x2));
    x295 = ((uint64_t)(arg1[3]) * ((arg2[12]) * 0x2));
    x296 = ((uint64_t)(arg1[3]) * ((arg2[11]) * 0x2));
    x297 = ((uint64_t)(arg1[3]) * ((arg2[10]) * 0x2));
    x298 = ((uint64_t)(arg1[3]) * (arg2[9]));
    x299 = ((uint64_t)(arg1[3]) * ((arg2[8]) * 0x2));
    x300 = ((uint64_t)(arg1[3]) * (arg2[7]));
    x301 = ((uint64_t)(arg1[3]) * ((arg2[6]) * 0x2));
    x302 = ((uint64_t)(arg1[3]) * ((arg2[5]) * 0x2));
    x303 = ((uint64_t)(arg1[3]) * ((arg2[4]) * 0x2));
    x304 = ((uint64_t)(arg1[3]) * ((arg2[3]) * 0x2));
    x305 = ((uint64_t)(arg1[3]) * (arg2[2]));
    x306 = ((uint64_t)(arg1[3]) * ((arg2[1]) * 0x2));
    x307 = ((uint64_t)(arg1[3]) * (arg2[0]));
    x308 = ((uint64_t)(arg1[2]) * (arg2[16]));
    x309 = ((uint64_t)(arg1[2]) * (arg2[15]));
    x310 = ((uint64_t)(arg1[2]) * (arg2[14]));
    x311 = ((uint64_t)(arg1[2]) * (arg2[13]));
    x312 = ((uint64_t)(arg1[2]) * ((arg2[12]) * 0x2));
    x313 = ((uint64_t)(arg1[2]) * (arg2[11]));
    x314 = ((uint64_t)(arg1[2]) * (arg2[10]));
    x315 = ((uint64_t)(arg1[2]) * (arg2[9]));
    x316 = ((uint64_t)(arg1[2]) * (arg2[8]));
    x317 = ((uint64_t)(arg1[2]) * (arg2[7]));
    x318 = ((uint64_t)(arg1[2]) * (arg2[6]));
    x319 = ((uint64_t)(arg1[2]) * ((arg2[5]) * 0x2));
    x320 = ((uint64_t)(arg1[2]) * (arg2[4]));
    x321 = ((uint64_t)(arg1[2]) * (arg2[3]));
    x322 = ((uint64_t)(arg1[2]) * (arg2[2]));
    x323 = ((uint64_t)(arg1[2]) * (arg2[1]));
    x324 = ((uint64_t)(arg1[2]) * (arg2[0]));
    x325 = ((uint64_t)(arg1[1]) * ((arg2[17]) * 0x2));
    x326 = ((uint64_t)(arg1[1]) * (arg2[16]));
    x327 = ((uint64_t)(arg1[1]) * ((arg2[15]) * 0x2));
    x328 = ((uint64_t)(arg1[1]) * (arg2[14]));
    x329 = ((uint64_t)(arg1[1]) * ((arg2[13]) * 0x2));
    x330 = ((uint64_t)(arg1[1]) * ((arg2[12]) * 0x2));
    x331 = ((uint64_t)(arg1[1]) * (arg2[11]));
    x332 = ((uint64_t)(arg1[1]) * ((arg2[10]) * 0x2));
    x333 = ((uint64_t)(arg1[1]) * (arg2[9]));
    x334 = ((uint64_t)(arg1[1]) * ((arg2[8]) * 0x2));
    x335 = ((uint64_t)(arg1[1]) * (arg2[7]));
    x336 = ((uint64_t)(arg1[1]) * ((arg2[6]) * 0x2));
    x337 = ((uint64_t)(arg1[1]) * ((arg2[5]) * 0x2));
    x338 = ((uint64_t)(arg1[1]) * (arg2[4]));
    x339 = ((uint64_t)(arg1[1]) * ((arg2[3]) * 0x2));
    x340 = ((uint64_t)(arg1[1]) * (arg2[2]));
    x341 = ((uint64_t)(arg1[1]) * ((arg2[1]) * 0x2));
    x342 = ((uint64_t)(arg1[1]) * (arg2[0]));
    x343 = ((uint64_t)(arg1[0]) * (arg2[18]));
    x344 = ((uint64_t)(arg1[0]) * (arg2[17]));
    x345 = ((uint64_t)(arg1[0]) * (arg2[16]));
    x346 = ((uint64_t)(arg1[0]) * (arg2[15]));
    x347 = ((uint64_t)(arg1[0]) * (arg2[14]));
    x348 = ((uint64_t)(arg1[0]) * (arg2[13]));
    x349 = ((uint64_t)(arg1[0]) * (arg2[12]));
    x350 = ((uint64_t)(arg1[0]) * (arg2[11]));
    x351 = ((uint64_t)(arg1[0]) * (arg2[10]));
    x352 = ((uint64_t)(arg1[0]) * (arg2[9]));
    x353 = ((uint64_t)(arg1[0]) * (arg2[8]));
    x354 = ((uint64_t)(arg1[0]) * (arg2[7]));
    x355 = ((uint64_t)(arg1[0]) * (arg2[6]));
    x356 = ((uint64_t)(arg1[0]) * (arg2[5]));
    x357 = ((uint64_t)(arg1[0]) * (arg2[4]));
    x358 = ((uint64_t)(arg1[0]) * (arg2[3]));
    x359 = ((uint64_t)(arg1[0]) * (arg2[2]));
    x360 = ((uint64_t)(arg1[0]) * (arg2[1]));
    x361 = ((uint64_t)(arg1[0]) * (arg2[0]));
    x362 =
        (x361 +
         (x171 +
          (x170 +
           (x168 +
            (x165 +
             (x161 +
              (x156 +
               (x150 +
                (x143 +
                 (x135 +
                  (x126 +
                   (x116 +
                    (x105 +
                     (x93 + (x80 + (x66 + (x51 + (x35 + x18))))))))))))))))));
    x363 = (x362 >> 28);
    x364 = (uint32_t)(x362 & UINT32_C(0xfffffff));
    x365 = (x343 +
            (x325 +
             (x308 +
              (x292 +
               (x277 +
                (x263 +
                 (x250 +
                  (x238 +
                   (x227 +
                    (x217 +
                     (x208 +
                      (x200 +
                       (x193 +
                        (x187 +
                         (x182 + (x178 + (x175 + (x173 + x172))))))))))))))))));
    x366 = (x344 +
            (x326 +
             (x309 +
              (x293 +
               (x278 +
                (x264 +
                 (x251 +
                  (x239 +
                   (x228 +
                    (x218 +
                     (x209 +
                      (x201 +
                       (x194 +
                        (x188 +
                         (x183 + (x179 + (x176 + (x174 + x1))))))))))))))))));
    x367 = (x345 +
            (x327 +
             (x310 +
              (x294 +
               (x279 +
                (x265 +
                 (x252 +
                  (x240 +
                   (x229 +
                    (x219 +
                     (x210 +
                      (x202 +
                       (x195 +
                        (x189 +
                         (x184 + (x180 + (x177 + (x19 + x2))))))))))))))))));
    x368 =
        (x346 +
         (x328 +
          (x311 +
           (x295 +
            (x280 +
             (x266 +
              (x253 +
               (x241 +
                (x230 +
                 (x220 +
                  (x211 +
                   (x203 +
                    (x196 +
                     (x190 + (x185 + (x181 + (x36 + (x20 + x3))))))))))))))))));
    x369 =
        (x347 +
         (x329 +
          (x312 +
           (x296 +
            (x281 +
             (x267 +
              (x254 +
               (x242 +
                (x231 +
                 (x221 +
                  (x212 +
                   (x204 +
                    (x197 +
                     (x191 + (x186 + (x52 + (x37 + (x21 + x4))))))))))))))))));
    x370 =
        (x348 +
         (x330 +
          (x313 +
           (x297 +
            (x282 +
             (x268 +
              (x255 +
               (x243 +
                (x232 +
                 (x222 +
                  (x213 +
                   (x205 +
                    (x198 +
                     (x192 + (x67 + (x53 + (x38 + (x22 + x5))))))))))))))))));
    x371 = (x349 +
            (x331 +
             (x314 +
              (x298 +
               (x283 +
                (x269 +
                 (x256 +
                  (x244 +
                   (x233 +
                    (x223 +
                     (x214 +
                      (x206 +
                       (x199 +
                        (x81 + (x68 + (x54 + (x39 + (x23 + x6))))))))))))))))));
    x372 = (x350 +
            (x332 +
             (x315 +
              (x299 +
               (x284 +
                (x270 +
                 (x257 +
                  (x245 +
                   (x234 +
                    (x224 +
                     (x215 +
                      (x207 +
                       (x94 +
                        (x82 + (x69 + (x55 + (x40 + (x24 + x7))))))))))))))))));
    x373 = (x351 +
            (x333 +
             (x316 +
              (x300 +
               (x285 +
                (x271 +
                 (x258 +
                  (x246 +
                   (x235 +
                    (x225 +
                     (x216 +
                      (x106 +
                       (x95 +
                        (x83 + (x70 + (x56 + (x41 + (x25 + x8))))))))))))))))));
    x374 = (x352 +
            (x334 +
             (x317 +
              (x301 +
               (x286 +
                (x272 +
                 (x259 +
                  (x247 +
                   (x236 +
                    (x226 +
                     (x117 +
                      (x107 +
                       (x96 +
                        (x84 + (x71 + (x57 + (x42 + (x26 + x9))))))))))))))))));
    x375 =
        (x353 +
         (x335 +
          (x318 +
           (x302 +
            (x287 +
             (x273 +
              (x260 +
               (x248 +
                (x237 +
                 (x127 +
                  (x118 +
                   (x108 +
                    (x97 +
                     (x85 + (x72 + (x58 + (x43 + (x27 + x10))))))))))))))))));
    x376 =
        (x354 +
         (x336 +
          (x319 +
           (x303 +
            (x288 +
             (x274 +
              (x261 +
               (x249 +
                (x136 +
                 (x128 +
                  (x119 +
                   (x109 +
                    (x98 +
                     (x86 + (x73 + (x59 + (x44 + (x28 + x11))))))))))))))))));
    x377 =
        (x355 +
         (x337 +
          (x320 +
           (x304 +
            (x289 +
             (x275 +
              (x262 +
               (x144 +
                (x137 +
                 (x129 +
                  (x120 +
                   (x110 +
                    (x99 +
                     (x87 + (x74 + (x60 + (x45 + (x29 + x12))))))))))))))))));
    x378 =
        (x356 +
         (x338 +
          (x321 +
           (x305 +
            (x290 +
             (x276 +
              (x151 +
               (x145 +
                (x138 +
                 (x130 +
                  (x121 +
                   (x111 +
                    (x100 +
                     (x88 + (x75 + (x61 + (x46 + (x30 + x13))))))))))))))))));
    x379 =
        (x357 +
         (x339 +
          (x322 +
           (x306 +
            (x291 +
             (x157 +
              (x152 +
               (x146 +
                (x139 +
                 (x131 +
                  (x122 +
                   (x112 +
                    (x101 +
                     (x89 + (x76 + (x62 + (x47 + (x31 + x14))))))))))))))))));
    x380 =
        (x358 +
         (x340 +
          (x323 +
           (x307 +
            (x162 +
             (x158 +
              (x153 +
               (x147 +
                (x140 +
                 (x132 +
                  (x123 +
                   (x113 +
                    (x102 +
                     (x90 + (x77 + (x63 + (x48 + (x32 + x15))))))))))))))))));
    x381 =
        (x359 +
         (x341 +
          (x324 +
           (x166 +
            (x163 +
             (x159 +
              (x154 +
               (x148 +
                (x141 +
                 (x133 +
                  (x124 +
                   (x114 +
                    (x103 +
                     (x91 + (x78 + (x64 + (x49 + (x33 + x16))))))))))))))))));
    x382 =
        (x360 +
         (x342 +
          (x169 +
           (x167 +
            (x164 +
             (x160 +
              (x155 +
               (x149 +
                (x142 +
                 (x134 +
                  (x125 +
                   (x115 +
                    (x104 +
                     (x92 + (x79 + (x65 + (x50 + (x34 + x17))))))))))))))))));
    x383 = (x363 + x382);
    x384 = (x383 >> 27);
    x385 = (uint32_t)(x383 & UINT32_C(0x7ffffff));
    x386 = (x384 + x381);
    x387 = (x386 >> 28);
    x388 = (uint32_t)(x386 & UINT32_C(0xfffffff));
    x389 = (x387 + x380);
    x390 = (x389 >> 27);
    x391 = (uint32_t)(x389 & UINT32_C(0x7ffffff));
    x392 = (x390 + x379);
    x393 = (x392 >> 28);
    x394 = (uint32_t)(x392 & UINT32_C(0xfffffff));
    x395 = (x393 + x378);
    x396 = (x395 >> 27);
    x397 = (uint32_t)(x395 & UINT32_C(0x7ffffff));
    x398 = (x396 + x377);
    x399 = (x398 >> 27);
    x400 = (uint32_t)(x398 & UINT32_C(0x7ffffff));
    x401 = (x399 + x376);
    x402 = (x401 >> 28);
    x403 = (uint32_t)(x401 & UINT32_C(0xfffffff));
    x404 = (x402 + x375);
    x405 = (x404 >> 27);
    x406 = (uint32_t)(x404 & UINT32_C(0x7ffffff));
    x407 = (x405 + x374);
    x408 = (x407 >> 28);
    x409 = (uint32_t)(x407 & UINT32_C(0xfffffff));
    x410 = (x408 + x373);
    x411 = (x410 >> 27);
    x412 = (uint32_t)(x410 & UINT32_C(0x7ffffff));
    x413 = (x411 + x372);
    x414 = (x413 >> 28);
    x415 = (uint32_t)(x413 & UINT32_C(0xfffffff));
    x416 = (x414 + x371);
    x417 = (x416 >> 27);
    x418 = (uint32_t)(x416 & UINT32_C(0x7ffffff));
    x419 = (x417 + x370);
    x420 = (x419 >> 27);
    x421 = (uint32_t)(x419 & UINT32_C(0x7ffffff));
    x422 = (x420 + x369);
    x423 = (x422 >> 28);
    x424 = (uint32_t)(x422 & UINT32_C(0xfffffff));
    x425 = (x423 + x368);
    x426 = (x425 >> 27);
    x427 = (uint32_t)(x425 & UINT32_C(0x7ffffff));
    x428 = (x426 + x367);
    x429 = (x428 >> 28);
    x430 = (uint32_t)(x428 & UINT32_C(0xfffffff));
    x431 = (x429 + x366);
    x432 = (x431 >> 27);
    x433 = (uint32_t)(x431 & UINT32_C(0x7ffffff));
    x434 = (x432 + x365);
    x435 = (x434 >> 27);
    x436 = (uint32_t)(x434 & UINT32_C(0x7ffffff));
    x437 = (x364 + x435);
    x438 = (uint32_t)(x437 >> 28);
    x439 = (uint32_t)(x437 & UINT32_C(0xfffffff));
    x440 = (x438 + x385);
    x441 = (fiat_secp521r1_uint1)(x440 >> 27);
    x442 = (x440 & UINT32_C(0x7ffffff));
    x443 = (x441 + x388);
    out1[0] = x439;
    out1[1] = x442;
    out1[2] = x443;
    out1[3] = x391;
    out1[4] = x394;
    out1[5] = x397;
    out1[6] = x400;
    out1[7] = x403;
    out1[8] = x406;
    out1[9] = x409;
    out1[10] = x412;
    out1[11] = x415;
    out1[12] = x418;
    out1[13] = x421;
    out1[14] = x424;
    out1[15] = x427;
    out1[16] = x430;
    out1[17] = x433;
    out1[18] = x436;
}

/*
 * The function fiat_secp521r1_carry_square squares a field element and reduces the result.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 */
static void fiat_secp521r1_carry_square(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_loose_field_element arg1) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    uint64_t x87;
    uint64_t x88;
    uint64_t x89;
    uint64_t x90;
    uint64_t x91;
    uint64_t x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    uint64_t x136;
    uint64_t x137;
    uint64_t x138;
    uint64_t x139;
    uint64_t x140;
    uint64_t x141;
    uint64_t x142;
    uint64_t x143;
    uint64_t x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    uint64_t x162;
    uint64_t x163;
    uint64_t x164;
    uint64_t x165;
    uint64_t x166;
    uint64_t x167;
    uint64_t x168;
    uint64_t x169;
    uint64_t x170;
    uint64_t x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    uint64_t x176;
    uint64_t x177;
    uint64_t x178;
    uint64_t x179;
    uint64_t x180;
    uint64_t x181;
    uint64_t x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    uint64_t x189;
    uint64_t x190;
    uint64_t x191;
    uint64_t x192;
    uint64_t x193;
    uint64_t x194;
    uint64_t x195;
    uint64_t x196;
    uint64_t x197;
    uint64_t x198;
    uint64_t x199;
    uint64_t x200;
    uint64_t x201;
    uint64_t x202;
    uint64_t x203;
    uint64_t x204;
    uint64_t x205;
    uint64_t x206;
    uint64_t x207;
    uint64_t x208;
    uint64_t x209;
    uint64_t x210;
    uint64_t x211;
    uint64_t x212;
    uint64_t x213;
    uint64_t x214;
    uint64_t x215;
    uint64_t x216;
    uint64_t x217;
    uint64_t x218;
    uint64_t x219;
    uint64_t x220;
    uint64_t x221;
    uint64_t x222;
    uint64_t x223;
    uint64_t x224;
    uint64_t x225;
    uint64_t x226;
    uint64_t x227;
    uint64_t x228;
    uint32_t x229;
    uint64_t x230;
    uint64_t x231;
    uint64_t x232;
    uint64_t x233;
    uint64_t x234;
    uint64_t x235;
    uint64_t x236;
    uint64_t x237;
    uint64_t x238;
    uint64_t x239;
    uint64_t x240;
    uint64_t x241;
    uint64_t x242;
    uint64_t x243;
    uint64_t x244;
    uint64_t x245;
    uint64_t x246;
    uint64_t x247;
    uint64_t x248;
    uint64_t x249;
    uint32_t x250;
    uint64_t x251;
    uint64_t x252;
    uint32_t x253;
    uint64_t x254;
    uint64_t x255;
    uint32_t x256;
    uint64_t x257;
    uint64_t x258;
    uint32_t x259;
    uint64_t x260;
    uint64_t x261;
    uint32_t x262;
    uint64_t x263;
    uint64_t x264;
    uint32_t x265;
    uint64_t x266;
    uint64_t x267;
    uint32_t x268;
    uint64_t x269;
    uint64_t x270;
    uint32_t x271;
    uint64_t x272;
    uint64_t x273;
    uint32_t x274;
    uint64_t x275;
    uint64_t x276;
    uint32_t x277;
    uint64_t x278;
    uint64_t x279;
    uint32_t x280;
    uint64_t x281;
    uint64_t x282;
    uint32_t x283;
    uint64_t x284;
    uint64_t x285;
    uint32_t x286;
    uint64_t x287;
    uint64_t x288;
    uint32_t x289;
    uint64_t x290;
    uint64_t x291;
    uint32_t x292;
    uint64_t x293;
    uint64_t x294;
    uint32_t x295;
    uint64_t x296;
    uint64_t x297;
    uint32_t x298;
    uint64_t x299;
    uint64_t x300;
    uint32_t x301;
    uint64_t x302;
    uint32_t x303;
    uint32_t x304;
    uint32_t x305;
    fiat_secp521r1_uint1 x306;
    uint32_t x307;
    uint32_t x308;
    x1 = (arg1[18]);
    x2 = (x1 * 0x2);
    x3 = ((arg1[18]) * 0x2);
    x4 = (arg1[17]);
    x5 = (x4 * 0x2);
    x6 = ((arg1[17]) * 0x2);
    x7 = (arg1[16]);
    x8 = (x7 * 0x2);
    x9 = ((arg1[16]) * 0x2);
    x10 = (arg1[15]);
    x11 = (x10 * 0x2);
    x12 = ((arg1[15]) * 0x2);
    x13 = (arg1[14]);
    x14 = (x13 * 0x2);
    x15 = ((arg1[14]) * 0x2);
    x16 = (arg1[13]);
    x17 = (x16 * 0x2);
    x18 = ((arg1[13]) * 0x2);
    x19 = (arg1[12]);
    x20 = (x19 * 0x2);
    x21 = ((arg1[12]) * 0x2);
    x22 = (arg1[11]);
    x23 = (x22 * 0x2);
    x24 = ((arg1[11]) * 0x2);
    x25 = (arg1[10]);
    x26 = (x25 * 0x2);
    x27 = ((arg1[10]) * 0x2);
    x28 = ((arg1[9]) * 0x2);
    x29 = ((arg1[8]) * 0x2);
    x30 = ((arg1[7]) * 0x2);
    x31 = ((arg1[6]) * 0x2);
    x32 = ((arg1[5]) * 0x2);
    x33 = ((arg1[4]) * 0x2);
    x34 = ((arg1[3]) * 0x2);
    x35 = ((arg1[2]) * 0x2);
    x36 = ((arg1[1]) * 0x2);
    x37 = ((uint64_t)(arg1[18]) * x1);
    x38 = ((uint64_t)(arg1[17]) * (x2 * 0x2));
    x39 = ((uint64_t)(arg1[17]) * (x4 * 0x2));
    x40 = ((uint64_t)(arg1[16]) * x2);
    x41 = ((uint64_t)(arg1[16]) * (x5 * 0x2));
    x42 = ((uint64_t)(arg1[16]) * x7);
    x43 = ((uint64_t)(arg1[15]) * (x2 * 0x2));
    x44 = ((uint64_t)(arg1[15]) * (x5 * 0x2));
    x45 = ((uint64_t)(arg1[15]) * x8);
    x46 = ((uint64_t)(arg1[15]) * (x10 * 0x2));
    x47 = ((uint64_t)(arg1[14]) * x2);
    x48 = ((uint64_t)(arg1[14]) * x5);
    x49 = ((uint64_t)(arg1[14]) * x8);
    x50 = ((uint64_t)(arg1[14]) * x11);
    x51 = ((uint64_t)(arg1[14]) * x13);
    x52 = ((uint64_t)(arg1[13]) * x2);
    x53 = ((uint64_t)(arg1[13]) * (x5 * 0x2));
    x54 = ((uint64_t)(arg1[13]) * x8);
    x55 = ((uint64_t)(arg1[13]) * (x11 * 0x2));
    x56 = ((uint64_t)(arg1[13]) * x14);
    x57 = ((uint64_t)(arg1[13]) * (x16 * 0x2));
    x58 = ((uint64_t)(arg1[12]) * (x2 * 0x2));
    x59 = ((uint64_t)(arg1[12]) * (x5 * 0x2));
    x60 = ((uint64_t)(arg1[12]) * (x8 * 0x2));
    x61 = ((uint64_t)(arg1[12]) * (x11 * 0x2));
    x62 = ((uint64_t)(arg1[12]) * (x14 * 0x2));
    x63 = ((uint64_t)(arg1[12]) * (x17 * 0x2));
    x64 = ((uint64_t)(arg1[12]) * (x19 * 0x2));
    x65 = ((uint64_t)(arg1[11]) * x2);
    x66 = ((uint64_t)(arg1[11]) * (x5 * 0x2));
    x67 = ((uint64_t)(arg1[11]) * x8);
    x68 = ((uint64_t)(arg1[11]) * (x11 * 0x2));
    x69 = ((uint64_t)(arg1[11]) * x14);
    x70 = ((uint64_t)(arg1[11]) * x17);
    x71 = ((uint64_t)(arg1[11]) * (x20 * 0x2));
    x72 = ((uint64_t)(arg1[11]) * x22);
    x73 = ((uint64_t)(arg1[10]) * (x2 * 0x2));
    x74 = ((uint64_t)(arg1[10]) * (x5 * 0x2));
    x75 = ((uint64_t)(arg1[10]) * (x8 * 0x2));
    x76 = ((uint64_t)(arg1[10]) * (x11 * 0x2));
    x77 = ((uint64_t)(arg1[10]) * x14);
    x78 = ((uint64_t)(arg1[10]) * (x17 * 0x2));
    x79 = ((uint64_t)(arg1[10]) * (x20 * 0x2));
    x80 = ((uint64_t)(arg1[10]) * (x23 * 0x2));
    x81 = ((uint64_t)(arg1[10]) * (x25 * 0x2));
    x82 = ((uint64_t)(arg1[9]) * x2);
    x83 = ((uint64_t)(arg1[9]) * (x5 * 0x2));
    x84 = ((uint64_t)(arg1[9]) * x8);
    x85 = ((uint64_t)(arg1[9]) * x11);
    x86 = ((uint64_t)(arg1[9]) * x14);
    x87 = ((uint64_t)(arg1[9]) * x17);
    x88 = ((uint64_t)(arg1[9]) * (x20 * 0x2));
    x89 = ((uint64_t)(arg1[9]) * x23);
    x90 = ((uint64_t)(arg1[9]) * (x26 * 0x2));
    x91 = ((uint64_t)(arg1[9]) * (arg1[9]));
    x92 = ((uint64_t)(arg1[8]) * (x2 * 0x2));
    x93 = ((uint64_t)(arg1[8]) * (x5 * 0x2));
    x94 = ((uint64_t)(arg1[8]) * x8);
    x95 = ((uint64_t)(arg1[8]) * (x11 * 0x2));
    x96 = ((uint64_t)(arg1[8]) * x14);
    x97 = ((uint64_t)(arg1[8]) * (x17 * 0x2));
    x98 = ((uint64_t)(arg1[8]) * (x20 * 0x2));
    x99 = ((uint64_t)(arg1[8]) * (x23 * 0x2));
    x100 = ((uint64_t)(arg1[8]) * (x27 * 0x2));
    x101 = ((uint64_t)(arg1[8]) * x28);
    x102 = ((uint64_t)(arg1[8]) * ((arg1[8]) * 0x2));
    x103 = ((uint64_t)(arg1[7]) * x2);
    x104 = ((uint64_t)(arg1[7]) * x5);
    x105 = ((uint64_t)(arg1[7]) * x8);
    x106 = ((uint64_t)(arg1[7]) * x11);
    x107 = ((uint64_t)(arg1[7]) * x14);
    x108 = ((uint64_t)(arg1[7]) * x17);
    x109 = ((uint64_t)(arg1[7]) * (x20 * 0x2));
    x110 = ((uint64_t)(arg1[7]) * x24);
    x111 = ((uint64_t)(arg1[7]) * x27);
    x112 = ((uint64_t)(arg1[7]) * x28);
    x113 = ((uint64_t)(arg1[7]) * x29);
    x114 = ((uint64_t)(arg1[7]) * (arg1[7]));
    x115 = ((uint64_t)(arg1[6]) * x2);
    x116 = ((uint64_t)(arg1[6]) * (x5 * 0x2));
    x117 = ((uint64_t)(arg1[6]) * x8);
    x118 = ((uint64_t)(arg1[6]) * (x11 * 0x2));
    x119 = ((uint64_t)(arg1[6]) * x14);
    x120 = ((uint64_t)(arg1[6]) * (x17 * 0x2));
    x121 = ((uint64_t)(arg1[6]) * (x21 * 0x2));
    x122 = ((uint64_t)(arg1[6]) * x24);
    x123 = ((uint64_t)(arg1[6]) * (x27 * 0x2));
    x124 = ((uint64_t)(arg1[6]) * x28);
    x125 = ((uint64_t)(arg1[6]) * (x29 * 0x2));
    x126 = ((uint64_t)(arg1[6]) * x30);
    x127 = ((uint64_t)(arg1[6]) * (arg1[6]));
    x128 = ((uint64_t)(arg1[5]) * (x2 * 0x2));
    x129 = ((uint64_t)(arg1[5]) * (x5 * 0x2));
    x130 = ((uint64_t)(arg1[5]) * (x8 * 0x2));
    x131 = ((uint64_t)(arg1[5]) * (x11 * 0x2));
    x132 = ((uint64_t)(arg1[5]) * (x14 * 0x2));
    x133 = ((uint64_t)(arg1[5]) * (x18 * 0x2));
    x134 = ((uint64_t)(arg1[5]) * (x21 * 0x2));
    x135 = ((uint64_t)(arg1[5]) * (x24 * 0x2));
    x136 = ((uint64_t)(arg1[5]) * (x27 * 0x2));
    x137 = ((uint64_t)(arg1[5]) * (x28 * 0x2));
    x138 = ((uint64_t)(arg1[5]) * (x29 * 0x2));
    x139 = ((uint64_t)(arg1[5]) * x30);
    x140 = ((uint64_t)(arg1[5]) * (x31 * 0x2));
    x141 = ((uint64_t)(arg1[5]) * ((arg1[5]) * 0x2));
    x142 = ((uint64_t)(arg1[4]) * x2);
    x143 = ((uint64_t)(arg1[4]) * (x5 * 0x2));
    x144 = ((uint64_t)(arg1[4]) * x8);
    x145 = ((uint64_t)(arg1[4]) * (x11 * 0x2));
    x146 = ((uint64_t)(arg1[4]) * x15);
    x147 = ((uint64_t)(arg1[4]) * x18);
    x148 = ((uint64_t)(arg1[4]) * (x21 * 0x2));
    x149 = ((uint64_t)(arg1[4]) * x24);
    x150 = ((uint64_t)(arg1[4]) * (x27 * 0x2));
    x151 = ((uint64_t)(arg1[4]) * x28);
    x152 = ((uint64_t)(arg1[4]) * x29);
    x153 = ((uint64_t)(arg1[4]) * x30);
    x154 = ((uint64_t)(arg1[4]) * x31);
    x155 = ((uint64_t)(arg1[4]) * (x32 * 0x2));
    x156 = ((uint64_t)(arg1[4]) * (arg1[4]));
    x157 = ((uint64_t)(arg1[3]) * (x2 * 0x2));
    x158 = ((uint64_t)(arg1[3]) * (x5 * 0x2));
    x159 = ((uint64_t)(arg1[3]) * (x8 * 0x2));
    x160 = ((uint64_t)(arg1[3]) * (x12 * 0x2));
    x161 = ((uint64_t)(arg1[3]) * x15);
    x162 = ((uint64_t)(arg1[3]) * (x18 * 0x2));
    x163 = ((uint64_t)(arg1[3]) * (x21 * 0x2));
    x164 = ((uint64_t)(arg1[3]) * (x24 * 0x2));
    x165 = ((uint64_t)(arg1[3]) * (x27 * 0x2));
    x166 = ((uint64_t)(arg1[3]) * x28);
    x167 = ((uint64_t)(arg1[3]) * (x29 * 0x2));
    x168 = ((uint64_t)(arg1[3]) * x30);
    x169 = ((uint64_t)(arg1[3]) * (x31 * 0x2));
    x170 = ((uint64_t)(arg1[3]) * (x32 * 0x2));
    x171 = ((uint64_t)(arg1[3]) * (x33 * 0x2));
    x172 = ((uint64_t)(arg1[3]) * ((arg1[3]) * 0x2));
    x173 = ((uint64_t)(arg1[2]) * x2);
    x174 = ((uint64_t)(arg1[2]) * (x5 * 0x2));
    x175 = ((uint64_t)(arg1[2]) * x9);
    x176 = ((uint64_t)(arg1[2]) * x12);
    x177 = ((uint64_t)(arg1[2]) * x15);
    x178 = ((uint64_t)(arg1[2]) * x18);
    x179 = ((uint64_t)(arg1[2]) * (x21 * 0x2));
    x180 = ((uint64_t)(arg1[2]) * x24);
    x181 = ((uint64_t)(arg1[2]) * x27);
    x182 = ((uint64_t)(arg1[2]) * x28);
    x183 = ((uint64_t)(arg1[2]) * x29);
    x184 = ((uint64_t)(arg1[2]) * x30);
    x185 = ((uint64_t)(arg1[2]) * x31);
    x186 = ((uint64_t)(arg1[2]) * (x32 * 0x2));
    x187 = ((uint64_t)(arg1[2]) * x33);
    x188 = ((uint64_t)(arg1[2]) * x34);
    x189 = ((uint64_t)(arg1[2]) * (arg1[2]));
    x190 = ((uint64_t)(arg1[1]) * (x2 * 0x2));
    x191 = ((uint64_t)(arg1[1]) * (x6 * 0x2));
    x192 = ((uint64_t)(arg1[1]) * x9);
    x193 = ((uint64_t)(arg1[1]) * (x12 * 0x2));
    x194 = ((uint64_t)(arg1[1]) * x15);
    x195 = ((uint64_t)(arg1[1]) * (x18 * 0x2));
    x196 = ((uint64_t)(arg1[1]) * (x21 * 0x2));
    x197 = ((uint64_t)(arg1[1]) * x24);
    x198 = ((uint64_t)(arg1[1]) * (x27 * 0x2));
    x199 = ((uint64_t)(arg1[1]) * x28);
    x200 = ((uint64_t)(arg1[1]) * (x29 * 0x2));
    x201 = ((uint64_t)(arg1[1]) * x30);
    x202 = ((uint64_t)(arg1[1]) * (x31 * 0x2));
    x203 = ((uint64_t)(arg1[1]) * (x32 * 0x2));
    x204 = ((uint64_t)(arg1[1]) * x33);
    x205 = ((uint64_t)(arg1[1]) * (x34 * 0x2));
    x206 = ((uint64_t)(arg1[1]) * x35);
    x207 = ((uint64_t)(arg1[1]) * ((arg1[1]) * 0x2));
    x208 = ((uint64_t)(arg1[0]) * x3);
    x209 = ((uint64_t)(arg1[0]) * x6);
    x210 = ((uint64_t)(arg1[0]) * x9);
    x211 = ((uint64_t)(arg1[0]) * x12);
    x212 = ((uint64_t)(arg1[0]) * x15);
    x213 = ((uint64_t)(arg1[0]) * x18);
    x214 = ((uint64_t)(arg1[0]) * x21);
    x215 = ((uint64_t)(arg1[0]) * x24);
    x216 = ((uint64_t)(arg1[0]) * x27);
    x217 = ((uint64_t)(arg1[0]) * x28);
    x218 = ((uint64_t)(arg1[0]) * x29);
    x219 = ((uint64_t)(arg1[0]) * x30);
    x220 = ((uint64_t)(arg1[0]) * x31);
    x221 = ((uint64_t)(arg1[0]) * x32);
    x222 = ((uint64_t)(arg1[0]) * x33);
    x223 = ((uint64_t)(arg1[0]) * x34);
    x224 = ((uint64_t)(arg1[0]) * x35);
    x225 = ((uint64_t)(arg1[0]) * x36);
    x226 = ((uint64_t)(arg1[0]) * (arg1[0]));
    x227 =
        (x226 +
         (x190 +
          (x174 + (x159 + (x145 + (x132 + (x120 + (x109 + (x99 + x90)))))))));
    x228 = (x227 >> 28);
    x229 = (uint32_t)(x227 & UINT32_C(0xfffffff));
    x230 =
        (x208 +
         (x191 +
          (x175 + (x160 + (x146 + (x133 + (x121 + (x110 + (x100 + x91)))))))));
    x231 =
        (x209 +
         (x192 +
          (x176 + (x161 + (x147 + (x134 + (x122 + (x111 + (x101 + x37)))))))));
    x232 =
        (x210 +
         (x193 +
          (x177 + (x162 + (x148 + (x135 + (x123 + (x112 + (x102 + x38)))))))));
    x233 =
        (x211 +
         (x194 +
          (x178 + (x163 + (x149 + (x136 + (x124 + (x113 + (x40 + x39)))))))));
    x234 =
        (x212 +
         (x195 +
          (x179 + (x164 + (x150 + (x137 + (x125 + (x114 + (x43 + x41)))))))));
    x235 = (x213 +
            (x196 +
             (x180 + (x165 + (x151 + (x138 + (x126 + (x47 + (x44 + x42)))))))));
    x236 = (x214 +
            (x197 +
             (x181 + (x166 + (x152 + (x139 + (x127 + (x52 + (x48 + x45)))))))));
    x237 = (x215 +
            (x198 +
             (x182 + (x167 + (x153 + (x140 + (x58 + (x53 + (x49 + x46)))))))));
    x238 = (x216 +
            (x199 +
             (x183 + (x168 + (x154 + (x141 + (x65 + (x59 + (x54 + x50)))))))));
    x239 = (x217 +
            (x200 +
             (x184 + (x169 + (x155 + (x73 + (x66 + (x60 + (x55 + x51)))))))));
    x240 = (x218 +
            (x201 +
             (x185 + (x170 + (x156 + (x82 + (x74 + (x67 + (x61 + x56)))))))));
    x241 = (x219 +
            (x202 +
             (x186 + (x171 + (x92 + (x83 + (x75 + (x68 + (x62 + x57)))))))));
    x242 = (x220 +
            (x203 +
             (x187 + (x172 + (x103 + (x93 + (x84 + (x76 + (x69 + x63)))))))));
    x243 = (x221 +
            (x204 +
             (x188 + (x115 + (x104 + (x94 + (x85 + (x77 + (x70 + x64)))))))));
    x244 = (x222 +
            (x205 +
             (x189 + (x128 + (x116 + (x105 + (x95 + (x86 + (x78 + x71)))))))));
    x245 = (x223 +
            (x206 +
             (x142 + (x129 + (x117 + (x106 + (x96 + (x87 + (x79 + x72)))))))));
    x246 = (x224 +
            (x207 +
             (x157 + (x143 + (x130 + (x118 + (x107 + (x97 + (x88 + x80)))))))));
    x247 = (x225 +
            (x173 +
             (x158 + (x144 + (x131 + (x119 + (x108 + (x98 + (x89 + x81)))))))));
    x248 = (x228 + x247);
    x249 = (x248 >> 27);
    x250 = (uint32_t)(x248 & UINT32_C(0x7ffffff));
    x251 = (x249 + x246);
    x252 = (x251 >> 28);
    x253 = (uint32_t)(x251 & UINT32_C(0xfffffff));
    x254 = (x252 + x245);
    x255 = (x254 >> 27);
    x256 = (uint32_t)(x254 & UINT32_C(0x7ffffff));
    x257 = (x255 + x244);
    x258 = (x257 >> 28);
    x259 = (uint32_t)(x257 & UINT32_C(0xfffffff));
    x260 = (x258 + x243);
    x261 = (x260 >> 27);
    x262 = (uint32_t)(x260 & UINT32_C(0x7ffffff));
    x263 = (x261 + x242);
    x264 = (x263 >> 27);
    x265 = (uint32_t)(x263 & UINT32_C(0x7ffffff));
    x266 = (x264 + x241);
    x267 = (x266 >> 28);
    x268 = (uint32_t)(x266 & UINT32_C(0xfffffff));
    x269 = (x267 + x240);
    x270 = (x269 >> 27);
    x271 = (uint32_t)(x269 & UINT32_C(0x7ffffff));
    x272 = (x270 + x239);
    x273 = (x272 >> 28);
    x274 = (uint32_t)(x272 & UINT32_C(0xfffffff));
    x275 = (x273 + x238);
    x276 = (x275 >> 27);
    x277 = (uint32_t)(x275 & UINT32_C(0x7ffffff));
    x278 = (x276 + x237);
    x279 = (x278 >> 28);
    x280 = (uint32_t)(x278 & UINT32_C(0xfffffff));
    x281 = (x279 + x236);
    x282 = (x281 >> 27);
    x283 = (uint32_t)(x281 & UINT32_C(0x7ffffff));
    x284 = (x282 + x235);
    x285 = (x284 >> 27);
    x286 = (uint32_t)(x284 & UINT32_C(0x7ffffff));
    x287 = (x285 + x234);
    x288 = (x287 >> 28);
    x289 = (uint32_t)(x287 & UINT32_C(0xfffffff));
    x290 = (x288 + x233);
    x291 = (x290 >> 27);
    x292 = (uint32_t)(x290 & UINT32_C(0x7ffffff));
    x293 = (x291 + x232);
    x294 = (x293 >> 28);
    x295 = (uint32_t)(x293 & UINT32_C(0xfffffff));
    x296 = (x294 + x231);
    x297 = (x296 >> 27);
    x298 = (uint32_t)(x296 & UINT32_C(0x7ffffff));
    x299 = (x297 + x230);
    x300 = (x299 >> 27);
    x301 = (uint32_t)(x299 & UINT32_C(0x7ffffff));
    x302 = (x229 + x300);
    x303 = (uint32_t)(x302 >> 28);
    x304 = (uint32_t)(x302 & UINT32_C(0xfffffff));
    x305 = (x303 + x250);
    x306 = (fiat_secp521r1_uint1)(x305 >> 27);
    x307 = (x305 & UINT32_C(0x7ffffff));
    x308 = (x306 + x253);
    out1[0] = x304;
    out1[1] = x307;
    out1[2] = x308;
    out1[3] = x256;
    out1[4] = x259;
    out1[5] = x262;
    out1[6] = x265;
    out1[7] = x268;
    out1[8] = x271;
    out1[9] = x274;
    out1[10] = x277;
    out1[11] = x280;
    out1[12] = x283;
    out1[13] = x286;
    out1[14] = x289;
    out1[15] = x292;
    out1[16] = x295;
    out1[17] = x298;
    out1[18] = x301;
}

/*
 * The function fiat_secp521r1_carry reduces a field element.
 *
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 */

/*
 * The function fiat_secp521r1_add adds two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 */

/*
 * The function fiat_secp521r1_sub subtracts two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 */

/*
 * The function fiat_secp521r1_opp negates a field element.
 *
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 */

/*
 * The function fiat_secp521r1_carry_add adds two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 */
static void fiat_secp521r1_carry_add(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_tight_field_element arg1,
    const fiat_secp521r1_tight_field_element arg2) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    x1 = ((arg1[0]) + (arg2[0]));
    x2 = ((x1 >> 28) + ((arg1[1]) + (arg2[1])));
    x3 = ((x2 >> 27) + ((arg1[2]) + (arg2[2])));
    x4 = ((x3 >> 28) + ((arg1[3]) + (arg2[3])));
    x5 = ((x4 >> 27) + ((arg1[4]) + (arg2[4])));
    x6 = ((x5 >> 28) + ((arg1[5]) + (arg2[5])));
    x7 = ((x6 >> 27) + ((arg1[6]) + (arg2[6])));
    x8 = ((x7 >> 27) + ((arg1[7]) + (arg2[7])));
    x9 = ((x8 >> 28) + ((arg1[8]) + (arg2[8])));
    x10 = ((x9 >> 27) + ((arg1[9]) + (arg2[9])));
    x11 = ((x10 >> 28) + ((arg1[10]) + (arg2[10])));
    x12 = ((x11 >> 27) + ((arg1[11]) + (arg2[11])));
    x13 = ((x12 >> 28) + ((arg1[12]) + (arg2[12])));
    x14 = ((x13 >> 27) + ((arg1[13]) + (arg2[13])));
    x15 = ((x14 >> 27) + ((arg1[14]) + (arg2[14])));
    x16 = ((x15 >> 28) + ((arg1[15]) + (arg2[15])));
    x17 = ((x16 >> 27) + ((arg1[16]) + (arg2[16])));
    x18 = ((x17 >> 28) + ((arg1[17]) + (arg2[17])));
    x19 = ((x18 >> 27) + ((arg1[18]) + (arg2[18])));
    x20 = ((x1 & UINT32_C(0xfffffff)) + (x19 >> 27));
    x21 = ((fiat_secp521r1_uint1)(x20 >> 28) + (x2 & UINT32_C(0x7ffffff)));
    x22 = (x20 & UINT32_C(0xfffffff));
    x23 = (x21 & UINT32_C(0x7ffffff));
    x24 = ((fiat_secp521r1_uint1)(x21 >> 27) + (x3 & UINT32_C(0xfffffff)));
    x25 = (x4 & UINT32_C(0x7ffffff));
    x26 = (x5 & UINT32_C(0xfffffff));
    x27 = (x6 & UINT32_C(0x7ffffff));
    x28 = (x7 & UINT32_C(0x7ffffff));
    x29 = (x8 & UINT32_C(0xfffffff));
    x30 = (x9 & UINT32_C(0x7ffffff));
    x31 = (x10 & UINT32_C(0xfffffff));
    x32 = (x11 & UINT32_C(0x7ffffff));
    x33 = (x12 & UINT32_C(0xfffffff));
    x34 = (x13 & UINT32_C(0x7ffffff));
    x35 = (x14 & UINT32_C(0x7ffffff));
    x36 = (x15 & UINT32_C(0xfffffff));
    x37 = (x16 & UINT32_C(0x7ffffff));
    x38 = (x17 & UINT32_C(0xfffffff));
    x39 = (x18 & UINT32_C(0x7ffffff));
    x40 = (x19 & UINT32_C(0x7ffffff));
    out1[0] = x22;
    out1[1] = x23;
    out1[2] = x24;
    out1[3] = x25;
    out1[4] = x26;
    out1[5] = x27;
    out1[6] = x28;
    out1[7] = x29;
    out1[8] = x30;
    out1[9] = x31;
    out1[10] = x32;
    out1[11] = x33;
    out1[12] = x34;
    out1[13] = x35;
    out1[14] = x36;
    out1[15] = x37;
    out1[16] = x38;
    out1[17] = x39;
    out1[18] = x40;
}

/*
 * The function fiat_secp521r1_carry_sub subtracts two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 */
static void fiat_secp521r1_carry_sub(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_tight_field_element arg1,
    const fiat_secp521r1_tight_field_element arg2) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    x1 = ((UINT32_C(0x1ffffffe) + (arg1[0])) - (arg2[0]));
    x2 = ((x1 >> 28) + ((UINT32_C(0xffffffe) + (arg1[1])) - (arg2[1])));
    x3 = ((x2 >> 27) + ((UINT32_C(0x1ffffffe) + (arg1[2])) - (arg2[2])));
    x4 = ((x3 >> 28) + ((UINT32_C(0xffffffe) + (arg1[3])) - (arg2[3])));
    x5 = ((x4 >> 27) + ((UINT32_C(0x1ffffffe) + (arg1[4])) - (arg2[4])));
    x6 = ((x5 >> 28) + ((UINT32_C(0xffffffe) + (arg1[5])) - (arg2[5])));
    x7 = ((x6 >> 27) + ((UINT32_C(0xffffffe) + (arg1[6])) - (arg2[6])));
    x8 = ((x7 >> 27) + ((UINT32_C(0x1ffffffe) + (arg1[7])) - (arg2[7])));
    x9 = ((x8 >> 28) + ((UINT32_C(0xffffffe) + (arg1[8])) - (arg2[8])));
    x10 = ((x9 >> 27) + ((UINT32_C(0x1ffffffe) + (arg1[9])) - (arg2[9])));
    x11 = ((x10 >> 28) + ((UINT32_C(0xffffffe) + (arg1[10])) - (arg2[10])));
    x12 = ((x11 >> 27) + ((UINT32_C(0x1ffffffe) + (arg1[11])) - (arg2[11])));
    x13 = ((x12 >> 28) + ((UINT32_C(0xffffffe) + (arg1[12])) - (arg2[12])));
    x14 = ((x13 >> 27) + ((UINT32_C(0xffffffe) + (arg1[13])) - (arg2[13])));
    x15 = ((x14 >> 27) + ((UINT32_C(0x1ffffffe) + (arg1[14])) - (arg2[14])));
    x16 = ((x15 >> 28) + ((UINT32_C(0xffffffe) + (arg1[15])) - (arg2[15])));
    x17 = ((x16 >> 27) + ((UINT32_C(0x1ffffffe) + (arg1[16])) - (arg2[16])));
    x18 = ((x17 >> 28) + ((UINT32_C(0xffffffe) + (arg1[17])) - (arg2[17])));
    x19 = ((x18 >> 27) + ((UINT32_C(0xffffffe) + (arg1[18])) - (arg2[18])));
    x20 = ((x1 & UINT32_C(0xfffffff)) + (x19 >> 27));
    x21 = ((fiat_secp521r1_uint1)(x20 >> 28) + (x2 & UINT32_C(0x7ffffff)));
    x22 = (x20 & UINT32_C(0xfffffff));
    x23 = (x21 & UINT32_C(0x7ffffff));
    x24 = ((fiat_secp521r1_uint1)(x21 >> 27) + (x3 & UINT32_C(0xfffffff)));
    x25 = (x4 & UINT32_C(0x7ffffff));
    x26 = (x5 & UINT32_C(0xfffffff));
    x27 = (x6 & UINT32_C(0x7ffffff));
    x28 = (x7 & UINT32_C(0x7ffffff));
    x29 = (x8 & UINT32_C(0xfffffff));
    x30 = (x9 & UINT32_C(0x7ffffff));
    x31 = (x10 & UINT32_C(0xfffffff));
    x32 = (x11 & UINT32_C(0x7ffffff));
    x33 = (x12 & UINT32_C(0xfffffff));
    x34 = (x13 & UINT32_C(0x7ffffff));
    x35 = (x14 & UINT32_C(0x7ffffff));
    x36 = (x15 & UINT32_C(0xfffffff));
    x37 = (x16 & UINT32_C(0x7ffffff));
    x38 = (x17 & UINT32_C(0xfffffff));
    x39 = (x18 & UINT32_C(0x7ffffff));
    x40 = (x19 & UINT32_C(0x7ffffff));
    out1[0] = x22;
    out1[1] = x23;
    out1[2] = x24;
    out1[3] = x25;
    out1[4] = x26;
    out1[5] = x27;
    out1[6] = x28;
    out1[7] = x29;
    out1[8] = x30;
    out1[9] = x31;
    out1[10] = x32;
    out1[11] = x33;
    out1[12] = x34;
    out1[13] = x35;
    out1[14] = x36;
    out1[15] = x37;
    out1[16] = x38;
    out1[17] = x39;
    out1[18] = x40;
}

/*
 * The function fiat_secp521r1_carry_opp negates a field element.
 *
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 */
static void fiat_secp521r1_carry_opp(
    fiat_secp521r1_tight_field_element out1,
    const fiat_secp521r1_tight_field_element arg1) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    x1 = (UINT32_C(0x1ffffffe) - (arg1[0]));
    x2 = ((fiat_secp521r1_uint1)(x1 >> 28) + (UINT32_C(0xffffffe) - (arg1[1])));
    x3 =
        ((fiat_secp521r1_uint1)(x2 >> 27) + (UINT32_C(0x1ffffffe) - (arg1[2])));
    x4 = ((fiat_secp521r1_uint1)(x3 >> 28) + (UINT32_C(0xffffffe) - (arg1[3])));
    x5 =
        ((fiat_secp521r1_uint1)(x4 >> 27) + (UINT32_C(0x1ffffffe) - (arg1[4])));
    x6 = ((fiat_secp521r1_uint1)(x5 >> 28) + (UINT32_C(0xffffffe) - (arg1[5])));
    x7 = ((fiat_secp521r1_uint1)(x6 >> 27) + (UINT32_C(0xffffffe) - (arg1[6])));
    x8 =
        ((fiat_secp521r1_uint1)(x7 >> 27) + (UINT32_C(0x1ffffffe) - (arg1[7])));
    x9 = ((fiat_secp521r1_uint1)(x8 >> 28) + (UINT32_C(0xffffffe) - (arg1[8])));
    x10 =
        ((fiat_secp521r1_uint1)(x9 >> 27) + (UINT32_C(0x1ffffffe) - (arg1[9])));
    x11 = ((fiat_secp521r1_uint1)(x10 >> 28) +
           (UINT32_C(0xffffffe) - (arg1[10])));
    x12 = ((fiat_secp521r1_uint1)(x11 >> 27) +
           (UINT32_C(0x1ffffffe) - (arg1[11])));
    x13 = ((fiat_secp521r1_uint1)(x12 >> 28) +
           (UINT32_C(0xffffffe) - (arg1[12])));
    x14 = ((fiat_secp521r1_uint1)(x13 >> 27) +
           (UINT32_C(0xffffffe) - (arg1[13])));
    x15 = ((fiat_secp521r1_uint1)(x14 >> 27) +
           (UINT32_C(0x1ffffffe) - (arg1[14])));
    x16 = ((fiat_secp521r1_uint1)(x15 >> 28) +
           (UINT32_C(0xffffffe) - (arg1[15])));
    x17 = ((fiat_secp521r1_uint1)(x16 >> 27) +
           (UINT32_C(0x1ffffffe) - (arg1[16])));
    x18 = ((fiat_secp521r1_uint1)(x17 >> 28) +
           (UINT32_C(0xffffffe) - (arg1[17])));
    x19 = ((fiat_secp521r1_uint1)(x18 >> 27) +
           (UINT32_C(0xffffffe) - (arg1[18])));
    x20 = ((x1 & UINT32_C(0xfffffff)) +
           (uint32_t)(fiat_secp521r1_uint1)(x19 >> 27));
    x21 = ((fiat_secp521r1_uint1)(x20 >> 28) + (x2 & UINT32_C(0x7ffffff)));
    x22 = (x20 & UINT32_C(0xfffffff));
    x23 = (x21 & UINT32_C(0x7ffffff));
    x24 = ((fiat_secp521r1_uint1)(x21 >> 27) + (x3 & UINT32_C(0xfffffff)));
    x25 = (x4 & UINT32_C(0x7ffffff));
    x26 = (x5 & UINT32_C(0xfffffff));
    x27 = (x6 & UINT32_C(0x7ffffff));
    x28 = (x7 & UINT32_C(0x7ffffff));
    x29 = (x8 & UINT32_C(0xfffffff));
    x30 = (x9 & UINT32_C(0x7ffffff));
    x31 = (x10 & UINT32_C(0xfffffff));
    x32 = (x11 & UINT32_C(0x7ffffff));
    x33 = (x12 & UINT32_C(0xfffffff));
    x34 = (x13 & UINT32_C(0x7ffffff));
    x35 = (x14 & UINT32_C(0x7ffffff));
    x36 = (x15 & UINT32_C(0xfffffff));
    x37 = (x16 & UINT32_C(0x7ffffff));
    x38 = (x17 & UINT32_C(0xfffffff));
    x39 = (x18 & UINT32_C(0x7ffffff));
    x40 = (x19 & UINT32_C(0x7ffffff));
    out1[0] = x22;
    out1[1] = x23;
    out1[2] = x24;
    out1[3] = x25;
    out1[4] = x26;
    out1[5] = x27;
    out1[6] = x28;
    out1[7] = x29;
    out1[8] = x30;
    out1[9] = x31;
    out1[10] = x32;
    out1[11] = x33;
    out1[12] = x34;
    out1[13] = x35;
    out1[14] = x36;
    out1[15] = x37;
    out1[16] = x38;
    out1[17] = x39;
    out1[18] = x40;
}

/*
 * The function fiat_secp521r1_relax is the identity function converting from tight field elements to loose field elements.
 *
 * Postconditions:
 *   out1 = arg1
 *
 */

/*
 * The function fiat_secp521r1_selectznz is a multi-limb conditional select.
 *
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp521r1_selectznz(uint32_t out1[19],
                                     fiat_secp521r1_uint1 arg1,
                                     const uint32_t arg2[19],
                                     const uint32_t arg3[19]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    fiat_secp521r1_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
    fiat_secp521r1_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
    fiat_secp521r1_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
    fiat_secp521r1_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
    fiat_secp521r1_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
    fiat_secp521r1_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
    fiat_secp521r1_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
    fiat_secp521r1_cmovznz_u32(&x8, arg1, (arg2[7]), (arg3[7]));
    fiat_secp521r1_cmovznz_u32(&x9, arg1, (arg2[8]), (arg3[8]));
    fiat_secp521r1_cmovznz_u32(&x10, arg1, (arg2[9]), (arg3[9]));
    fiat_secp521r1_cmovznz_u32(&x11, arg1, (arg2[10]), (arg3[10]));
    fiat_secp521r1_cmovznz_u32(&x12, arg1, (arg2[11]), (arg3[11]));
    fiat_secp521r1_cmovznz_u32(&x13, arg1, (arg2[12]), (arg3[12]));
    fiat_secp521r1_cmovznz_u32(&x14, arg1, (arg2[13]), (arg3[13]));
    fiat_secp521r1_cmovznz_u32(&x15, arg1, (arg2[14]), (arg3[14]));
    fiat_secp521r1_cmovznz_u32(&x16, arg1, (arg2[15]), (arg3[15]));
    fiat_secp521r1_cmovznz_u32(&x17, arg1, (arg2[16]), (arg3[16]));
    fiat_secp521r1_cmovznz_u32(&x18, arg1, (arg2[17]), (arg3[17]));
    fiat_secp521r1_cmovznz_u32(&x19, arg1, (arg2[18]), (arg3[18]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1[12] = x13;
    out1[13] = x14;
    out1[14] = x15;
    out1[15] = x16;
    out1[16] = x17;
    out1[17] = x18;
    out1[18] = x19;
}

/*
 * The function fiat_secp521r1_to_bytes serializes a field element to bytes in little-endian order.
 *
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 */
static void fiat_secp521r1_to_bytes(
    uint8_t out1[66], const fiat_secp521r1_tight_field_element arg1) {
    uint32_t x1;
    fiat_secp521r1_uint1 x2;
    uint32_t x3;
    fiat_secp521r1_uint1 x4;
    uint32_t x5;
    fiat_secp521r1_uint1 x6;
    uint32_t x7;
    fiat_secp521r1_uint1 x8;
    uint32_t x9;
    fiat_secp521r1_uint1 x10;
    uint32_t x11;
    fiat_secp521r1_uint1 x12;
    uint32_t x13;
    fiat_secp521r1_uint1 x14;
    uint32_t x15;
    fiat_secp521r1_uint1 x16;
    uint32_t x17;
    fiat_secp521r1_uint1 x18;
    uint32_t x19;
    fiat_secp521r1_uint1 x20;
    uint32_t x21;
    fiat_secp521r1_uint1 x22;
    uint32_t x23;
    fiat_secp521r1_uint1 x24;
    uint32_t x25;
    fiat_secp521r1_uint1 x26;
    uint32_t x27;
    fiat_secp521r1_uint1 x28;
    uint32_t x29;
    fiat_secp521r1_uint1 x30;
    uint32_t x31;
    fiat_secp521r1_uint1 x32;
    uint32_t x33;
    fiat_secp521r1_uint1 x34;
    uint32_t x35;
    fiat_secp521r1_uint1 x36;
    uint32_t x37;
    fiat_secp521r1_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    fiat_secp521r1_uint1 x41;
    uint32_t x42;
    fiat_secp521r1_uint1 x43;
    uint32_t x44;
    fiat_secp521r1_uint1 x45;
    uint32_t x46;
    fiat_secp521r1_uint1 x47;
    uint32_t x48;
    fiat_secp521r1_uint1 x49;
    uint32_t x50;
    fiat_secp521r1_uint1 x51;
    uint32_t x52;
    fiat_secp521r1_uint1 x53;
    uint32_t x54;
    fiat_secp521r1_uint1 x55;
    uint32_t x56;
    fiat_secp521r1_uint1 x57;
    uint32_t x58;
    fiat_secp521r1_uint1 x59;
    uint32_t x60;
    fiat_secp521r1_uint1 x61;
    uint32_t x62;
    fiat_secp521r1_uint1 x63;
    uint32_t x64;
    fiat_secp521r1_uint1 x65;
    uint32_t x66;
    fiat_secp521r1_uint1 x67;
    uint32_t x68;
    fiat_secp521r1_uint1 x69;
    uint32_t x70;
    fiat_secp521r1_uint1 x71;
    uint32_t x72;
    fiat_secp521r1_uint1 x73;
    uint32_t x74;
    fiat_secp521r1_uint1 x75;
    uint32_t x76;
    fiat_secp521r1_uint1 x77;
    uint64_t x78;
    uint32_t x79;
    uint64_t x80;
    uint32_t x81;
    uint32_t x82;
    uint32_t x83;
    uint64_t x84;
    uint32_t x85;
    uint64_t x86;
    uint32_t x87;
    uint32_t x88;
    uint32_t x89;
    uint64_t x90;
    uint32_t x91;
    uint64_t x92;
    uint32_t x93;
    uint8_t x94;
    uint32_t x95;
    uint8_t x96;
    uint32_t x97;
    uint8_t x98;
    uint8_t x99;
    uint32_t x100;
    uint8_t x101;
    uint32_t x102;
    uint8_t x103;
    uint32_t x104;
    uint8_t x105;
    uint8_t x106;
    uint64_t x107;
    uint8_t x108;
    uint32_t x109;
    uint8_t x110;
    uint32_t x111;
    uint8_t x112;
    uint32_t x113;
    uint8_t x114;
    uint8_t x115;
    uint32_t x116;
    uint8_t x117;
    uint32_t x118;
    uint8_t x119;
    uint32_t x120;
    uint8_t x121;
    uint8_t x122;
    uint64_t x123;
    uint8_t x124;
    uint32_t x125;
    uint8_t x126;
    uint32_t x127;
    uint8_t x128;
    uint32_t x129;
    uint8_t x130;
    uint8_t x131;
    uint32_t x132;
    uint8_t x133;
    uint32_t x134;
    uint8_t x135;
    uint32_t x136;
    uint8_t x137;
    uint8_t x138;
    uint32_t x139;
    uint8_t x140;
    uint32_t x141;
    uint8_t x142;
    uint32_t x143;
    uint8_t x144;
    uint8_t x145;
    uint8_t x146;
    uint32_t x147;
    uint8_t x148;
    uint32_t x149;
    uint8_t x150;
    uint8_t x151;
    uint32_t x152;
    uint8_t x153;
    uint32_t x154;
    uint8_t x155;
    uint32_t x156;
    uint8_t x157;
    uint8_t x158;
    uint64_t x159;
    uint8_t x160;
    uint32_t x161;
    uint8_t x162;
    uint32_t x163;
    uint8_t x164;
    uint32_t x165;
    uint8_t x166;
    uint8_t x167;
    uint32_t x168;
    uint8_t x169;
    uint32_t x170;
    uint8_t x171;
    uint32_t x172;
    uint8_t x173;
    uint8_t x174;
    uint64_t x175;
    uint8_t x176;
    uint32_t x177;
    uint8_t x178;
    uint32_t x179;
    uint8_t x180;
    uint32_t x181;
    uint8_t x182;
    uint8_t x183;
    uint32_t x184;
    uint8_t x185;
    uint32_t x186;
    uint8_t x187;
    uint32_t x188;
    uint8_t x189;
    uint8_t x190;
    uint32_t x191;
    uint8_t x192;
    uint32_t x193;
    uint8_t x194;
    uint32_t x195;
    uint8_t x196;
    uint8_t x197;
    uint8_t x198;
    uint32_t x199;
    uint8_t x200;
    uint32_t x201;
    uint8_t x202;
    uint8_t x203;
    uint32_t x204;
    uint8_t x205;
    uint32_t x206;
    uint8_t x207;
    uint32_t x208;
    uint8_t x209;
    uint8_t x210;
    uint64_t x211;
    uint8_t x212;
    uint32_t x213;
    uint8_t x214;
    uint32_t x215;
    uint8_t x216;
    uint32_t x217;
    uint8_t x218;
    uint8_t x219;
    uint32_t x220;
    uint8_t x221;
    uint32_t x222;
    uint8_t x223;
    uint32_t x224;
    uint8_t x225;
    uint8_t x226;
    uint64_t x227;
    uint8_t x228;
    uint32_t x229;
    uint8_t x230;
    uint32_t x231;
    uint8_t x232;
    uint32_t x233;
    uint8_t x234;
    fiat_secp521r1_uint1 x235;
    fiat_secp521r1_subborrowx_u28(&x1, &x2, 0x0, (arg1[0]),
                                  UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x3, &x4, x2, (arg1[1]), UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u28(&x5, &x6, x4, (arg1[2]), UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x7, &x8, x6, (arg1[3]), UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u28(&x9, &x10, x8, (arg1[4]),
                                  UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x11, &x12, x10, (arg1[5]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u27(&x13, &x14, x12, (arg1[6]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u28(&x15, &x16, x14, (arg1[7]),
                                  UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x17, &x18, x16, (arg1[8]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u28(&x19, &x20, x18, (arg1[9]),
                                  UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x21, &x22, x20, (arg1[10]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u28(&x23, &x24, x22, (arg1[11]),
                                  UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x25, &x26, x24, (arg1[12]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u27(&x27, &x28, x26, (arg1[13]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u28(&x29, &x30, x28, (arg1[14]),
                                  UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x31, &x32, x30, (arg1[15]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u28(&x33, &x34, x32, (arg1[16]),
                                  UINT32_C(0xfffffff));
    fiat_secp521r1_subborrowx_u27(&x35, &x36, x34, (arg1[17]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_subborrowx_u27(&x37, &x38, x36, (arg1[18]),
                                  UINT32_C(0x7ffffff));
    fiat_secp521r1_cmovznz_u32(&x39, x38, 0x0, UINT32_C(0xffffffff));
    fiat_secp521r1_addcarryx_u28(&x40, &x41, 0x0, x1,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x42, &x43, x41, x3,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u28(&x44, &x45, x43, x5,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x46, &x47, x45, x7,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u28(&x48, &x49, x47, x9,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x50, &x51, x49, x11,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u27(&x52, &x53, x51, x13,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u28(&x54, &x55, x53, x15,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x56, &x57, x55, x17,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u28(&x58, &x59, x57, x19,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x60, &x61, x59, x21,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u28(&x62, &x63, x61, x23,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x64, &x65, x63, x25,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u27(&x66, &x67, x65, x27,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u28(&x68, &x69, x67, x29,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x70, &x71, x69, x31,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u28(&x72, &x73, x71, x33,
                                 (x39 & UINT32_C(0xfffffff)));
    fiat_secp521r1_addcarryx_u27(&x74, &x75, x73, x35,
                                 (x39 & UINT32_C(0x7ffffff)));
    fiat_secp521r1_addcarryx_u27(&x76, &x77, x75, x37,
                                 (x39 & UINT32_C(0x7ffffff)));
    x78 = ((uint64_t)x76 << 6);
    x79 = (x74 << 3);
    x80 = ((uint64_t)x72 << 7);
    x81 = (x70 << 4);
    x82 = (x66 << 5);
    x83 = (x64 << 2);
    x84 = ((uint64_t)x62 << 6);
    x85 = (x60 << 3);
    x86 = ((uint64_t)x58 << 7);
    x87 = (x56 << 4);
    x88 = (x52 << 5);
    x89 = (x50 << 2);
    x90 = ((uint64_t)x48 << 6);
    x91 = (x46 << 3);
    x92 = ((uint64_t)x44 << 7);
    x93 = (x42 << 4);
    x94 = (uint8_t)(x40 & UINT8_C(0xff));
    x95 = (x40 >> 8);
    x96 = (uint8_t)(x95 & UINT8_C(0xff));
    x97 = (x95 >> 8);
    x98 = (uint8_t)(x97 & UINT8_C(0xff));
    x99 = (uint8_t)(x97 >> 8);
    x100 = (x93 + (uint32_t)x99);
    x101 = (uint8_t)(x100 & UINT8_C(0xff));
    x102 = (x100 >> 8);
    x103 = (uint8_t)(x102 & UINT8_C(0xff));
    x104 = (x102 >> 8);
    x105 = (uint8_t)(x104 & UINT8_C(0xff));
    x106 = (uint8_t)(x104 >> 8);
    x107 = (x92 + (uint64_t)x106);
    x108 = (uint8_t)(x107 & UINT8_C(0xff));
    x109 = (uint32_t)(x107 >> 8);
    x110 = (uint8_t)(x109 & UINT8_C(0xff));
    x111 = (x109 >> 8);
    x112 = (uint8_t)(x111 & UINT8_C(0xff));
    x113 = (x111 >> 8);
    x114 = (uint8_t)(x113 & UINT8_C(0xff));
    x115 = (uint8_t)(x113 >> 8);
    x116 = (x91 + (uint32_t)x115);
    x117 = (uint8_t)(x116 & UINT8_C(0xff));
    x118 = (x116 >> 8);
    x119 = (uint8_t)(x118 & UINT8_C(0xff));
    x120 = (x118 >> 8);
    x121 = (uint8_t)(x120 & UINT8_C(0xff));
    x122 = (uint8_t)(x120 >> 8);
    x123 = (x90 + (uint64_t)x122);
    x124 = (uint8_t)(x123 & UINT8_C(0xff));
    x125 = (uint32_t)(x123 >> 8);
    x126 = (uint8_t)(x125 & UINT8_C(0xff));
    x127 = (x125 >> 8);
    x128 = (uint8_t)(x127 & UINT8_C(0xff));
    x129 = (x127 >> 8);
    x130 = (uint8_t)(x129 & UINT8_C(0xff));
    x131 = (uint8_t)(x129 >> 8);
    x132 = (x89 + (uint32_t)x131);
    x133 = (uint8_t)(x132 & UINT8_C(0xff));
    x134 = (x132 >> 8);
    x135 = (uint8_t)(x134 & UINT8_C(0xff));
    x136 = (x134 >> 8);
    x137 = (uint8_t)(x136 & UINT8_C(0xff));
    x138 = (uint8_t)(x136 >> 8);
    x139 = (x88 + (uint32_t)x138);
    x140 = (uint8_t)(x139 & UINT8_C(0xff));
    x141 = (x139 >> 8);
    x142 = (uint8_t)(x141 & UINT8_C(0xff));
    x143 = (x141 >> 8);
    x144 = (uint8_t)(x143 & UINT8_C(0xff));
    x145 = (uint8_t)(x143 >> 8);
    x146 = (uint8_t)(x54 & UINT8_C(0xff));
    x147 = (x54 >> 8);
    x148 = (uint8_t)(x147 & UINT8_C(0xff));
    x149 = (x147 >> 8);
    x150 = (uint8_t)(x149 & UINT8_C(0xff));
    x151 = (uint8_t)(x149 >> 8);
    x152 = (x87 + (uint32_t)x151);
    x153 = (uint8_t)(x152 & UINT8_C(0xff));
    x154 = (x152 >> 8);
    x155 = (uint8_t)(x154 & UINT8_C(0xff));
    x156 = (x154 >> 8);
    x157 = (uint8_t)(x156 & UINT8_C(0xff));
    x158 = (uint8_t)(x156 >> 8);
    x159 = (x86 + (uint64_t)x158);
    x160 = (uint8_t)(x159 & UINT8_C(0xff));
    x161 = (uint32_t)(x159 >> 8);
    x162 = (uint8_t)(x161 & UINT8_C(0xff));
    x163 = (x161 >> 8);
    x164 = (uint8_t)(x163 & UINT8_C(0xff));
    x165 = (x163 >> 8);
    x166 = (uint8_t)(x165 & UINT8_C(0xff));
    x167 = (uint8_t)(x165 >> 8);
    x168 = (x85 + (uint32_t)x167);
    x169 = (uint8_t)(x168 & UINT8_C(0xff));
    x170 = (x168 >> 8);
    x171 = (uint8_t)(x170 & UINT8_C(0xff));
    x172 = (x170 >> 8);
    x173 = (uint8_t)(x172 & UINT8_C(0xff));
    x174 = (uint8_t)(x172 >> 8);
    x175 = (x84 + (uint64_t)x174);
    x176 = (uint8_t)(x175 & UINT8_C(0xff));
    x177 = (uint32_t)(x175 >> 8);
    x178 = (uint8_t)(x177 & UINT8_C(0xff));
    x179 = (x177 >> 8);
    x180 = (uint8_t)(x179 & UINT8_C(0xff));
    x181 = (x179 >> 8);
    x182 = (uint8_t)(x181 & UINT8_C(0xff));
    x183 = (uint8_t)(x181 >> 8);
    x184 = (x83 + (uint32_t)x183);
    x185 = (uint8_t)(x184 & UINT8_C(0xff));
    x186 = (x184 >> 8);
    x187 = (uint8_t)(x186 & UINT8_C(0xff));
    x188 = (x186 >> 8);
    x189 = (uint8_t)(x188 & UINT8_C(0xff));
    x190 = (uint8_t)(x188 >> 8);
    x191 = (x82 + (uint32_t)x190);
    x192 = (uint8_t)(x191 & UINT8_C(0xff));
    x193 = (x191 >> 8);
    x194 = (uint8_t)(x193 & UINT8_C(0xff));
    x195 = (x193 >> 8);
    x196 = (uint8_t)(x195 & UINT8_C(0xff));
    x197 = (uint8_t)(x195 >> 8);
    x198 = (uint8_t)(x68 & UINT8_C(0xff));
    x199 = (x68 >> 8);
    x200 = (uint8_t)(x199 & UINT8_C(0xff));
    x201 = (x199 >> 8);
    x202 = (uint8_t)(x201 & UINT8_C(0xff));
    x203 = (uint8_t)(x201 >> 8);
    x204 = (x81 + (uint32_t)x203);
    x205 = (uint8_t)(x204 & UINT8_C(0xff));
    x206 = (x204 >> 8);
    x207 = (uint8_t)(x206 & UINT8_C(0xff));
    x208 = (x206 >> 8);
    x209 = (uint8_t)(x208 & UINT8_C(0xff));
    x210 = (uint8_t)(x208 >> 8);
    x211 = (x80 + (uint64_t)x210);
    x212 = (uint8_t)(x211 & UINT8_C(0xff));
    x213 = (uint32_t)(x211 >> 8);
    x214 = (uint8_t)(x213 & UINT8_C(0xff));
    x215 = (x213 >> 8);
    x216 = (uint8_t)(x215 & UINT8_C(0xff));
    x217 = (x215 >> 8);
    x218 = (uint8_t)(x217 & UINT8_C(0xff));
    x219 = (uint8_t)(x217 >> 8);
    x220 = (x79 + (uint32_t)x219);
    x221 = (uint8_t)(x220 & UINT8_C(0xff));
    x222 = (x220 >> 8);
    x223 = (uint8_t)(x222 & UINT8_C(0xff));
    x224 = (x222 >> 8);
    x225 = (uint8_t)(x224 & UINT8_C(0xff));
    x226 = (uint8_t)(x224 >> 8);
    x227 = (x78 + (uint64_t)x226);
    x228 = (uint8_t)(x227 & UINT8_C(0xff));
    x229 = (uint32_t)(x227 >> 8);
    x230 = (uint8_t)(x229 & UINT8_C(0xff));
    x231 = (x229 >> 8);
    x232 = (uint8_t)(x231 & UINT8_C(0xff));
    x233 = (x231 >> 8);
    x234 = (uint8_t)(x233 & UINT8_C(0xff));
    x235 = (fiat_secp521r1_uint1)(x233 >> 8);
    out1[0] = x94;
    out1[1] = x96;
    out1[2] = x98;
    out1[3] = x101;
    out1[4] = x103;
    out1[5] = x105;
    out1[6] = x108;
    out1[7] = x110;
    out1[8] = x112;
    out1[9] = x114;
    out1[10] = x117;
    out1[11] = x119;
    out1[12] = x121;
    out1[13] = x124;
    out1[14] = x126;
    out1[15] = x128;
    out1[16] = x130;
    out1[17] = x133;
    out1[18] = x135;
    out1[19] = x137;
    out1[20] = x140;
    out1[21] = x142;
    out1[22] = x144;
    out1[23] = x145;
    out1[24] = x146;
    out1[25] = x148;
    out1[26] = x150;
    out1[27] = x153;
    out1[28] = x155;
    out1[29] = x157;
    out1[30] = x160;
    out1[31] = x162;
    out1[32] = x164;
    out1[33] = x166;
    out1[34] = x169;
    out1[35] = x171;
    out1[36] = x173;
    out1[37] = x176;
    out1[38] = x178;
    out1[39] = x180;
    out1[40] = x182;
    out1[41] = x185;
    out1[42] = x187;
    out1[43] = x189;
    out1[44] = x192;
    out1[45] = x194;
    out1[46] = x196;
    out1[47] = x197;
    out1[48] = x198;
    out1[49] = x200;
    out1[50] = x202;
    out1[51] = x205;
    out1[52] = x207;
    out1[53] = x209;
    out1[54] = x212;
    out1[55] = x214;
    out1[56] = x216;
    out1[57] = x218;
    out1[58] = x221;
    out1[59] = x223;
    out1[60] = x225;
    out1[61] = x228;
    out1[62] = x230;
    out1[63] = x232;
    out1[64] = x234;
    out1[65] = x235;
}

/*
 * The function fiat_secp521r1_from_bytes deserializes a field element from bytes in little-endian order.
 *
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 */
static void fiat_secp521r1_from_bytes(fiat_secp521r1_tight_field_element out1,
                                      const uint8_t arg1[66]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint64_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint8_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint64_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint64_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint8_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint64_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint64_t x56;
    uint32_t x57;
    uint32_t x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    uint32_t x64;
    uint32_t x65;
    uint8_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint8_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    fiat_secp521r1_uint1 x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint64_t x80;
    uint32_t x81;
    uint8_t x82;
    uint32_t x83;
    uint32_t x84;
    uint32_t x85;
    uint32_t x86;
    uint8_t x87;
    uint32_t x88;
    uint32_t x89;
    uint32_t x90;
    uint64_t x91;
    uint32_t x92;
    uint8_t x93;
    uint32_t x94;
    uint32_t x95;
    uint32_t x96;
    uint32_t x97;
    uint8_t x98;
    uint32_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    uint32_t x104;
    uint32_t x105;
    uint8_t x106;
    uint32_t x107;
    uint32_t x108;
    uint32_t x109;
    uint32_t x110;
    fiat_secp521r1_uint1 x111;
    uint32_t x112;
    uint32_t x113;
    uint32_t x114;
    uint64_t x115;
    uint32_t x116;
    uint8_t x117;
    uint32_t x118;
    uint32_t x119;
    uint32_t x120;
    uint32_t x121;
    uint8_t x122;
    uint32_t x123;
    uint32_t x124;
    uint32_t x125;
    uint64_t x126;
    uint32_t x127;
    uint8_t x128;
    uint32_t x129;
    uint32_t x130;
    uint32_t x131;
    uint32_t x132;
    uint8_t x133;
    uint32_t x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint8_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    fiat_secp521r1_uint1 x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint64_t x150;
    uint32_t x151;
    uint8_t x152;
    uint32_t x153;
    uint32_t x154;
    uint32_t x155;
    uint32_t x156;
    uint8_t x157;
    uint32_t x158;
    uint32_t x159;
    uint32_t x160;
    uint32_t x161;
    x1 = ((uint32_t)(fiat_secp521r1_uint1)(arg1[65]) << 26);
    x2 = ((uint32_t)(arg1[64]) << 18);
    x3 = ((uint32_t)(arg1[63]) << 10);
    x4 = ((uint32_t)(arg1[62]) << 2);
    x5 = ((uint32_t)(arg1[61]) << 21);
    x6 = ((uint32_t)(arg1[60]) << 13);
    x7 = ((uint32_t)(arg1[59]) << 5);
    x8 = ((uint64_t)(arg1[58]) << 25);
    x9 = ((uint32_t)(arg1[57]) << 17);
    x10 = ((uint32_t)(arg1[56]) << 9);
    x11 = ((uint32_t)(arg1[55]) * 0x2);
    x12 = ((uint32_t)(arg1[54]) << 20);
    x13 = ((uint32_t)(arg1[53]) << 12);
    x14 = ((uint32_t)(arg1[52]) << 4);
    x15 = ((uint32_t)(arg1[51]) << 24);
    x16 = ((uint32_t)(arg1[50]) << 16);
    x17 = ((uint32_t)(arg1[49]) << 8);
    x18 = (arg1[48]);
    x19 = ((uint32_t)(arg1[47]) << 19);
    x20 = ((uint32_t)(arg1[46]) << 11);
    x21 = ((uint32_t)(arg1[45]) << 3);
    x22 = ((uint32_t)(arg1[44]) << 22);
    x23 = ((uint32_t)(arg1[43]) << 14);
    x24 = ((uint32_t)(arg1[42]) << 6);
    x25 = ((uint64_t)(arg1[41]) << 26);
    x26 = ((uint32_t)(arg1[40]) << 18);
    x27 = ((uint32_t)(arg1[39]) << 10);
    x28 = ((uint32_t)(arg1[38]) << 2);
    x29 = ((uint32_t)(arg1[37]) << 21);
    x30 = ((uint32_t)(arg1[36]) << 13);
    x31 = ((uint32_t)(arg1[35]) << 5);
    x32 = ((uint64_t)(arg1[34]) << 25);
    x33 = ((uint32_t)(arg1[33]) << 17);
    x34 = ((uint32_t)(arg1[32]) << 9);
    x35 = ((uint32_t)(arg1[31]) * 0x2);
    x36 = ((uint32_t)(arg1[30]) << 20);
    x37 = ((uint32_t)(arg1[29]) << 12);
    x38 = ((uint32_t)(arg1[28]) << 4);
    x39 = ((uint32_t)(arg1[27]) << 24);
    x40 = ((uint32_t)(arg1[26]) << 16);
    x41 = ((uint32_t)(arg1[25]) << 8);
    x42 = (arg1[24]);
    x43 = ((uint32_t)(arg1[23]) << 19);
    x44 = ((uint32_t)(arg1[22]) << 11);
    x45 = ((uint32_t)(arg1[21]) << 3);
    x46 = ((uint32_t)(arg1[20]) << 22);
    x47 = ((uint32_t)(arg1[19]) << 14);
    x48 = ((uint32_t)(arg1[18]) << 6);
    x49 = ((uint64_t)(arg1[17]) << 26);
    x50 = ((uint32_t)(arg1[16]) << 18);
    x51 = ((uint32_t)(arg1[15]) << 10);
    x52 = ((uint32_t)(arg1[14]) << 2);
    x53 = ((uint32_t)(arg1[13]) << 21);
    x54 = ((uint32_t)(arg1[12]) << 13);
    x55 = ((uint32_t)(arg1[11]) << 5);
    x56 = ((uint64_t)(arg1[10]) << 25);
    x57 = ((uint32_t)(arg1[9]) << 17);
    x58 = ((uint32_t)(arg1[8]) << 9);
    x59 = ((uint32_t)(arg1[7]) * 0x2);
    x60 = ((uint32_t)(arg1[6]) << 20);
    x61 = ((uint32_t)(arg1[5]) << 12);
    x62 = ((uint32_t)(arg1[4]) << 4);
    x63 = ((uint32_t)(arg1[3]) << 24);
    x64 = ((uint32_t)(arg1[2]) << 16);
    x65 = ((uint32_t)(arg1[1]) << 8);
    x66 = (arg1[0]);
    x67 = (x65 + (uint32_t)x66);
    x68 = (x64 + x67);
    x69 = (x63 + x68);
    x70 = (x69 & UINT32_C(0xfffffff));
    x71 = (uint8_t)(x69 >> 28);
    x72 = (x62 + (uint32_t)x71);
    x73 = (x61 + x72);
    x74 = (x60 + x73);
    x75 = (x74 & UINT32_C(0x7ffffff));
    x76 = (fiat_secp521r1_uint1)(x74 >> 27);
    x77 = (x59 + (uint32_t)x76);
    x78 = (x58 + x77);
    x79 = (x57 + x78);
    x80 = (x56 + x79);
    x81 = (uint32_t)(x80 & UINT32_C(0xfffffff));
    x82 = (uint8_t)(x80 >> 28);
    x83 = (x55 + (uint32_t)x82);
    x84 = (x54 + x83);
    x85 = (x53 + x84);
    x86 = (x85 & UINT32_C(0x7ffffff));
    x87 = (uint8_t)(x85 >> 27);
    x88 = (x52 + (uint32_t)x87);
    x89 = (x51 + x88);
    x90 = (x50 + x89);
    x91 = (x49 + x90);
    x92 = (uint32_t)(x91 & UINT32_C(0xfffffff));
    x93 = (uint8_t)(x91 >> 28);
    x94 = (x48 + (uint32_t)x93);
    x95 = (x47 + x94);
    x96 = (x46 + x95);
    x97 = (x96 & UINT32_C(0x7ffffff));
    x98 = (uint8_t)(x96 >> 27);
    x99 = (x45 + (uint32_t)x98);
    x100 = (x44 + x99);
    x101 = (x43 + x100);
    x102 = (x41 + (uint32_t)x42);
    x103 = (x40 + x102);
    x104 = (x39 + x103);
    x105 = (x104 & UINT32_C(0xfffffff));
    x106 = (uint8_t)(x104 >> 28);
    x107 = (x38 + (uint32_t)x106);
    x108 = (x37 + x107);
    x109 = (x36 + x108);
    x110 = (x109 & UINT32_C(0x7ffffff));
    x111 = (fiat_secp521r1_uint1)(x109 >> 27);
    x112 = (x35 + (uint32_t)x111);
    x113 = (x34 + x112);
    x114 = (x33 + x113);
    x115 = (x32 + x114);
    x116 = (uint32_t)(x115 & UINT32_C(0xfffffff));
    x117 = (uint8_t)(x115 >> 28);
    x118 = (x31 + (uint32_t)x117);
    x119 = (x30 + x118);
    x120 = (x29 + x119);
    x121 = (x120 & UINT32_C(0x7ffffff));
    x122 = (uint8_t)(x120 >> 27);
    x123 = (x28 + (uint32_t)x122);
    x124 = (x27 + x123);
    x125 = (x26 + x124);
    x126 = (x25 + x125);
    x127 = (uint32_t)(x126 & UINT32_C(0xfffffff));
    x128 = (uint8_t)(x126 >> 28);
    x129 = (x24 + (uint32_t)x128);
    x130 = (x23 + x129);
    x131 = (x22 + x130);
    x132 = (x131 & UINT32_C(0x7ffffff));
    x133 = (uint8_t)(x131 >> 27);
    x134 = (x21 + (uint32_t)x133);
    x135 = (x20 + x134);
    x136 = (x19 + x135);
    x137 = (x17 + (uint32_t)x18);
    x138 = (x16 + x137);
    x139 = (x15 + x138);
    x140 = (x139 & UINT32_C(0xfffffff));
    x141 = (uint8_t)(x139 >> 28);
    x142 = (x14 + (uint32_t)x141);
    x143 = (x13 + x142);
    x144 = (x12 + x143);
    x145 = (x144 & UINT32_C(0x7ffffff));
    x146 = (fiat_secp521r1_uint1)(x144 >> 27);
    x147 = (x11 + (uint32_t)x146);
    x148 = (x10 + x147);
    x149 = (x9 + x148);
    x150 = (x8 + x149);
    x151 = (uint32_t)(x150 & UINT32_C(0xfffffff));
    x152 = (uint8_t)(x150 >> 28);
    x153 = (x7 + (uint32_t)x152);
    x154 = (x6 + x153);
    x155 = (x5 + x154);
    x156 = (x155 & UINT32_C(0x7ffffff));
    x157 = (uint8_t)(x155 >> 27);
    x158 = (x4 + (uint32_t)x157);
    x159 = (x3 + x158);
    x160 = (x2 + x159);
    x161 = (x1 + x160);
    out1[0] = x70;
    out1[1] = x75;
    out1[2] = x81;
    out1[3] = x86;
    out1[4] = x92;
    out1[5] = x97;
    out1[6] = x101;
    out1[7] = x105;
    out1[8] = x110;
    out1[9] = x116;
    out1[10] = x121;
    out1[11] = x127;
    out1[12] = x132;
    out1[13] = x136;
    out1[14] = x140;
    out1[15] = x145;
    out1[16] = x151;
    out1[17] = x156;
    out1[18] = x161;
}
