######################################################################
#
# File: b2sdk/_v3/exception.py
#
# Copyright 2021 Backblaze Inc. All Rights Reserved.
#
# License https://www.backblaze.com/using_b2_code.html
#
######################################################################
from __future__ import annotations

from b2sdk._internal.account_info.exception import AccountInfoError
from b2sdk._internal.account_info.exception import CorruptAccountInfo
from b2sdk._internal.account_info.exception import MissingAccountData
from b2sdk._internal.exception import (
    AccessDenied,
    AlreadyFailed,
    B2ConnectionError,
    B2Error,
    B2HttpCallbackException,
    B2HttpCallbackPostRequestException,
    B2HttpCallbackPreRequestException,
    B2RequestTimeout,
    B2RequestTimeoutDuringUpload,
    B2SimpleError,
    BadDateFormat,
    BadFileInfo,
    BadJson,
    BadRequest,
    BadUploadUrl,
    BrokenPipe,
    BucketIdNotFound,
    BucketNotAllowed,
    CapabilityNotAllowed,
    CapExceeded,
    ChecksumMismatch,
    ClockSkew,
    Conflict,
    ConnectionReset,
    CopyArgumentsMismatch,
    DestFileNewer,
    DestinationDirectoryDoesntAllowOperation,
    DestinationDirectoryDoesntExist,
    DestinationIsADirectory,
    DestinationParentIsNotADirectory,
    DisablingFileLockNotSupported,
    DuplicateBucketName,
    EmailNotVerified,
    FileAlreadyHidden,
    FileNameNotAllowed,
    FileNotPresent,
    FileSha1Mismatch,
    InvalidAuthToken,
    InvalidJsonResponse,
    InvalidMetadataDirective,
    InvalidRange,
    InvalidUploadSource,
    MaxFileSizeExceeded,
    MaxRetriesExceeded,
    MissingPart,
    NonExistentBucket,
    NoPaymentHistory,
    NotAllowedByAppKeyError,
    PartSha1Mismatch,
    PotentialS3EndpointPassedAsRealm,
    RestrictedBucket,
    RestrictedBucketMissing,
    RetentionWriteError,
    ServiceError,
    SourceReplicationConflict,
    SSECKeyError,
    SSECKeyIdMismatchInCopy,
    StorageCapExceeded,
    TooManyRequests,
    TransactionCapExceeded,
    TransientErrorMixin,
    TruncatedOutput,
    Unauthorized,
    UnexpectedCloudBehaviour,
    UnknownError,
    UnknownHost,
    UnrecognizedBucketType,
    UnsatisfiableRange,
    UnusableFileName,
    WrongEncryptionModeForBucketDefault,
    interpret_b2_error,
)
from b2sdk._internal.scan.exception import EmptyDirectory
from b2sdk._internal.scan.exception import EnvironmentEncodingError
from b2sdk._internal.scan.exception import InvalidArgument
from b2sdk._internal.scan.exception import NotADirectory
from b2sdk._internal.scan.exception import UnableToCreateDirectory
from b2sdk._internal.scan.exception import UnsupportedFilename
from b2sdk._internal.scan.exception import check_invalid_argument
from b2sdk._internal.sync.exception import IncompleteSync

__all__ = (
    'AccessDenied',
    'AccountInfoError',
    'AlreadyFailed',
    'B2ConnectionError',
    'B2Error',
    'B2HttpCallbackException',
    'B2HttpCallbackPostRequestException',
    'B2HttpCallbackPreRequestException',
    'B2RequestTimeout',
    'B2RequestTimeoutDuringUpload',
    'B2SimpleError',
    'BadDateFormat',
    'BadFileInfo',
    'BadJson',
    'BadRequest',
    'BadUploadUrl',
    'BrokenPipe',
    'BucketIdNotFound',
    'BucketNotAllowed',
    'CapabilityNotAllowed',
    'CapExceeded',
    'ChecksumMismatch',
    'ClockSkew',
    'Conflict',
    'ConnectionReset',
    'CopyArgumentsMismatch',
    'CorruptAccountInfo',
    'DestFileNewer',
    'DestinationDirectoryDoesntAllowOperation',
    'DestinationDirectoryDoesntExist',
    'DestinationIsADirectory',
    'DestinationParentIsNotADirectory',
    'DisablingFileLockNotSupported',
    'DuplicateBucketName',
    'EmailNotVerified',
    'EmptyDirectory',
    'EnvironmentEncodingError',
    'FileAlreadyHidden',
    'FileNameNotAllowed',
    'FileNotPresent',
    'FileSha1Mismatch',
    'IncompleteSync',
    'InvalidArgument',
    'InvalidAuthToken',
    'InvalidJsonResponse',
    'InvalidMetadataDirective',
    'InvalidRange',
    'InvalidUploadSource',
    'MaxFileSizeExceeded',
    'MaxRetriesExceeded',
    'MissingAccountData',
    'MissingPart',
    'NonExistentBucket',
    'NoPaymentHistory',
    'NotADirectory',
    'NotAllowedByAppKeyError',
    'PartSha1Mismatch',
    'PotentialS3EndpointPassedAsRealm',
    'RestrictedBucket',
    'RestrictedBucketMissing',
    'RetentionWriteError',
    'ServiceError',
    'SourceReplicationConflict',
    'StorageCapExceeded',
    'TooManyRequests',
    'TransactionCapExceeded',
    'TransientErrorMixin',
    'TruncatedOutput',
    'UnableToCreateDirectory',
    'Unauthorized',
    'UnexpectedCloudBehaviour',
    'UnknownError',
    'UnknownHost',
    'UnrecognizedBucketType',
    'UnsatisfiableRange',
    'UnsupportedFilename',
    'UnusableFileName',
    'interpret_b2_error',
    'check_invalid_argument',
    'SSECKeyIdMismatchInCopy',
    'SSECKeyError',
    'WrongEncryptionModeForBucketDefault',
)
