/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawLines;
import de.escape.quincunx.dxf.DrawLinesWithWidth;
import de.escape.quincunx.dxf.DrawSet;
import de.escape.quincunx.dxf.DrawableConverter;
import de.escape.quincunx.dxf.DxfViewer;
import de.escape.quincunx.dxf.reader.Dxf14Converter;
import de.escape.quincunx.dxf.reader.Dxf3DFACE;
import de.escape.quincunx.dxf.reader.DxfARC;
import de.escape.quincunx.dxf.reader.DxfBLOCK;
import de.escape.quincunx.dxf.reader.DxfCIRCLE;
import de.escape.quincunx.dxf.reader.DxfDIMENSION;
import de.escape.quincunx.dxf.reader.DxfELLIPSE;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfEntitySet;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfINSERT;
import de.escape.quincunx.dxf.reader.DxfLINE;
import de.escape.quincunx.dxf.reader.DxfLWPOLYLINE;
import de.escape.quincunx.dxf.reader.DxfPOINT;
import de.escape.quincunx.dxf.reader.DxfPOLYLINE;
import de.escape.quincunx.dxf.reader.DxfSOLID;
import de.escape.quincunx.dxf.reader.DxfTEXT;
import de.escape.quincunx.dxf.reader.DxfTRACE;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.util.Enumeration;

public class Drawable14Converter
extends DrawableConverter
implements Dxf14Converter {
    public void convert(DxfFile dxf) {
        DxfEntitySet entities = dxf.getEntities().getEntitySet();
        if (entities != null) {
            int nrEntities = entities.getNrOfEntities();
            this.complete = new DrawSet(nrEntities);
            int nr = 0;
            Enumeration e = entities.getEntities();
            while (e.hasMoreElements()) {
                DxfEntity ent = (DxfEntity)e.nextElement();
                if (DxfViewer.debugLevel > 10) {
                    System.out.println("Converting " + ent);
                }
                dxf.showProgress(nr, nrEntities);
                ent.convert(this, dxf, (Object)this.complete);
                ++nr;
            }
            dxf.showProgress(1.0f);
        }
    }

    public void convert(Dxf3DFACE face, DxfFile dxf, Object collector) {
        if (!face.isInvisible()) {
            super.convert(face, dxf, collector);
        }
    }

    public void convert(DxfARC arc, DxfFile dxf, Object collector) {
        if (!arc.isInvisible()) {
            super.convert(arc, dxf, collector);
        }
    }

    public void convert(DxfBLOCK block, DxfFile dxf, Object collector) {
        if (!block.isInvisible()) {
            super.convert(block, dxf, collector);
        }
    }

    public void convert(DxfCIRCLE circle, DxfFile dxf, Object collector) {
        if (!circle.isInvisible()) {
            super.convert(circle, dxf, collector);
        }
    }

    public void convert(DxfDIMENSION dim, DxfFile dxf, Object collector) {
        if (!dim.isInvisible()) {
            super.convert(dim, dxf, collector);
        }
    }

    public void convert(DxfINSERT insert, DxfFile dxf, Object collector) {
        if (!insert.isInvisible()) {
            super.convert(insert, dxf, collector);
        }
    }

    public void convert(DxfLINE line, DxfFile dxf, Object collector) {
        if (!line.isInvisible()) {
            super.convert(line, dxf, collector);
        }
    }

    public void convert(DxfPOINT point, DxfFile dxf, Object collector) {
        if (!point.isInvisible()) {
            super.convert(point, dxf, collector);
        }
    }

    public void convert(DxfPOLYLINE poly, DxfFile dxf, Object collector) {
        if (!poly.isInvisible()) {
            super.convert(poly, dxf, collector);
        }
    }

    public void convert(DxfSOLID solid, DxfFile dxf, Object collector) {
        if (!solid.isInvisible()) {
            super.convert(solid, dxf, collector);
        }
    }

    public void convert(DxfTEXT text, DxfFile dxf, Object collector) {
        if (!text.isInvisible()) {
            super.convert(text, dxf, collector);
        }
    }

    public void convert(DxfTRACE trace, DxfFile dxf, Object collector) {
        if (!trace.isInvisible()) {
            super.convert(trace, dxf, collector);
        }
    }

    public void convert(DxfLWPOLYLINE poly, DxfFile dxf, Object collector) {
        if (poly.isInvisible() || poly.getTile()) {
            return;
        }
        boolean isClosed = (poly.getType() & 1) != 0;
        boolean hasWidth = poly.hasLineWidth();
        DxfLWPOLYLINE.LwVertex[] vertices = poly.getVertices();
        DxfLWPOLYLINE.LwVertex firstVertex = null;
        DxfLWPOLYLINE.LwVertex nextVertex = null;
        DrawLines sline = hasWidth ? null : new DrawLines();
        DrawLinesWithWidth wline = hasWidth ? new DrawLinesWithWidth() : null;
        DrawLines line = hasWidth ? wline : sline;
        int vertexNr = 0;
        while (vertexNr < vertices.length) {
            if (nextVertex == null) {
                nextVertex = vertices[vertexNr];
            }
            DxfLWPOLYLINE.LwVertex vertex = nextVertex;
            if (firstVertex == null) {
                firstVertex = vertex;
            }
            nextVertex = vertexNr == vertices.length - 1 ? (isClosed ? firstVertex : null) : vertices[vertexNr + 1];
            if (vertex.getBulge() == 0.0f || nextVertex == null) {
                if (hasWidth) {
                    wline.addPoint(vertex.getPosition(), vertex.getStartWidth(), vertex.getEndWidth());
                } else {
                    sline.addPoint(vertex.getPosition());
                }
            } else {
                float[] vec = new float[2];
                float[] mid = new float[2];
                Point3D thisPosition = vertex.getPosition();
                Point3D nextPosition = nextVertex.getPosition();
                float alpha = (float)(4.0 * Math.atan(vertex.getBulge()));
                vec[0] = nextPosition.x - thisPosition.x;
                vec[1] = nextPosition.y - thisPosition.y;
                float dist = (float)Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1]);
                if (dist != 0.0f) {
                    vec[0] = vec[0] / dist;
                    vec[1] = vec[1] / dist;
                    float radius = dist / (float)(2.0 * Math.sin(alpha / 2.0f));
                    mid[0] = (thisPosition.x + nextPosition.x) / 2.0f - (radius - vertex.getBulge() * dist / 2.0f) * vec[1];
                    mid[1] = (thisPosition.y + nextPosition.y) / 2.0f + (radius - vertex.getBulge() * dist / 2.0f) * vec[0];
                    int segs = (int)Math.ceil((double)(36.0f * Math.abs(alpha)) / Math.PI / 2.0);
                    float start = (float)Math.atan2(thisPosition.y - mid[1], thisPosition.x - mid[0]);
                    alpha /= (float)segs;
                    if (radius < 0.0f) {
                        radius = -radius;
                    }
                    if (hasWidth) {
                        if (segs > 0) {
                            float width = vertex.getStartWidth();
                            float deltaWidth = (vertex.getEndWidth() - width) / (float)segs;
                            int j = 0;
                            while (j < segs) {
                                wline.addPoint(mid[0] + radius * (float)Math.cos(start), mid[1] + radius * (float)Math.sin(start), thisPosition.z, width, width + deltaWidth);
                                ++j;
                                start += alpha;
                                width += deltaWidth;
                            }
                        }
                    } else {
                        int j = 0;
                        while (j < segs) {
                            sline.addPoint(mid[0] + radius * (float)Math.cos(start), mid[1] + radius * (float)Math.sin(start), thisPosition.z);
                            ++j;
                            start += alpha;
                        }
                    }
                }
            }
            ++vertexNr;
        }
        if (isClosed) {
            line.close();
        }
        DrawableConverter.setEntityInfo(line, poly);
        ((DrawSet)collector).addDrawable(DrawableConverter.finalConv(line, poly));
    }

    public void convert(DxfELLIPSE ellipse, DxfFile dxf, Object collector) {
        if (ellipse.isInvisible() || ellipse.getTile()) {
            return;
        }
        Point3D center = ellipse.getCenter();
        Vector3D axis1 = ellipse.getAxisDir();
        Vector3D axis2 = ellipse.getUpwardVector().cross(axis1);
        axis2.normalize();
        axis2.scale(axis1.length() * ellipse.getAspectRatio());
        float startAngle = ellipse.getStartAngle();
        float endAngle = ellipse.getEndAngle();
        while (endAngle < startAngle) {
            endAngle += (float)Math.PI * 2;
        }
        if (startAngle == endAngle || endAngle >= startAngle + (float)Math.PI * 2) {
            startAngle = 0.0f;
            endAngle = (float)Math.PI * 2;
        }
        boolean closed = startAngle == 0.0f && endAngle == (float)Math.PI * 2;
        int nrSegments = (int)Math.ceil((double)((endAngle - startAngle) * 36.0f) / 2.0 / Math.PI);
        DrawLines line = closed ? new DrawLines(36) : new DrawLines(nrSegments + 1);
        float delta = (endAngle - startAngle) / (float)nrSegments;
        if (delta == 0.0f) {
            nrSegments = 36;
            delta = (float)(Math.PI * 2 / (double)nrSegments);
        }
        float angle = startAngle;
        int i = nrSegments - (closed ? 1 : 0);
        while (i >= 0) {
            float sin = (float)Math.sin(angle);
            float cos = (float)Math.cos(angle);
            line.addPoint(center.x + cos * axis1.x + sin * axis2.x, center.y + cos * axis1.y + sin * axis2.y, center.z + cos * axis1.z + sin * axis2.z);
            --i;
            angle += delta;
        }
        DrawableConverter.setEntityInfo(line, ellipse);
        ((DrawSet)collector).addDrawable(line);
    }

    public void convert(DxfEntitySet set, DxfFile dxf, Object collector) {
        DrawSet drawset = new DrawSet(set.getNrOfEntities());
        Enumeration e = set.getEntities();
        while (e.hasMoreElements()) {
            ((DxfEntity)e.nextElement()).convert(this, dxf, (Object)drawset);
        }
        ((DrawSet)collector).addDrawable(drawset);
    }
}

