/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(-2.0, -3.0, 0.0) => -2.0
 * mix(-2.0, -3.0, 0.33333334) => -2.3333333
 * mix(-2.0, -3.0, 0.6666667) => -2.6666667
 * mix(-2.0, -3.0, 1.0) => -3.0
 * mix(-2.0, 3.0, 0.0) => -2.0
 * mix(-2.0, 3.0, 0.33333334) => -0.33333328
 * mix(-2.0, 3.0, 0.6666667) => 1.3333335
 * mix(-2.0, 3.0, 1.0) => 3.0
 * mix(2.0, -3.0, 0.0) => 2.0
 * mix(2.0, -3.0, 0.33333334) => 0.33333328
 * mix(2.0, -3.0, 0.6666667) => -1.3333335
 * mix(2.0, -3.0, 1.0) => -3.0
 * mix(2.0, 3.0, 0.0) => 2.0
 * mix(2.0, 3.0, 0.33333334) => 2.3333333
 * mix(2.0, 3.0, 0.6666667) => 2.6666667
 * mix(2.0, 3.0, 1.0) => 3.0
 */
#version 150

void main()
{
  float[distance(mix(-2.0, -3.0, 0.0), -2.0) <= 2e-05 ? 1 : -1] array0;
  float[distance(mix(-2.0, -3.0, 0.33333334), -2.3333333) <= 2.3333334e-05 ? 1 : -1] array1;
  float[distance(mix(-2.0, -3.0, 0.6666667), -2.6666667) <= 2.6666667e-05 ? 1 : -1] array2;
  float[distance(mix(-2.0, -3.0, 1.0), -3.0) <= 3e-05 ? 1 : -1] array3;
  float[distance(mix(-2.0, 3.0, 0.0), -2.0) <= 2e-05 ? 1 : -1] array4;
  float[distance(mix(-2.0, 3.0, 0.33333334), -0.33333328) <= 3.3333329e-06 ? 1 : -1] array5;
  float[distance(mix(-2.0, 3.0, 0.6666667), 1.3333335) <= 1.3333334e-05 ? 1 : -1] array6;
  float[distance(mix(-2.0, 3.0, 1.0), 3.0) <= 3e-05 ? 1 : -1] array7;
  float[distance(mix(2.0, -3.0, 0.0), 2.0) <= 2e-05 ? 1 : -1] array8;
  float[distance(mix(2.0, -3.0, 0.33333334), 0.33333328) <= 3.3333329e-06 ? 1 : -1] array9;
  float[distance(mix(2.0, -3.0, 0.6666667), -1.3333335) <= 1.3333334e-05 ? 1 : -1] array10;
  float[distance(mix(2.0, -3.0, 1.0), -3.0) <= 3e-05 ? 1 : -1] array11;
  float[distance(mix(2.0, 3.0, 0.0), 2.0) <= 2e-05 ? 1 : -1] array12;
  float[distance(mix(2.0, 3.0, 0.33333334), 2.3333333) <= 2.3333334e-05 ? 1 : -1] array13;
  float[distance(mix(2.0, 3.0, 0.6666667), 2.6666667) <= 2.6666667e-05 ? 1 : -1] array14;
  float[distance(mix(2.0, 3.0, 1.0), 3.0) <= 3e-05 ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
