/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(ivec3(-5, -5, -5), ivec3(-5, -2, -1)) => bvec3(true, false, false)
 * equal(ivec3(-5, -5, -5), ivec3(0, 1, 2)) => bvec3(false, false, false)
 * equal(ivec3(-5, -2, -2), ivec3(5, -5, -2)) => bvec3(false, false, true)
 * equal(ivec3(-2, -2, -2), ivec3(-1, 0, 1)) => bvec3(false, false, false)
 * equal(ivec3(-2, -2, -1), ivec3(2, 5, -5)) => bvec3(false, false, false)
 * equal(ivec3(-1, -1, -1), ivec3(-2, -1, 0)) => bvec3(false, true, false)
 * equal(ivec3(-1, -1, -1), ivec3(1, 2, 5)) => bvec3(false, false, false)
 * equal(ivec3(0, 0, 0), ivec3(-5, -2, -1)) => bvec3(false, false, false)
 * equal(ivec3(0, 0, 0), ivec3(0, 1, 2)) => bvec3(true, false, false)
 * equal(ivec3(0, 1, 1), ivec3(5, -5, -2)) => bvec3(false, false, false)
 * equal(ivec3(1, 1, 1), ivec3(-1, 0, 1)) => bvec3(false, false, true)
 * equal(ivec3(1, 1, 2), ivec3(2, 5, -5)) => bvec3(false, false, false)
 * equal(ivec3(2, 2, 2), ivec3(-2, -1, 0)) => bvec3(false, false, false)
 * equal(ivec3(2, 2, 2), ivec3(1, 2, 5)) => bvec3(false, true, false)
 * equal(ivec3(5, 5, 5), ivec3(-5, -2, -1)) => bvec3(false, false, false)
 * equal(ivec3(5, 5, 5), ivec3(0, 1, 2)) => bvec3(false, false, false)
 * equal(ivec3(5, -5, -5), ivec3(5, -5, -2)) => bvec3(true, true, false)
 */
#version 150

void main()
{
  float[equal(ivec3(-5, -5, -5), ivec3(-5, -2, -1))[0] == true && equal(ivec3(-5, -5, -5), ivec3(-5, -2, -1))[1] == false && equal(ivec3(-5, -5, -5), ivec3(-5, -2, -1))[2] == false ? 1 : -1] array0;
  float[equal(ivec3(-5, -5, -5), ivec3(0, 1, 2))[0] == false && equal(ivec3(-5, -5, -5), ivec3(0, 1, 2))[1] == false && equal(ivec3(-5, -5, -5), ivec3(0, 1, 2))[2] == false ? 1 : -1] array1;
  float[equal(ivec3(-5, -2, -2), ivec3(5, -5, -2))[0] == false && equal(ivec3(-5, -2, -2), ivec3(5, -5, -2))[1] == false && equal(ivec3(-5, -2, -2), ivec3(5, -5, -2))[2] == true ? 1 : -1] array2;
  float[equal(ivec3(-2, -2, -2), ivec3(-1, 0, 1))[0] == false && equal(ivec3(-2, -2, -2), ivec3(-1, 0, 1))[1] == false && equal(ivec3(-2, -2, -2), ivec3(-1, 0, 1))[2] == false ? 1 : -1] array3;
  float[equal(ivec3(-2, -2, -1), ivec3(2, 5, -5))[0] == false && equal(ivec3(-2, -2, -1), ivec3(2, 5, -5))[1] == false && equal(ivec3(-2, -2, -1), ivec3(2, 5, -5))[2] == false ? 1 : -1] array4;
  float[equal(ivec3(-1, -1, -1), ivec3(-2, -1, 0))[0] == false && equal(ivec3(-1, -1, -1), ivec3(-2, -1, 0))[1] == true && equal(ivec3(-1, -1, -1), ivec3(-2, -1, 0))[2] == false ? 1 : -1] array5;
  float[equal(ivec3(-1, -1, -1), ivec3(1, 2, 5))[0] == false && equal(ivec3(-1, -1, -1), ivec3(1, 2, 5))[1] == false && equal(ivec3(-1, -1, -1), ivec3(1, 2, 5))[2] == false ? 1 : -1] array6;
  float[equal(ivec3(0, 0, 0), ivec3(-5, -2, -1))[0] == false && equal(ivec3(0, 0, 0), ivec3(-5, -2, -1))[1] == false && equal(ivec3(0, 0, 0), ivec3(-5, -2, -1))[2] == false ? 1 : -1] array7;
  float[equal(ivec3(0, 0, 0), ivec3(0, 1, 2))[0] == true && equal(ivec3(0, 0, 0), ivec3(0, 1, 2))[1] == false && equal(ivec3(0, 0, 0), ivec3(0, 1, 2))[2] == false ? 1 : -1] array8;
  float[equal(ivec3(0, 1, 1), ivec3(5, -5, -2))[0] == false && equal(ivec3(0, 1, 1), ivec3(5, -5, -2))[1] == false && equal(ivec3(0, 1, 1), ivec3(5, -5, -2))[2] == false ? 1 : -1] array9;
  float[equal(ivec3(1, 1, 1), ivec3(-1, 0, 1))[0] == false && equal(ivec3(1, 1, 1), ivec3(-1, 0, 1))[1] == false && equal(ivec3(1, 1, 1), ivec3(-1, 0, 1))[2] == true ? 1 : -1] array10;
  float[equal(ivec3(1, 1, 2), ivec3(2, 5, -5))[0] == false && equal(ivec3(1, 1, 2), ivec3(2, 5, -5))[1] == false && equal(ivec3(1, 1, 2), ivec3(2, 5, -5))[2] == false ? 1 : -1] array11;
  float[equal(ivec3(2, 2, 2), ivec3(-2, -1, 0))[0] == false && equal(ivec3(2, 2, 2), ivec3(-2, -1, 0))[1] == false && equal(ivec3(2, 2, 2), ivec3(-2, -1, 0))[2] == false ? 1 : -1] array12;
  float[equal(ivec3(2, 2, 2), ivec3(1, 2, 5))[0] == false && equal(ivec3(2, 2, 2), ivec3(1, 2, 5))[1] == true && equal(ivec3(2, 2, 2), ivec3(1, 2, 5))[2] == false ? 1 : -1] array13;
  float[equal(ivec3(5, 5, 5), ivec3(-5, -2, -1))[0] == false && equal(ivec3(5, 5, 5), ivec3(-5, -2, -1))[1] == false && equal(ivec3(5, 5, 5), ivec3(-5, -2, -1))[2] == false ? 1 : -1] array14;
  float[equal(ivec3(5, 5, 5), ivec3(0, 1, 2))[0] == false && equal(ivec3(5, 5, 5), ivec3(0, 1, 2))[1] == false && equal(ivec3(5, 5, 5), ivec3(0, 1, 2))[2] == false ? 1 : -1] array15;
  float[equal(ivec3(5, -5, -5), ivec3(5, -5, -2))[0] == true && equal(ivec3(5, -5, -5), ivec3(5, -5, -2))[1] == true && equal(ivec3(5, -5, -5), ivec3(5, -5, -2))[2] == false ? 1 : -1] array16;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length());
}
