/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) ^ abs(- ivec3(-36, 32, -88))) => ivec3(-8, 0, -16)
 * (ivec3(-36, 32, -88) ^ abs(- ivec3(36, 32, 88))) => ivec3(-8, 0, -16)
 * (ivec3(-36, 32, -88) ^ abs(- ivec3(59, 77, 68))) => ivec3(-25, 109, -20)
 * (ivec3(36, 32, 88) ^ abs(- ivec3(-36, 32, -88))) => ivec3(0, 0, 0)
 * (ivec3(36, 32, 88) ^ abs(- ivec3(36, 32, 88))) => ivec3(0, 0, 0)
 * (ivec3(36, 32, 88) ^ abs(- ivec3(59, 77, 68))) => ivec3(31, 109, 28)
 * (ivec3(59, 77, 68) ^ abs(- ivec3(-36, 32, -88))) => ivec3(31, 109, 28)
 * (ivec3(59, 77, 68) ^ abs(- ivec3(36, 32, 88))) => ivec3(31, 109, 28)
 * (ivec3(59, 77, 68) ^ abs(- ivec3(59, 77, 68))) => ivec3(0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec3(-36, 32, -88) ^ abs(- ivec3(-36, 32, -88))), ivec3(-8, 0, -16))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) ^ abs(- ivec3(36, 32, 88))), ivec3(-8, 0, -16))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) ^ abs(- ivec3(59, 77, 68))), ivec3(-25, 109, -20))) ? 1 : -1] array2;
  float[all(equal((ivec3(36, 32, 88) ^ abs(- ivec3(-36, 32, -88))), ivec3(0, 0, 0))) ? 1 : -1] array3;
  float[all(equal((ivec3(36, 32, 88) ^ abs(- ivec3(36, 32, 88))), ivec3(0, 0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) ^ abs(- ivec3(59, 77, 68))), ivec3(31, 109, 28))) ? 1 : -1] array5;
  float[all(equal((ivec3(59, 77, 68) ^ abs(- ivec3(-36, 32, -88))), ivec3(31, 109, 28))) ? 1 : -1] array6;
  float[all(equal((ivec3(59, 77, 68) ^ abs(- ivec3(36, 32, 88))), ivec3(31, 109, 28))) ? 1 : -1] array7;
  float[all(equal((ivec3(59, 77, 68) ^ abs(- ivec3(59, 77, 68))), ivec3(0, 0, 0))) ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
