/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (- ivec2(38, 35)) => ivec2(-38, -35)
 * (- ivec2(64, -9)) => ivec2(-64, 9)
 * (- ivec2(64, 9)) => ivec2(-64, -9)
 */
#version 120

void main()
{
  float[all(equal((- ivec2(38, 35)), ivec2(-38, -35))) ? 1 : -1] array0;
  float[all(equal((- ivec2(64, -9)), ivec2(-64, 9))) ? 1 : -1] array1;
  float[all(equal((- ivec2(64, 9)), ivec2(-64, -9))) ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
