/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec3(-0.03, -0.85, -0.94) != vec3(-0.03, -0.85, -0.94)) => false
 * (vec3(-0.03, -0.85, -0.94) != vec3(1.67, 0.66, 1.87)) => true
 * (vec3(1.67, 0.66, 1.87) != vec3(-0.03, -0.85, -0.94)) => true
 * (vec3(1.67, 0.66, 1.87) != vec3(1.67, 0.66, 1.87)) => false
 */
#version 120

void main()
{
  float[(vec3(-0.03, -0.85, -0.94) != vec3(-0.03, -0.85, -0.94)) == false ? 1 : -1] array0;
  float[(vec3(-0.03, -0.85, -0.94) != vec3(1.67, 0.66, 1.87)) == true ? 1 : -1] array1;
  float[(vec3(1.67, 0.66, 1.87) != vec3(-0.03, -0.85, -0.94)) == true ? 1 : -1] array2;
  float[(vec3(1.67, 0.66, 1.87) != vec3(1.67, 0.66, 1.87)) == false ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
