/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l + i64vec2(-10l, -12l)) => i64vec2(-10l, -12l)
 * (0l + i64vec2(-42l, 48l)) => i64vec2(-42l, 48l)
 * (3l + i64vec2(-10l, -12l)) => i64vec2(-7l, -9l)
 * (3l + i64vec2(-42l, 48l)) => i64vec2(-39l, 51l)
 * (-1192l + i64vec2(-10l, -12l)) => i64vec2(-1202l, -1204l)
 * (-1192l + i64vec2(-42l, 48l)) => i64vec2(-1234l, -1144l)
 * (1048576l + i64vec2(-10l, -12l)) => i64vec2(1048566l, 1048564l)
 * (1048576l + i64vec2(-42l, 48l)) => i64vec2(1048534l, 1048624l)
 * (4251475l + i64vec2(-10l, -12l)) => i64vec2(4251465l, 4251463l)
 * (4251475l + i64vec2(-42l, 48l)) => i64vec2(4251433l, 4251523l)
 * (29852643761l + i64vec2(-10l, -12l)) => i64vec2(29852643751l, 29852643749l)
 * (29852643761l + i64vec2(-42l, 48l)) => i64vec2(29852643719l, 29852643809l)
 * (-4398046511104l + i64vec2(-10l, -12l)) => i64vec2(-4398046511114l, -4398046511116l)
 * (-4398046511104l + i64vec2(-42l, 48l)) => i64vec2(-4398046511146l, -4398046511056l)
 * (-3948976685146l + i64vec2(-10l, -12l)) => i64vec2(-3948976685156l, -3948976685158l)
 * (-3948976685146l + i64vec2(-42l, 48l)) => i64vec2(-3948976685188l, -3948976685098l)
 * (-135763469567146206l + i64vec2(-10l, -12l)) => i64vec2(-135763469567146216l, -135763469567146218l)
 * (-135763469567146206l + i64vec2(-42l, 48l)) => i64vec2(-135763469567146248l, -135763469567146158l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l + i64vec2(-10l, -12l)), i64vec2(-10l, -12l))) ? 1 : -1] array0;
  float[all(equal((0l + i64vec2(-42l, 48l)), i64vec2(-42l, 48l))) ? 1 : -1] array1;
  float[all(equal((3l + i64vec2(-10l, -12l)), i64vec2(-7l, -9l))) ? 1 : -1] array2;
  float[all(equal((3l + i64vec2(-42l, 48l)), i64vec2(-39l, 51l))) ? 1 : -1] array3;
  float[all(equal((-1192l + i64vec2(-10l, -12l)), i64vec2(-1202l, -1204l))) ? 1 : -1] array4;
  float[all(equal((-1192l + i64vec2(-42l, 48l)), i64vec2(-1234l, -1144l))) ? 1 : -1] array5;
  float[all(equal((1048576l + i64vec2(-10l, -12l)), i64vec2(1048566l, 1048564l))) ? 1 : -1] array6;
  float[all(equal((1048576l + i64vec2(-42l, 48l)), i64vec2(1048534l, 1048624l))) ? 1 : -1] array7;
  float[all(equal((4251475l + i64vec2(-10l, -12l)), i64vec2(4251465l, 4251463l))) ? 1 : -1] array8;
  float[all(equal((4251475l + i64vec2(-42l, 48l)), i64vec2(4251433l, 4251523l))) ? 1 : -1] array9;
  float[all(equal((29852643761l + i64vec2(-10l, -12l)), i64vec2(29852643751l, 29852643749l))) ? 1 : -1] array10;
  float[all(equal((29852643761l + i64vec2(-42l, 48l)), i64vec2(29852643719l, 29852643809l))) ? 1 : -1] array11;
  float[all(equal((-4398046511104l + i64vec2(-10l, -12l)), i64vec2(-4398046511114l, -4398046511116l))) ? 1 : -1] array12;
  float[all(equal((-4398046511104l + i64vec2(-42l, 48l)), i64vec2(-4398046511146l, -4398046511056l))) ? 1 : -1] array13;
  float[all(equal((-3948976685146l + i64vec2(-10l, -12l)), i64vec2(-3948976685156l, -3948976685158l))) ? 1 : -1] array14;
  float[all(equal((-3948976685146l + i64vec2(-42l, 48l)), i64vec2(-3948976685188l, -3948976685098l))) ? 1 : -1] array15;
  float[all(equal((-135763469567146206l + i64vec2(-10l, -12l)), i64vec2(-135763469567146216l, -135763469567146218l))) ? 1 : -1] array16;
  float[all(equal((-135763469567146206l + i64vec2(-42l, 48l)), i64vec2(-135763469567146248l, -135763469567146158l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
