/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.ModbusConstants;
import org.openhab.core.io.transport.modbus.ModbusRegisterArray;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.unit.Units;
import org.openhab.core.types.Command;

@NonNullByDefault
public class ModbusBitUtilities {
    public static Optional<DecimalType> extractStateFromRegisters(ModbusRegisterArray registers, int index, ModbusConstants.ValueType type) {
        byte[] bytes = registers.getBytes();
        switch (type) {
            case BIT: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractBit(bytes, index)));
            }
            case INT8: {
                int registerIndex = index / 2;
                boolean hiByte = index % 2 == 1;
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractSInt8(bytes, registerIndex, hiByte)));
            }
            case UINT8: {
                int registerIndex = index / 2;
                boolean hiByte = index % 2 == 1;
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractUInt8(bytes, registerIndex, hiByte)));
            }
            case INT16: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractSInt16(bytes, index * 2)));
            }
            case UINT16: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractUInt16(bytes, index * 2)));
            }
            case INT32: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractSInt32(bytes, index * 2)));
            }
            case UINT32: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractUInt32(bytes, index * 2)));
            }
            case FLOAT32: {
                try {
                    return Optional.of(new DecimalType((Number)Float.valueOf(ModbusBitUtilities.extractFloat32(bytes, index * 2))));
                }
                catch (NumberFormatException e) {
                    return Optional.empty();
                }
            }
            case INT64: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractSInt64(bytes, index * 2)));
            }
            case UINT64: {
                return Optional.of(new DecimalType((Number)new BigDecimal(ModbusBitUtilities.extractUInt64(bytes, index * 2))));
            }
            case INT32_SWAP: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractSInt32Swap(bytes, index * 2)));
            }
            case UINT32_SWAP: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractUInt32Swap(bytes, index * 2)));
            }
            case FLOAT32_SWAP: {
                try {
                    return Optional.of(new DecimalType((Number)Float.valueOf(ModbusBitUtilities.extractFloat32Swap(bytes, index * 2))));
                }
                catch (NumberFormatException e) {
                    return Optional.empty();
                }
            }
            case INT64_SWAP: {
                return Optional.of(new DecimalType((Number)ModbusBitUtilities.extractSInt64Swap(bytes, index * 2)));
            }
            case UINT64_SWAP: {
                return Optional.of(new DecimalType((Number)new BigDecimal(ModbusBitUtilities.extractUInt64Swap(bytes, index * 2))));
            }
        }
        throw new IllegalStateException(type.getConfigValue());
    }

    private static void assertIndexAndType(byte[] bytes, int index, ModbusConstants.ValueType type) {
        int lastValidIndex;
        int typeBits = type.getBits();
        int indexPositionAsBitIndex = Math.min(type.getBits(), 8) * index;
        int endBitIndex = indexPositionAsBitIndex + typeBits - 1;
        if (endBitIndex > (lastValidIndex = bytes.length * 8 - 1) || index < 0) {
            throw new IllegalArgumentException(String.format("Index=%d with type=%s is out-of-bounds given registers of size %d ", new Object[]{index, type, bytes.length / 2}));
        }
    }

    public static int extractBit(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.BIT);
        int registerIndex = index / 16;
        int bitIndexWithinRegister = index % 16;
        return ModbusBitUtilities.extractBit(bytes, registerIndex, bitIndexWithinRegister);
    }

    public static int extractBit(byte[] bytes, int registerIndex, int bitIndexWithinRegister) {
        if (bitIndexWithinRegister < 0 || bitIndexWithinRegister > 15) {
            throw new IllegalArgumentException(String.format("bitIndexWithinRegister=%d is out-of-bounds (max 15)", bitIndexWithinRegister));
        }
        if (registerIndex < 0) {
            throw new IllegalArgumentException(String.format("registerIndex=%d is out-of-bounds", bitIndexWithinRegister));
        }
        boolean hiByte = bitIndexWithinRegister >= 8;
        int indexWithinByte = bitIndexWithinRegister % 8;
        int byteIndex = 2 * registerIndex + (hiByte ? 0 : 1);
        if (byteIndex >= bytes.length) {
            throw new IllegalArgumentException(String.format("registerIndex=%d, bitIndexWithinRegister=%d is out-of-bounds with registers of size %d", registerIndex, bitIndexWithinRegister, bytes.length / 2));
        }
        return bytes[byteIndex] >>> indexWithinByte & 1;
    }

    public static byte extractSInt8(byte[] bytes, int registerIndex, boolean hiByte) {
        int byteIndex = 2 * registerIndex + (hiByte ? 0 : 1);
        return ModbusBitUtilities.extractSInt8(bytes, byteIndex);
    }

    public static byte extractSInt8(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.INT8);
        return bytes[index];
    }

    public static short extractUInt8(byte[] bytes, int registerIndex, boolean hiByte) {
        int byteIndex = 2 * registerIndex + (hiByte ? 0 : 1);
        return ModbusBitUtilities.extractUInt8(bytes, byteIndex);
    }

    public static short extractUInt8(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.UINT8);
        byte signed = ModbusBitUtilities.extractSInt8(bytes, index);
        return (short)(signed & 0xFF);
    }

    public static short extractSInt16(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.INT16);
        int hi = bytes[index] & 0xFF;
        int lo = bytes[index + 1] & 0xFF;
        return (short)(hi << 8 | lo);
    }

    public static int extractUInt16(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.UINT16);
        short signed = ModbusBitUtilities.extractSInt16(bytes, index);
        return signed & 0xFFFF;
    }

    public static int extractSInt32(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.INT32);
        int hi1 = bytes[index + 0] & 0xFF;
        int lo1 = bytes[index + 1] & 0xFF;
        int hi2 = bytes[index + 2] & 0xFF;
        int lo2 = bytes[index + 3] & 0xFF;
        return hi1 << 24 | lo1 << 16 | hi2 << 8 | lo2;
    }

    public static long extractUInt32(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.UINT32);
        long signed = ModbusBitUtilities.extractSInt32(bytes, index);
        return signed & 0xFFFFFFFFL;
    }

    public static int extractSInt32Swap(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.INT32_SWAP);
        int hi1 = bytes[index + 2] & 0xFF;
        int lo1 = bytes[index + 3] & 0xFF;
        int hi2 = bytes[index + 0] & 0xFF;
        int lo2 = bytes[index + 1] & 0xFF;
        return hi1 << 24 | lo1 << 16 | hi2 << 8 | lo2;
    }

    public static long extractUInt32Swap(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.UINT32_SWAP);
        long signed = ModbusBitUtilities.extractSInt32Swap(bytes, index);
        return signed & 0xFFFFFFFFL;
    }

    public static long extractSInt64(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.INT64);
        byte hi1 = (byte)(bytes[index + 0] & 0xFF);
        byte lo1 = (byte)(bytes[index + 1] & 0xFF);
        byte hi2 = (byte)(bytes[index + 2] & 0xFF);
        byte lo2 = (byte)(bytes[index + 3] & 0xFF);
        byte hi3 = (byte)(bytes[index + 4] & 0xFF);
        byte lo3 = (byte)(bytes[index + 5] & 0xFF);
        byte hi4 = (byte)(bytes[index + 6] & 0xFF);
        byte lo4 = (byte)(bytes[index + 7] & 0xFF);
        return new BigInteger(new byte[]{hi1, lo1, hi2, lo2, hi3, lo3, hi4, lo4}).longValue();
    }

    public static BigInteger extractUInt64(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.UINT64);
        byte hi1 = (byte)(bytes[index + 0] & 0xFF);
        byte lo1 = (byte)(bytes[index + 1] & 0xFF);
        byte hi2 = (byte)(bytes[index + 2] & 0xFF);
        byte lo2 = (byte)(bytes[index + 3] & 0xFF);
        byte hi3 = (byte)(bytes[index + 4] & 0xFF);
        byte lo3 = (byte)(bytes[index + 5] & 0xFF);
        byte hi4 = (byte)(bytes[index + 6] & 0xFF);
        byte lo4 = (byte)(bytes[index + 7] & 0xFF);
        return new BigInteger(1, new byte[]{hi1, lo1, hi2, lo2, hi3, lo3, hi4, lo4});
    }

    public static long extractSInt64Swap(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.INT64_SWAP);
        byte hi1 = (byte)(bytes[index + 6] & 0xFF);
        byte lo1 = (byte)(bytes[index + 7] & 0xFF);
        byte hi2 = (byte)(bytes[index + 4] & 0xFF);
        byte lo2 = (byte)(bytes[index + 5] & 0xFF);
        byte hi3 = (byte)(bytes[index + 2] & 0xFF);
        byte lo3 = (byte)(bytes[index + 3] & 0xFF);
        byte hi4 = (byte)(bytes[index + 0] & 0xFF);
        byte lo4 = (byte)(bytes[index + 1] & 0xFF);
        return new BigInteger(new byte[]{hi1, lo1, hi2, lo2, hi3, lo3, hi4, lo4}).longValue();
    }

    public static BigInteger extractUInt64Swap(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.UINT64_SWAP);
        byte hi1 = (byte)(bytes[index + 6] & 0xFF);
        byte lo1 = (byte)(bytes[index + 7] & 0xFF);
        byte hi2 = (byte)(bytes[index + 4] & 0xFF);
        byte lo2 = (byte)(bytes[index + 5] & 0xFF);
        byte hi3 = (byte)(bytes[index + 2] & 0xFF);
        byte lo3 = (byte)(bytes[index + 3] & 0xFF);
        byte hi4 = (byte)(bytes[index + 0] & 0xFF);
        byte lo4 = (byte)(bytes[index + 1] & 0xFF);
        return new BigInteger(1, new byte[]{hi1, lo1, hi2, lo2, hi3, lo3, hi4, lo4});
    }

    public static float extractFloat32(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.FLOAT32);
        int hi1 = bytes[index + 0] & 0xFF;
        int lo1 = bytes[index + 1] & 0xFF;
        int hi2 = bytes[index + 2] & 0xFF;
        int lo2 = bytes[index + 3] & 0xFF;
        int bits32 = hi1 << 24 | lo1 << 16 | hi2 << 8 | lo2;
        return Float.intBitsToFloat(bits32);
    }

    public static float extractFloat32Swap(byte[] bytes, int index) {
        ModbusBitUtilities.assertIndexAndType(bytes, index, ModbusConstants.ValueType.FLOAT32_SWAP);
        int hi1 = bytes[index + 2] & 0xFF;
        int lo1 = bytes[index + 3] & 0xFF;
        int hi2 = bytes[index + 0] & 0xFF;
        int lo2 = bytes[index + 1] & 0xFF;
        int bits32 = hi1 << 24 | lo1 << 16 | hi2 << 8 | lo2;
        return Float.intBitsToFloat(bits32);
    }

    public static String extractStringFromRegisters(ModbusRegisterArray registers, int registerIndex, int length, Charset charset) {
        return ModbusBitUtilities.extractStringFromBytes(registers.getBytes(), registerIndex * 2, length, charset);
    }

    public static String extractStringFromBytes(byte[] bytes, int byteIndex, int length, Charset charset) {
        if (byteIndex + length > bytes.length) {
            throw new IllegalArgumentException(String.format("byteIndex=%d with length=%d is out-of-bounds given registers of size %d", byteIndex, length, bytes.length));
        }
        if (byteIndex < 0) {
            throw new IllegalArgumentException("Negative index values are not supported");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative string length is not supported");
        }
        int effectiveLength = length;
        int i = 0;
        while (i < length) {
            if (bytes[byteIndex + i] == 0) {
                effectiveLength = i;
                break;
            }
            ++i;
        }
        return new String(bytes, byteIndex, effectiveLength, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static ModbusRegisterArray commandToRegisters(Command command, ModbusConstants.ValueType type) {
        DecimalType numericCommand;
        if (command instanceof OnOffType || command instanceof OpenClosedType) {
            numericCommand = ModbusBitUtilities.translateCommand2Boolean(command).get() != false ? new DecimalType((Number)BigDecimal.ONE) : DecimalType.ZERO;
        } else {
            Command command2 = command;
            if (command2 instanceof DecimalType) {
                void decimalType;
                DecimalType decimalType2 = (DecimalType)command2;
                DecimalType cfr_ignored_0 = (DecimalType)command2;
                numericCommand = decimalType;
            } else {
                Command command3 = command;
                if (command3 instanceof QuantityType) {
                    void quantityType;
                    QuantityType quantityType2 = (QuantityType)command3;
                    QuantityType cfr_ignored_1 = (QuantityType)command3;
                    QuantityType qtCommand = quantityType.toUnit(Units.ONE);
                    if (qtCommand == null) {
                        throw new IllegalArgumentException(String.format("Command '%s' of class '%s' cannot be converted to bare number.", command, command.getClass().getName()));
                    }
                    numericCommand = qtCommand;
                } else {
                    throw new IllegalArgumentException(String.format("Command '%s' of class '%s' cannot be converted to registers. Please use OnOffType, OpenClosedType, DecimalType or dimensionless QuantityType commands.", command, command.getClass().getName()));
                }
            }
        }
        if (type.getBits() != 16 && type.getBits() != 32 && type.getBits() != 64) {
            throw new IllegalArgumentException(String.format("Illegal type=%s (bits=%d). Only 16bit and 32bit types are supported", new Object[]{type, type.getBits()}));
        }
        switch (type) {
            case INT16: 
            case UINT16: {
                short shortValue = numericCommand.shortValue();
                byte hi = (byte)(shortValue >> 8);
                byte lo = (byte)shortValue;
                return new ModbusRegisterArray(hi, lo);
            }
            case INT32: 
            case UINT32: {
                int intValue = numericCommand.intValue();
                byte hi1 = (byte)(intValue >> 24);
                byte lo1 = (byte)(intValue >> 16);
                byte hi2 = (byte)(intValue >> 8);
                byte lo2 = (byte)intValue;
                return new ModbusRegisterArray(hi1, lo1, hi2, lo2);
            }
            case INT32_SWAP: 
            case UINT32_SWAP: {
                int intValue = numericCommand.intValue();
                byte hi1 = (byte)(intValue >> 24);
                byte lo1 = (byte)(intValue >> 16);
                byte hi2 = (byte)(intValue >> 8);
                byte lo2 = (byte)intValue;
                return new ModbusRegisterArray(hi2, lo2, hi1, lo1);
            }
            case FLOAT32: {
                float floatValue = numericCommand.floatValue();
                int intBits = Float.floatToIntBits(floatValue);
                byte hi1 = (byte)(intBits >> 24);
                byte lo1 = (byte)(intBits >> 16);
                byte hi2 = (byte)(intBits >> 8);
                byte lo2 = (byte)intBits;
                return new ModbusRegisterArray(hi1, lo1, hi2, lo2);
            }
            case FLOAT32_SWAP: {
                float floatValue = numericCommand.floatValue();
                int intBits = Float.floatToIntBits(floatValue);
                byte hi1 = (byte)(intBits >> 24);
                byte lo1 = (byte)(intBits >> 16);
                byte hi2 = (byte)(intBits >> 8);
                byte lo2 = (byte)intBits;
                return new ModbusRegisterArray(hi2, lo2, hi1, lo1);
            }
            case INT64: 
            case UINT64: {
                long longValue = numericCommand.longValue();
                byte hi1 = (byte)(longValue >> 56);
                byte lo1 = (byte)(longValue >> 48);
                byte hi2 = (byte)(longValue >> 40);
                byte lo2 = (byte)(longValue >> 32);
                byte hi3 = (byte)(longValue >> 24);
                byte lo3 = (byte)(longValue >> 16);
                byte hi4 = (byte)(longValue >> 8);
                byte lo4 = (byte)longValue;
                return new ModbusRegisterArray(hi1, lo1, hi2, lo2, hi3, lo3, hi4, lo4);
            }
            case INT64_SWAP: 
            case UINT64_SWAP: {
                long longValue = numericCommand.longValue();
                byte hi1 = (byte)(longValue >> 56);
                byte lo1 = (byte)(longValue >> 48);
                byte hi2 = (byte)(longValue >> 40);
                byte lo2 = (byte)(longValue >> 32);
                byte hi3 = (byte)(longValue >> 24);
                byte lo3 = (byte)(longValue >> 16);
                byte hi4 = (byte)(longValue >> 8);
                byte lo4 = (byte)longValue;
                return new ModbusRegisterArray(hi4, lo4, hi3, lo3, hi2, lo2, hi1, lo1);
            }
        }
        throw new IllegalArgumentException(String.format("Illegal type=%s. Missing implementation for this type", new Object[]{type}));
    }

    public static Optional<Boolean> translateCommand2Boolean(Command command) {
        if (command.equals(OnOffType.ON)) {
            return Optional.of(Boolean.TRUE);
        }
        if (command.equals(OnOffType.OFF)) {
            return Optional.of(Boolean.FALSE);
        }
        if (command.equals(OpenClosedType.OPEN)) {
            return Optional.of(Boolean.TRUE);
        }
        if (command.equals(OpenClosedType.CLOSED)) {
            return Optional.of(Boolean.FALSE);
        }
        if (command instanceof DecimalType) {
            return Optional.of(!command.equals(DecimalType.ZERO));
        }
        return Optional.empty();
    }
}

