/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusSocketBasedTransportFactory;
import net.wimpi.modbus.io.ModbusTCPTransport;
import net.wimpi.modbus.io.ModbusTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPSlaveConnection {
    private static final Logger logger = LoggerFactory.getLogger(TCPSlaveConnection.class);
    private Socket m_Socket;
    private int m_Timeout = 3000;
    private boolean m_Connected;
    private ModbusTransport m_ModbusTransport;
    private ModbusSocketBasedTransportFactory m_TransportFactory;

    public TCPSlaveConnection(Socket socket, ModbusSocketBasedTransportFactory transportFactory) {
        this.m_TransportFactory = transportFactory;
        try {
            this.setSocket(socket);
        }
        catch (IOException ex) {
            String errMsg = "Socket invalid";
            logger.warn("Socket invalid");
            throw new IllegalStateException("Socket invalid");
        }
    }

    public TCPSlaveConnection(Socket socket) {
        this(socket, new ModbusTCPTransportFactory());
    }

    public void close() {
        if (this.m_Connected) {
            block3: {
                try {
                    this.m_ModbusTransport.close();
                    this.m_Socket.close();
                }
                catch (IOException ex) {
                    if (!Modbus.debug) break block3;
                    ex.printStackTrace();
                }
            }
            this.m_Connected = false;
        }
    }

    public ModbusTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    private void setSocket(Socket socket) throws IOException {
        this.m_Socket = socket;
        if (this.m_ModbusTransport != null) {
            throw new IllegalStateException("socket cannot be re-set");
        }
        this.m_ModbusTransport = this.m_TransportFactory.create(this.m_Socket);
        this.m_Connected = true;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
        try {
            this.m_Socket.setSoTimeout(this.m_Timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.m_Socket.getLocalPort();
    }

    public InetAddress getAddress() {
        return this.m_Socket.getLocalAddress();
    }

    public boolean isConnected() {
        return this.m_Connected;
    }

    public static class ModbusTCPTransportFactory
    implements ModbusSocketBasedTransportFactory {
        @Override
        public ModbusTransport create(Socket socket) {
            return new ModbusTCPTransport(socket);
        }
    }
}

