/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.msg.ModbusResponse;

public final class WriteCoilResponse
extends ModbusResponse {
    private boolean m_Coil = false;
    private int m_Reference;

    public WriteCoilResponse() {
        this.setFunctionCode(5);
        this.setDataLength(4);
    }

    public WriteCoilResponse(int reference, boolean b) {
        this.setFunctionCode(5);
        this.setDataLength(4);
        this.setReference(reference);
        this.setCoil(b);
    }

    private void setCoil(boolean b) {
        this.m_Coil = b;
    }

    public boolean getCoil() {
        return this.m_Coil;
    }

    public int getReference() {
        return this.m_Reference;
    }

    private void setReference(int ref) {
        this.m_Reference = ref;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.getReference());
        if (this.getCoil()) {
            dout.write(Modbus.COIL_ON_BYTES, 0, 2);
        } else {
            dout.write(Modbus.COIL_OFF_BYTES, 0, 2);
        }
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.setReference(din.readUnsignedShort());
        byte[] data = new byte[2];
        for (int k = 0; k < 2; ++k) {
            data[k] = din.readByte();
        }
        if (data[0] == -1) {
            this.setCoil(true);
        } else {
            this.setCoil(false);
        }
        this.setDataLength(4);
    }
}

