/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusMessageImpl;
import net.wimpi.modbus.msg.ReadCoilsResponse;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.msg.ReadInputRegistersResponse;
import net.wimpi.modbus.msg.ReadMultipleRegistersResponse;
import net.wimpi.modbus.msg.WriteCoilResponse;
import net.wimpi.modbus.msg.WriteMultipleCoilsResponse;
import net.wimpi.modbus.msg.WriteMultipleRegistersResponse;
import net.wimpi.modbus.msg.WriteSingleRegisterResponse;

public abstract class ModbusResponse
extends ModbusMessageImpl {
    protected void setMessage(byte[] msg) {
        try {
            this.readData(new DataInputStream(new ByteArrayInputStream(msg)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ModbusResponse createModbusResponse(int functionCode) {
        ModbusResponse response = null;
        switch (functionCode) {
            case 3: {
                response = new ReadMultipleRegistersResponse();
                break;
            }
            case 2: {
                response = new ReadInputDiscretesResponse();
                break;
            }
            case 4: {
                response = new ReadInputRegistersResponse();
                break;
            }
            case 1: {
                response = new ReadCoilsResponse();
                break;
            }
            case 16: {
                response = new WriteMultipleRegistersResponse();
                break;
            }
            case 6: {
                response = new WriteSingleRegisterResponse();
                break;
            }
            case 5: {
                response = new WriteCoilResponse();
                break;
            }
            case 15: {
                response = new WriteMultipleCoilsResponse();
                break;
            }
            default: {
                response = new ExceptionResponse();
            }
        }
        return response;
    }
}

