/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.context;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.context.DefaultHttpContext;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;

public class WebContainerContextWrapper
extends DefaultHttpContext {
    private final HttpContext httpContext;
    private final ServletContextHelper servletContextHelper;
    private final boolean shared;

    public WebContainerContextWrapper(Bundle bundle, HttpContext httpContext) {
        this(bundle, httpContext, WebContainerContextWrapper.uniqueId(httpContext));
    }

    public WebContainerContextWrapper(Bundle bundle, ServletContextHelper helper) {
        this(bundle, helper, WebContainerContextWrapper.uniqueId(helper));
    }

    public WebContainerContextWrapper(Bundle bundle, HttpContext httpContext, String name) {
        super(bundle, name == null ? WebContainerContextWrapper.uniqueId(httpContext) : name);
        this.httpContext = httpContext;
        this.servletContextHelper = null;
        this.shared = httpContext instanceof WebContainerContext && ((WebContainerContext)httpContext).isShared();
    }

    public WebContainerContextWrapper(Bundle bundle, ServletContextHelper helper, String name) {
        this(bundle, helper, name, true);
    }

    public WebContainerContextWrapper(Bundle bundle, ServletContextHelper helper, String name, boolean shared) {
        super(bundle, name == null ? WebContainerContextWrapper.uniqueId(helper) : name);
        this.httpContext = null;
        this.servletContextHelper = helper;
        this.shared = shared;
    }

    public static String uniqueId(Object context) {
        return String.format("context:%d", System.identityHashCode(context));
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.servletContextHelper != null) {
            return this.servletContextHelper.handleSecurity(request, response);
        }
        if (this.httpContext != null) {
            return this.httpContext.handleSecurity(request, response);
        }
        return true;
    }

    @Override
    public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
        if (this.servletContextHelper != null) {
            this.servletContextHelper.finishSecurity(request, response);
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.servletContextHelper != null) {
            return this.servletContextHelper.getResource(name);
        }
        return this.httpContext.getResource(name);
    }

    @Override
    public String getMimeType(String name) {
        if (this.servletContextHelper != null) {
            return this.servletContextHelper.getMimeType(name);
        }
        return this.httpContext.getMimeType(name);
    }

    @Override
    public Set<String> getResourcePaths(String name) {
        if (this.servletContextHelper != null) {
            return this.servletContextHelper.getResourcePaths(name);
        }
        return super.getResourcePaths(name);
    }

    public String getRealPath(String path) {
        if (this.servletContextHelper != null) {
            return this.servletContextHelper.getRealPath(path);
        }
        return super.getRealPath(path);
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public ServletContextHelper getServletContextHelper() {
        return this.servletContextHelper;
    }

    @Override
    public String toString() {
        return "WebContainerContextWrapper{" + (this.bundle == null ? "shared=true" : "bundle=" + this.bundle) + ",contextId='" + this.contextId + "',delegate=" + (this.servletContextHelper == null ? this.httpContext : this.servletContextHelper) + "}";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = 31 * result + (this.contextId == null ? 0 : this.contextId.hashCode());
        result = 31 * result + (this.httpContext == null ? 0 : this.httpContext.hashCode());
        result = 31 * result + (this.servletContextHelper == null ? 0 : this.servletContextHelper.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebContainerContextWrapper other = (WebContainerContextWrapper)obj;
        if (this.bundle == null ? other.bundle != null : !this.bundle.equals(other.bundle)) {
            return false;
        }
        if (this.httpContext == null) {
            if (this.contextId == null ? other.contextId != null : !this.contextId.equals(other.contextId)) {
                return false;
            }
            if (this.servletContextHelper == null) {
                return other.servletContextHelper == null;
            }
            return this.servletContextHelper.equals(other.servletContextHelper);
        }
        return this.httpContext.equals(other.httpContext);
    }
}

