/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.serial.internal;

import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigOptionProvider;
import org.openhab.core.config.core.ParameterOption;
import org.openhab.core.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscovery;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.openhab.core.io.transport.serial.SerialPortIdentifier;
import org.openhab.core.io.transport.serial.SerialPortManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component
public class SerialConfigOptionProvider
implements ConfigOptionProvider,
UsbSerialDiscoveryListener {
    static final String SERIAL_PORT = "serial-port";
    private final SerialPortManager serialPortManager;
    private final Set<UsbSerialDeviceInformation> previouslyDiscovered = new CopyOnWriteArraySet<UsbSerialDeviceInformation>();
    private final Set<UsbSerialDiscovery> usbSerialDiscoveries = new CopyOnWriteArraySet<UsbSerialDiscovery>();

    @Activate
    public SerialConfigOptionProvider(@Reference SerialPortManager serialPortManager) {
        this.serialPortManager = serialPortManager;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        this.usbSerialDiscoveries.add(usbSerialDiscovery);
        usbSerialDiscovery.registerDiscoveryListener((UsbSerialDiscoveryListener)this);
    }

    protected synchronized void removeUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        usbSerialDiscovery.unregisterDiscoveryListener((UsbSerialDiscoveryListener)this);
        this.usbSerialDiscoveries.remove(usbSerialDiscovery);
        this.previouslyDiscovered.clear();
    }

    public void usbSerialDeviceDiscovered(UsbSerialDeviceInformation usbSerialDeviceInformation) {
        this.previouslyDiscovered.add(usbSerialDeviceInformation);
    }

    public void usbSerialDeviceRemoved(UsbSerialDeviceInformation usbSerialDeviceInformation) {
        this.previouslyDiscovered.remove(usbSerialDeviceInformation);
    }

    public @Nullable Collection<ParameterOption> getParameterOptions(URI uri, String param, @Nullable String context, @Nullable Locale locale) {
        if (SERIAL_PORT.equals(context)) {
            return Stream.concat(this.serialPortManager.getIdentifiers().map(SerialPortIdentifier::getName), this.previouslyDiscovered.stream().map(UsbSerialDeviceInformation::getSerialPort)).distinct().map(serialPortName -> new ParameterOption(serialPortName, serialPortName)).toList();
        }
        return null;
    }
}

