/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import org.apache.felix.webconsole.plugins.event.internal.EventCollector;
import org.apache.felix.webconsole.plugins.event.internal.EventInfo;
import org.apache.felix.webconsole.plugins.event.internal.PluginServlet;
import org.apache.felix.webconsole.plugins.event.internal.converter.BundleEventConverter;
import org.apache.felix.webconsole.plugins.event.internal.converter.FrameworkEventConverter;
import org.apache.felix.webconsole.plugins.event.internal.converter.ServiceEventConverter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.SynchronousBundleListener;

public class EventListener
implements SynchronousBundleListener,
FrameworkListener,
ServiceListener {
    private final EventCollector collector;
    private final BundleContext bundleContext;

    public EventListener(PluginServlet plugin, BundleContext context) {
        this.collector = plugin.getCollector();
        this.bundleContext = context;
        context.addBundleListener((BundleListener)this);
        context.addFrameworkListener((FrameworkListener)this);
        context.addServiceListener((ServiceListener)this);
    }

    public void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        this.bundleContext.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        EventInfo info = ServiceEventConverter.getInfo(event);
        this.collector.add(info);
    }

    public void frameworkEvent(FrameworkEvent event) {
        EventInfo info = FrameworkEventConverter.getInfo(event);
        this.collector.add(info);
    }

    public void bundleChanged(BundleEvent event) {
        EventInfo info = BundleEventConverter.getInfo(event);
        this.collector.add(info);
    }
}

