/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.CoAPMessageFormatException;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.util.DatagramReader;

public final class UdpDataParser
extends DataParser {
    @Override
    protected MessageHeader parseHeader(DatagramReader reader) {
        if (!reader.bytesAvailable(4)) {
            throw new MessageFormatException("UDP Message too short! " + reader.bitsLeft() / 8 + " must be at least 4 bytes!");
        }
        int version = reader.read(2);
        this.assertCorrectVersion(version);
        int type = reader.read(2);
        int tokenLength = reader.read(4);
        UdpDataParser.assertValidTokenLength(tokenLength);
        int code = reader.read(8);
        int mid = reader.read(16);
        if (!reader.bytesAvailable(tokenLength)) {
            throw new CoAPMessageFormatException("UDP Message too short for token! " + reader.bitsLeft() / 8 + " must be at least " + tokenLength + " bytes!", null, mid, code, CoAP.Type.CON.value == type);
        }
        Token token = Token.fromProvider(reader.readBytes(tokenLength));
        return new MessageHeader(version, CoAP.Type.valueOf(type), token, code, mid, 0);
    }

    private void assertCorrectVersion(int version) {
        if (version != 1) {
            throw new MessageFormatException("Message has invalid version: " + version);
        }
    }
}

