/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.url;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.X509TrustManager;

class LocalTrustManager
implements X509TrustManager {
    static final CertificateFactory cf;
    static final CertPathValidator validator;
    static final X509Certificate[] empty;
    static final Base64.Decoder DECODER;
    private Set<TrustAnchor> anchors;
    private List<X509Certificate> trusted;
    private PKIXParameters parameter;
    private boolean verify;

    public LocalTrustManager(boolean verify, List<X509Certificate> trusted) throws InvalidAlgorithmParameterException {
        this.verify = verify;
        this.trusted = trusted;
        if (!trusted.isEmpty()) {
            this.anchors = trusted.stream().map(x509 -> new TrustAnchor((X509Certificate)x509, null)).collect(Collectors.toSet());
            this.parameter = new PKIXParameters(this.anchors);
            this.parameter.setRevocationEnabled(false);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] toBeVerified, String authType) throws CertificateException {
        if (this.verify) {
            if (toBeVerified == null || toBeVerified.length == 0) {
                throw new IllegalArgumentException("null or empty chain");
            }
            if (authType == null || authType.isEmpty()) {
                throw new IllegalArgumentException("no authentication type");
            }
            List<X509Certificate> asList = Arrays.asList(toBeVerified);
            CertPath path = cf.generateCertPath(asList);
            try {
                validator.validate(path, this.parameter);
            }
            catch (InvalidAlgorithmParameterException | CertPathValidatorException e) {
                throw new CertificateException(e);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trusted.toArray(empty);
    }

    static {
        empty = new X509Certificate[0];
        DECODER = Base64.getMimeDecoder();
        try {
            cf = CertificateFactory.getInstance("X.509");
            validator = CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

