/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.exceptions;

import aQute.bnd.exceptions.Exceptions;

@FunctionalInterface
public interface RunnableWithException {
    public void run() throws Exception;

    default public Runnable orElseThrow() {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public Runnable ignoreException() {
        return () -> {
            try {
                this.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    public static Runnable asRunnable(RunnableWithException unchecked) {
        return unchecked.orElseThrow();
    }

    public static Runnable asRunnableIgnoreException(RunnableWithException unchecked) {
        return unchecked.ignoreException();
    }
}

