/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Type;
import org.osgi.util.converter.ConverterFunction;
import org.osgi.util.converter.TargetRule;
import org.osgi.util.function.Function;

public class TypeRule<F, T>
implements TargetRule {
    private final ConverterFunction function;
    private final Type toType;

    public TypeRule(Type from, Type to, Function<F, T> func) {
        this.function = TypeRule.getFunction(from, func);
        this.toType = to;
    }

    private static <F, T> ConverterFunction getFunction(final Type from, final Function<F, T> func) {
        return new ConverterFunction(){

            @Override
            public Object apply(Object obj, Type targetType) throws Exception {
                Class cls;
                if (from instanceof Class && (cls = (Class)from).isInstance(obj)) {
                    Object res = func.apply(obj);
                    if (res != null) {
                        return res;
                    }
                    return ConverterFunction.CANNOT_HANDLE;
                }
                return ConverterFunction.CANNOT_HANDLE;
            }
        };
    }

    @Override
    public ConverterFunction getFunction() {
        return this.function;
    }

    @Override
    public Type getTargetType() {
        return this.toType;
    }
}

