/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldLong
extends JBBPAbstractField
implements JBBPNumericField {
    private static final long serialVersionUID = -7006473435241171461L;
    private final long value;

    public JBBPFieldLong(JBBPNamedFieldInfo name, long value) {
        super(name);
        this.value = value;
    }

    public static long reverseBits(long value) {
        long b0 = (long)JBBPUtils.reverseBitsInByte((byte)value) & 0xFFL;
        long b1 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 8)) & 0xFFL;
        long b2 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 16)) & 0xFFL;
        long b3 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 24)) & 0xFFL;
        long b4 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 32)) & 0xFFL;
        long b5 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 40)) & 0xFFL;
        long b6 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 48)) & 0xFFL;
        long b7 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 56)) & 0xFFL;
        return b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7;
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    @Override
    public float getAsFloat() {
        return this.value;
    }

    @Override
    public int getAsInt() {
        return (int)this.value;
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public boolean getAsBool() {
        return this.value != 0L;
    }

    @Override
    public long getAsInvertedBitOrder() {
        return JBBPFieldLong.reverseBits(this.value);
    }

    @Override
    public String getTypeAsString() {
        return "long";
    }
}

