/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalSignature;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoPublicAPI
public final class EcdhEcdsaServerKeyExchange
extends ECDHServerKeyExchange {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcdhEcdsaServerKeyExchange.class);
    private static final int HASH_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_LENGTH_BITS = 16;
    private final byte[] signatureEncoded;
    private final SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    public EcdhEcdsaServerKeyExchange(SignatureAndHashAlgorithm signatureAndHashAlgorithm, XECDHECryptography ecdhe, PrivateKey serverPrivateKey, Random clientRandom, Random serverRandom, InetSocketAddress peerAddress) throws GeneralSecurityException {
        super(ecdhe.getSupportedGroup(), ecdhe.getEncodedPoint(), peerAddress);
        if (signatureAndHashAlgorithm == null) {
            throw new NullPointerException("signature and hash algorithm cannot be null");
        }
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        ThreadLocalSignature localSignature = signatureAndHashAlgorithm.getThreadLocalSignature();
        Signature signature = (Signature)localSignature.currentWithCause();
        signature.initSign(serverPrivateKey, RandomManager.currentSecureRandom());
        this.updateSignature(signature, clientRandom, serverRandom);
        this.signatureEncoded = signature.sign();
    }

    private EcdhEcdsaServerKeyExchange(SignatureAndHashAlgorithm signatureAndHashAlgorithm, XECDHECryptography.SupportedGroup supportedGroup, byte[] encodedPoint, byte[] signatureEncoded, InetSocketAddress peerAddress) {
        super(supportedGroup, encodedPoint, peerAddress);
        if (signatureAndHashAlgorithm == null && signatureEncoded != null) {
            throw new NullPointerException("signature and hash algorithm cannot be null");
        }
        if (signatureAndHashAlgorithm != null && signatureEncoded == null) {
            throw new NullPointerException("signature cannot be null");
        }
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signatureEncoded = signatureEncoded;
    }

    @Override
    public int getMessageLength() {
        int signatureLength = this.signatureEncoded == null ? 0 : 4 + this.signatureEncoded.length;
        return this.getNamedCurveLength() + signatureLength;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        this.writeNamedCurve(writer);
        if (this.signatureEncoded != null) {
            writer.write(this.signatureAndHashAlgorithm.getHash().getCode(), 8);
            writer.write(this.signatureAndHashAlgorithm.getSignature().getCode(), 8);
            writer.write(this.signatureEncoded.length, 16);
            writer.writeBytes(this.signatureEncoded);
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) throws HandshakeException {
        ECDHServerKeyExchange.EcdhData ecdhData = EcdhEcdsaServerKeyExchange.readNamedCurve(reader, peerAddress);
        SignatureAndHashAlgorithm signAndHash = null;
        byte[] signatureEncoded = null;
        if (reader.bytesAvailable()) {
            int hashAlgorithm = reader.read(8);
            int signatureAlgorithm = reader.read(8);
            signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
            int length = reader.read(16);
            signatureEncoded = reader.readBytes(length);
        }
        return new EcdhEcdsaServerKeyExchange(signAndHash, ecdhData.supportedGroup, ecdhData.encodedPoint, signatureEncoded, peerAddress);
    }

    public void verifySignature(PublicKey serverPublicKey, Random clientRandom, Random serverRandom) throws HandshakeException {
        if (this.signatureEncoded == null) {
            String message = "The server's ECDHE key exchange message has no signature.";
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeer());
            throw new HandshakeException(message, alert);
        }
        boolean verified = false;
        try {
            ThreadLocalSignature localSignature = this.signatureAndHashAlgorithm.getThreadLocalSignature();
            Signature signature = (Signature)localSignature.currentWithCause();
            signature.initVerify(serverPublicKey);
            this.updateSignature(signature, clientRandom, serverRandom);
            verified = signature.verify(this.signatureEncoded);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not verify the server's signature.", (Throwable)e);
        }
        if (!verified) {
            String message = "The server's ECDHE key exchange message's signature could not be verified.";
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeer());
            throw new HandshakeException(message, alert);
        }
    }

    private void updateSignature(Signature signature, Random clientRandom, Random serverRandom) throws SignatureException {
        signature.update(clientRandom.getBytes());
        signature.update(serverRandom.getBytes());
        this.updateSignatureForNamedCurve(signature);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.signatureEncoded != null) {
            sb.append("\t\tSignature: ");
        }
        sb.append(this.signatureAndHashAlgorithm.toString()).append("-").append(StringUtil.byteArray2HexString((byte[])this.signatureEncoded, (char)'\u0000', (int)10));
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }
}

