# -*- coding: utf-8 -*-
# This file is part of MyPaint.
# Copyright (C) 2019 by The MyPaint Team
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# The locale dictionary is adapted from the locale/language table found at
# https://github.com/nohamelin/simple-locale-switcher/wiki/Language-Names-for-Locale-Codes

# NOTE! This list is extended/adapted to fit the existing translation files!
# Do not use it as a valid reference for how to handle locale names!
LOCALE_DICT = {
    "ach": ("Acholi", "Acholi"),
    "af": ("Afrikaans", "Afrikaans"),
    "an": ("Aragonese", "aragonés"),
    "ar": ("Arabic", "عربي"),
    "as": ("Assamese", "অসমীয়া"),
    "ast": ("Asturian", "Asturianu"),
    "az": ("Azerbaijani", "Azərbaycanca"),
    "be": ("Belarusian", "Беларуская"),
    "bg": ("Bulgarian", "Български"),
    "bn_BD": ("Bengali (Bangladesh)", "বাংলা (বাংলাদেশ)"),
    "bn": ("Bengali (India)", "বাংলা (ভারত)"),
    "br": ("Breton", "Brezhoneg"),
    "brx": ("Bodo", "बर'/बड़"),
    "bs": ("Bosnian", "Bosanski"),
    "ca": ("Catalan", "Català"),
    "ca@valencia": ("Valencian", "Valenciano"),
    "ckb": ("Kurdî", "کوردی"),
    "cs": ("Czech", "Čeština"),
    "csb": ("Kashubian", "Kaszëbsczi jãzëk"),
    "cy": ("Welsh", "Cymraeg"),
    "da": ("Danish", "Dansk"),
    "de": ("German", "Deutsch"),
    "dsb": ("Lower Sorbian", "Dolnoserbšćina"),
    "dz": ("Dzongkha", "རྫོང་ཁ་"),
    "el": ("Greek", "Ελληνικά"),
    "en_GB": ("English (British)", "English (British)"),
    "en_CA": ("English (Canadian)", "English (Canadian)"),
    "en_US": ("English (US)", "English (US)"),
    "en_ZA": ("English (South African)", "English (South African)"),
    "eo": ("Esperanto", "Esperanto"),
    "es": ("Spanish", "Español"),
    "es_AR": ("Spanish (Argentina)", "Español (de Argentina)"),
    "es_CL": ("Spanish (Chile)", "Español (de Chile)"),
    "es_ES": ("Spanish (Spain)", "Español (de España)"),
    "es_MX": ("Spanish (Mexico)", "Español (de México)"),
    "et": ("Estonian", "Eesti keel"),
    "eu": ("Basque", "Euskara"),
    "fa": ("Persian", "فارسی"),
    "ff": ("Fulah", "Pulaar-Fulfulde"),
    "fi": ("Finnish", "suomi"),
    "fr": ("French", "Français"),
    "fy": ("Western Frisian", "Westerlauwersk Frysk"),
    "fy_NL": ("Frisian", "Frysk"),
    "ga": ("Irish", "Gaeilge"),
    "gd": ("Gaelic (Scotland)", "Gàidhlig"),
    "gl": ("Galician", "Galego"),
    "gn": ("Guarani", "Avañe'ẽ"),
    "gu": ("Gujarati (India)", "ગુજરાતી (ભારત)"),
    "he": ("Hebrew", "עברית"),
    "hi": ("Hindi (India)", "हिन्दी (भारत)"),
    "hr": ("Croatian", "Hrvatski"),
    "hsb": ("Upper Sorbian", "Hornjoserbsce"),
    "hu": ("Hungarian", "magyar"),
    "hy": ("Armenian", "Հայերեն"),
    "id": ("Indonesian", "Bahasa Indonesia"),
    "is": ("Icelandic", "íslenska"),
    "it": ("Italian", "Italiano"),
    "ja": ("Japanese", "日本語"),
    "ka": ("Georgian", "ქართული ენა"),
    "kab": ("Kabyle", "Kabyle"),
    "kk": ("Kazakh", "Қазақ"),
    "km": ("Khmer", "ខ្មែរ"),
    "kn": ("Kannada", "ಕನ್ನಡ"),
    "ko": ("Korean", "한국어"),
    "lij": ("Ligurian", "Ligure"),
    "lt": ("Lithuanian", "lietuvių kalba"),
    "lv": ("Latvian", "Latviešu"),
    "mai": ("Maithili", "मैथिली মৈথিলী"),
    "mk": ("Macedonian", "Македонски"),
    "ml": ("Malayalam", "മലയാളം"),
    "mn": ("Mongolian", "Монгол"),
    "mr": ("Marathi", "मराठी"),
    "ms": ("Malay", "Melayu"),
    "nb": ("Norwegian (Bokmål)", "Norsk bokmål"),
    "nl": ("Dutch", "Nederlands"),
    "nn_NO": ("Norwegian (Nynorsk)", "Norsk nynorsk"),
    "oc": ("Occitan", "Occitan"),
    "or": ("Oriya", "ଓଡ଼ିଆ"),
    "pa": ("Punjabi (India)", "ਪੰਜਾਬੀ (ਭਾਰਤ)"),
    "pl": ("Polish", "Polski"),
    "pt_BR": ("Portuguese (Brazilian)", "Português (do Brasil)"),
    "pt": ("Portuguese (Portugal)", "Português (Europeu)"),
    "rm": ("Romansh", "rumantsch"),
    "ro": ("Romanian", "Română"),
    "ru": ("Russian", "Русский"),
    "se": ("Northern Sami", "Davvisámegiella"),
    "si": ("Sinhala", "සිංහල"),
    "sk": ("Slovak", "slovenčina"),
    "sl": ("Slovenian", "Slovenščina"),
    "son": ("Songhai", "Soŋay"),
    "sq": ("Albanian", "Shqip"),
    "sr": ("Serbian", "Српски"),
    "sr@latin": ("Serbian (Latin)", "Srpski"),
    "sv": ("Swedish", "Svenska"),
    "ta": ("Tamil", "தமிழ்"),
    "te": ("Telugu", "తెలుగు"),
    "tg": ("Tajik", "забо́ни тоҷикӣ́"),
    "th": ("Thai", "ไทย"),
    "tr": ("Turkish", "Türkçe"),
    "uk": ("Ukrainian", "Українська"),
    "uz": ("Uzbek", "Oʻzbek tili"),
    "vi": ("Vietnamese", "Tiếng Việt"),
    "wa": ("Walloon", "Walon"),
    "xh": ("Xhosa", "isiXhosa"),
    "zh_CN": ("Chinese (Simplified)", "中文 (简体)"),
    "zh_HK": ("Chinese - Hong Kong (Traditional)", ""),
    "zh_TW": ("Chinese (Traditional)", "正體中文 (繁體)"),
}
