/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import org.jhotdraw.gui.AttributeEditor;
import org.jhotdraw.gui.JLifeFormattedTextArea;
import org.jhotdraw.util.ResourceBundleUtil;

public class JAttributeTextArea<T>
extends JLifeFormattedTextArea
implements AttributeEditor<T> {
    private boolean isMultipleValues;

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isFocusOwner() && this.isMultipleValues) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            Color color = this.getForeground();
            this.setForeground(new Color(0, true));
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            Insets insets2 = this.getMargin();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            graphics.setFont(this.getFont().deriveFont(2));
            this.setForeground(color);
            graphics.setColor(color);
            graphics.drawString(resourceBundleUtil.getString("attribute.multipleValues.text"), insets.left + insets2.left, insets.top + insets2.top + fontMetrics.getAscent());
        } else {
            super.paintComponent(graphics);
        }
    }

    private void initComponents() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public T getAttributeValue() {
        return (T)this.getValue();
    }

    @Override
    public void setMultipleValues(boolean bl) {
        this.isMultipleValues = bl;
        this.repaint();
    }

    @Override
    public boolean isMultipleValues() {
        return this.isMultipleValues;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isFocusOwner();
    }

    @Override
    public void setAttributeValue(T t) {
        this.setValue(t);
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
        if (string == "value") {
            super.firePropertyChange("attributeValue", object, object2);
        }
    }
}

