/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.SmallRyeConfig;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Recorder
public class DeprecatedRuntimePropertiesRecorder {
    private static final Logger log = Logger.getLogger(DeprecatedRuntimePropertiesRecorder.class);

    public void reportDeprecatedProperties(Set<String> deprecatedRuntimeProperties) {
        Config config = ConfigProvider.getConfig();
        for (String property : config.getPropertyNames()) {
            String configSourceName;
            if (!deprecatedRuntimeProperties.contains(property) || "DefaultValuesConfigSource".equals(configSourceName = ((SmallRyeConfig)config).getConfigValue(property).getConfigSourceName())) continue;
            log.warnf("The '%s' config property is deprecated and should not be used anymore", (Object)property);
        }
    }
}

