/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.config.DeprecatedMetadata;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class Option<T> {
    private final Class<T> type;
    private final String key;
    private final OptionCategory category;
    private final boolean hidden;
    private final boolean buildTime;
    private final String description;
    private final Optional<T> defaultValue;
    private final List<String> expectedValues;
    private final boolean strictExpectedValues;
    private final boolean caseInsensitiveExpectedValues;
    private final DeprecatedMetadata deprecatedMetadata;

    public Option(Class<T> type, String key, OptionCategory category, boolean hidden, boolean buildTime, String description, Optional<T> defaultValue, List<String> expectedValues, boolean strictExpectedValues, boolean caseInsensitiveExpectedValues, DeprecatedMetadata deprecatedMetadata) {
        this.type = type;
        this.key = key;
        this.category = category;
        this.hidden = hidden;
        this.buildTime = buildTime;
        this.description = Option.getDescriptionByCategorySupportLevel(description, category);
        this.defaultValue = defaultValue;
        this.expectedValues = expectedValues;
        this.strictExpectedValues = strictExpectedValues;
        this.caseInsensitiveExpectedValues = caseInsensitiveExpectedValues;
        this.deprecatedMetadata = deprecatedMetadata;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isBuildTime() {
        return this.buildTime;
    }

    public String getKey() {
        return this.key;
    }

    public OptionCategory getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<T> getDefaultValue() {
        return this.defaultValue;
    }

    public List<String> getExpectedValues() {
        return this.expectedValues;
    }

    public boolean isStrictExpectedValues() {
        return this.strictExpectedValues;
    }

    public boolean isCaseInsensitiveExpectedValues() {
        return this.caseInsensitiveExpectedValues;
    }

    public Optional<DeprecatedMetadata> getDeprecatedMetadata() {
        return Optional.ofNullable(this.deprecatedMetadata);
    }

    public Option<T> withRuntimeSpecificDefault(T defaultValue) {
        return this.toBuilder().defaultValue(defaultValue).build();
    }

    public OptionBuilder<T> toBuilder() {
        OptionBuilder<Optional<T>> builder = new OptionBuilder<T>(this.key, this.type).category(this.category).buildTime(this.buildTime).description(this.description).defaultValue(this.defaultValue).expectedValues(this.expectedValues).strictExpectedValues(this.strictExpectedValues).caseInsensitiveExpectedValues(this.caseInsensitiveExpectedValues).deprecatedMetadata(this.deprecatedMetadata);
        if (this.hidden) {
            builder.hidden();
        }
        return builder;
    }

    private static String getDescriptionByCategorySupportLevel(String description, OptionCategory category) {
        if (description != null && !((String)description).isBlank()) {
            switch (category.getSupportLevel()) {
                case PREVIEW: {
                    description = "Preview: " + (String)description;
                    break;
                }
                case EXPERIMENTAL: {
                    description = "Experimental: " + (String)description;
                    break;
                }
            }
        }
        return description;
    }

    public static String getDefaultValueString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        return String.valueOf(value);
    }
}

