/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.StickySessionEncoderProvider;
import org.keycloak.sessions.StickySessionEncoderProviderFactory;

public class RemoteStickySessionEncoderProviderFactory
implements StickySessionEncoderProviderFactory,
EnvironmentDependentProviderFactory {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final char SEPARATOR = '.';
    private static final StickySessionEncoderProvider NO_ROUTER_PROVIDER = new BaseProvider(){

        public String encodeSessionId(String sessionId) {
            return sessionId;
        }

        public boolean shouldAttachRoute() {
            return false;
        }
    };
    private volatile boolean shouldAttachRoute;
    private volatile StickySessionEncoderProvider provider;

    public StickySessionEncoderProvider create(KeycloakSession session) {
        return this.shouldAttachRoute ? this.provider : NO_ROUTER_PROVIDER;
    }

    public void init(Config.Scope config) {
        this.setShouldAttachRoute(config.getBoolean("shouldAttachRoute", Boolean.valueOf(true)));
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            this.provider = new AttachRouteProvider(RemoteStickySessionEncoderProviderFactory.getRoute(session));
        }
    }

    public void close() {
    }

    public String getId() {
        return "remote";
    }

    public int order() {
        return 1;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("shouldAttachRoute").type("boolean").helpText("If the route should be attached to cookies to reflect the node that owns a particular session.").defaultValue((Object)true).add().build();
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    public void setShouldAttachRoute(boolean shouldAttachRoute) {
        this.shouldAttachRoute = shouldAttachRoute;
        log.debugf("Should attach route to the sticky session cookie: %b", (Object)shouldAttachRoute);
    }

    private static String getRoute(KeycloakSession session) {
        return InfinispanUtil.getTopologyInfo(session).getMyNodeName();
    }

    private static class AttachRouteProvider
    extends BaseProvider {
        private final String route;

        private AttachRouteProvider(String route) {
            this.route = route;
        }

        public String encodeSessionId(String sessionId) {
            return sessionId + "." + this.route;
        }

        public boolean shouldAttachRoute() {
            return true;
        }
    }

    private static abstract class BaseProvider
    implements StickySessionEncoderProvider {
        private BaseProvider() {
        }

        public final String decodeSessionId(String encodedSessionId) {
            int index = encodedSessionId.indexOf(46);
            return index == -1 ? encodedSessionId : encodedSessionId.substring(0, index);
        }

        public final void close() {
        }
    }
}

